/*
 * Decompiled with CFR 0.152.
 */
package mva3.adapter;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.DiffUtil;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.ListUpdateCallback;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.SpanSizeLookup;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import mva3.adapter.Section;
import mva3.adapter.internal.DiffUtilCallback;
import mva3.adapter.internal.ItemMetaData;
import mva3.adapter.internal.RecyclerItem;
import mva3.adapter.util.Mode;
import mva3.adapter.util.MvaDiffUtil;
import mva3.adapter.util.OnItemClickListener;
import mva3.adapter.util.OnSelectionChangedListener;
import mva3.adapter.util.PayloadProvider;
import mva3.adapter.util.SwipeToDismissListener;

public class ListSection<M>
extends Section {
    private PayloadProvider<M> payloadProvider;
    private List<M> dataList;
    private List<ItemMetaData> metaDataList;
    private final ListUpdateCallback listUpdateCallback = new ListUpdateCallback(){

        public void onInserted(int position, int count) {
            for (int i = position; i < position + count; ++i) {
                ListSection.this.metaDataList.add(i, new ItemMetaData());
            }
            ListSection.super.onInserted(position, count);
        }

        public void onRemoved(int position, int count) {
            if (position + count > position) {
                ListSection.this.metaDataList.subList(position, position + count).clear();
            }
            ListSection.super.onRemoved(position, count);
        }

        public void onMoved(int fromPosition, int toPosition) {
            Collections.swap(ListSection.this.metaDataList, fromPosition, toPosition);
            ListSection.super.onMoved(fromPosition, toPosition);
        }

        public void onChanged(int position, int count, Object payload) {
            ListSection.super.onChanged(position, count, payload);
        }
    };
    private OnItemClickListener<M> onItemClickListener;
    private MvaDiffUtil<M> diffUtil = new MvaDiffUtil<M>(){

        @Override
        public void calculateDiff(ListUpdateCallback listUpdateCallback, List<M> oldList, List<M> newList) {
            DiffUtil.calculateDiff((DiffUtil.Callback)new DiffUtilCallback<M>(oldList, newList){

                @Override
                public boolean areItemsTheSame(M oldItem, M newItem) {
                    return ListSection.this.payloadProvider.areItemsTheSame(oldItem, newItem);
                }

                @Override
                public boolean areContentsTheSame(M oldItem, M newItem) {
                    return ListSection.this.payloadProvider.areContentsTheSame(oldItem, newItem);
                }

                @Override
                public Object getChangePayload(M oldItem, M newItem) {
                    return ListSection.this.payloadProvider.getChangePayload(oldItem, newItem);
                }
            }).dispatchUpdatesTo(listUpdateCallback);
        }
    };
    private SwipeToDismissListener<M> swipeToDismissListener;
    private OnSelectionChangedListener<M> onSelectionChangedListener;

    public ListSection() {
        this(new PayloadProvider<M>(){

            @Override
            public boolean areContentsTheSame(M oldItem, M newItem) {
                return oldItem.equals(newItem);
            }

            @Override
            public boolean areItemsTheSame(M oldItem, M newItem) {
                return oldItem.equals(newItem);
            }

            @Override
            public Object getChangePayload(M oldItem, M newItem) {
                return null;
            }
        });
    }

    public ListSection(PayloadProvider<M> payloadProvider) {
        this.dataList = new ArrayList<M>();
        this.metaDataList = new ArrayList<ItemMetaData>();
        this.payloadProvider = payloadProvider;
    }

    public void add(M item) {
        this.add(this.dataList.size(), item);
    }

    public void add(int index, M item) {
        this.add(index, item, this.isSectionVisible());
    }

    public boolean addAll(@NonNull Collection<? extends M> items) {
        return this.addAll(this.dataList.size(), items);
    }

    public boolean addAll(int index, @NonNull Collection<? extends M> items) {
        return this.addAll(index, items, this.isSectionVisible());
    }

    public void clear() {
        if (this.size() <= 0) {
            return;
        }
        int oldSize = this.dataList.size();
        this.dataList.clear();
        this.metaDataList.clear();
        if (this.isSectionVisible()) {
            this.onRemoved(0, oldSize);
        }
    }

    public void clearSelections() {
        this.clearAllSelections();
    }

    public M get(int index) {
        return this.dataList.get(index);
    }

    public List<M> getData() {
        return new ArrayList<M>(this.dataList);
    }

    public List<M> getSelectedItems() {
        ArrayList<M> selectedItems = new ArrayList<M>();
        int position = 0;
        for (ItemMetaData itemMetaData : this.metaDataList) {
            if (itemMetaData.isSelected()) {
                selectedItems.add(this.dataList.get(position));
            }
            ++position;
        }
        return selectedItems;
    }

    public void remove(int index) {
        this.dataList.remove(index);
        this.metaDataList.remove(index);
        if (this.isSectionVisible()) {
            this.onRemoved(index, 1);
        }
    }

    public void set(List<M> items) {
        ArrayList<M> oldItems = new ArrayList<M>(this.dataList);
        ArrayList<M> newItems = new ArrayList<M>(items);
        this.dataList = new ArrayList<M>(items);
        if (this.isSectionVisible()) {
            this.diffUtil.calculateDiff(this.listUpdateCallback, oldItems, newItems);
        }
    }

    public void set(int index, M item) {
        M oldItem = this.dataList.get(index);
        this.dataList.set(index, item);
        this.onChanged(index, 1, this.payloadProvider.getChangePayload(oldItem, item));
    }

    public void setDiffUtil(MvaDiffUtil<M> diffUtil) {
        this.diffUtil = diffUtil;
    }

    public void setOnItemClickListener(OnItemClickListener<M> itemClickListener) {
        this.onItemClickListener = itemClickListener;
    }

    public void setOnSelectionChangedListener(OnSelectionChangedListener<M> selectionChangedListener) {
        this.onSelectionChangedListener = selectionChangedListener;
    }

    public void setPayloadProvider(PayloadProvider<M> payloadProvider) {
        this.payloadProvider = payloadProvider;
    }

    public void setSwipeToDismissListener(SwipeToDismissListener<M> swipeToDismissListener) {
        this.swipeToDismissListener = swipeToDismissListener;
    }

    public int size() {
        return this.dataList.size();
    }

    @Override
    void onItemClicked(int position) {
        if (null != this.onItemClickListener) {
            this.onItemClickListener.onItemClicked(position, this.get(position));
        }
    }

    @Override
    Object getItem(int position) {
        return this.dataList.get(position);
    }

    @Override
    int getCount() {
        return this.isSectionVisible() ? this.dataList.size() : 0;
    }

    @Override
    boolean isItemSelected(int adapterPosition) {
        return this.metaDataList.get(adapterPosition).isSelected();
    }

    @Override
    void onItemSelectionToggled(int itemPosition, @NonNull Mode selectionMode) {
        Mode selectionModeToHonor;
        Mode mode = selectionModeToHonor = itemPosition < this.getCount() && itemPosition >= 0 ? this.getModeToHonor(selectionMode, this.selectionMode) : selectionMode;
        if (selectionModeToHonor == Mode.SINGLE) {
            this.toggleCurrentSelection(itemPosition);
        } else if (selectionModeToHonor == Mode.MULTIPLE) {
            this.toggleItemSelection(itemPosition);
        }
    }

    @Override
    void clearAllSelections() {
        int itemPosition = 0;
        for (ItemMetaData itemMetaData : this.metaDataList) {
            if (itemMetaData.isSelected()) {
                itemMetaData.setSelected(false);
                this.onChanged(itemPosition, 1, "selection_payload");
            }
            ++itemPosition;
        }
    }

    @Override
    boolean isItemExpanded(int adapterPosition) {
        return this.metaDataList.get(adapterPosition).isExpanded();
    }

    @Override
    void onItemExpansionToggled(int itemPosition, @NonNull Mode expansionMode) {
        Mode expansionModeToHonor;
        Mode mode = expansionModeToHonor = itemPosition < this.getCount() && itemPosition >= 0 ? this.getModeToHonor(expansionMode, this.expansionMode) : expansionMode;
        if (expansionModeToHonor == Mode.SINGLE) {
            this.toggleCurrentExpansion(itemPosition);
        } else if (expansionModeToHonor == Mode.MULTIPLE) {
            this.toggleItemExpansion(itemPosition);
        }
    }

    @Override
    void collapseAllItems() {
        int itemPosition = 0;
        for (ItemMetaData itemMetaData : this.metaDataList) {
            if (itemMetaData.isExpanded()) {
                itemMetaData.setExpanded(false);
                this.onChanged(itemPosition, 1, "item_expansion_payload");
            }
            ++itemPosition;
        }
    }

    @Override
    int onSectionExpansionToggled(int itemPosition, @NonNull Mode sectionExpansionMode) {
        return itemPosition - this.getCount();
    }

    @Override
    int getPositionType(int itemPosition, int adapterPosition, RecyclerView.LayoutManager layoutManager) {
        return layoutManager instanceof GridLayoutManager ? this.getPositionTypeGrid(itemPosition, adapterPosition, (GridLayoutManager)layoutManager) : this.getPositionTypeLinear(itemPosition, layoutManager);
    }

    @Override
    void onItemDismiss(int itemPosition) {
        M m = this.dataList.remove(itemPosition);
        this.metaDataList.remove(itemPosition);
        this.onRemoved(itemPosition, 1);
        if (null != this.swipeToDismissListener) {
            this.swipeToDismissListener.onItemDismissed(itemPosition, m);
        }
    }

    @Override
    boolean move(int itemPosition, int targetOffset) {
        int offset = targetOffset > 0 ? 1 : -1;
        int currentPosition = itemPosition;
        int i = 0;
        while (i < targetOffset * offset) {
            Collections.swap(this.dataList, currentPosition, currentPosition + offset);
            ++i;
            currentPosition += offset;
        }
        this.listUpdateCallback.onMoved(itemPosition, itemPosition + targetOffset);
        return false;
    }

    @Override
    RecyclerItem startMovingItem(int itemPosition) {
        return new RecyclerItem<M>(this.dataList.remove(itemPosition), this.metaDataList.remove(itemPosition));
    }

    @Override
    void finishMovingItem(int currentPosition, RecyclerItem itemToMove) {
        this.dataList.add(currentPosition, itemToMove.getItem());
        this.metaDataList.add(currentPosition, itemToMove.getItemMetaData());
    }

    private void add(int index, @NonNull M item, boolean notifyChanges) {
        this.dataList.add(index, item);
        this.metaDataList.add(index, new ItemMetaData());
        if (notifyChanges) {
            this.onInserted(index, 1);
        }
    }

    private boolean addAll(int index, @NonNull Collection<? extends M> items, boolean notifyDataSetChanged) {
        boolean result = this.dataList.addAll(index, items);
        if (result) {
            for (int i = index; i < items.size() + index; ++i) {
                this.metaDataList.add(new ItemMetaData());
            }
            if (notifyDataSetChanged) {
                this.onInserted(index, items.size());
            }
        }
        return result;
    }

    private int getPositionTypeGrid(int itemPosition, int adapterPosition, GridLayoutManager layoutManager) {
        boolean isReverseLayout = this.isReverseLayout((RecyclerView.LayoutManager)layoutManager);
        boolean isVertical = this.isVertical((RecyclerView.LayoutManager)layoutManager);
        int maxSpanCount = layoutManager.getSpanCount();
        SpanSizeLookup spanSizeLookup = (SpanSizeLookup)layoutManager.getSpanSizeLookup();
        int itemPositionType = 0;
        int positionOffset = adapterPosition - itemPosition;
        int currentSpanIndex = spanSizeLookup.getCachedSpanIndex(adapterPosition, maxSpanCount);
        int currentSpan = spanSizeLookup.getSpanSize(adapterPosition);
        boolean isLeft = currentSpanIndex == 0;
        boolean isRight = currentSpanIndex + currentSpan == maxSpanCount;
        int currentGroupIndex = spanSizeLookup.getSpanGroupIndex(adapterPosition, maxSpanCount);
        boolean isTop = itemPosition == 0 || itemPosition <= maxSpanCount && !isLeft && currentGroupIndex - spanSizeLookup.getSpanGroupIndex(positionOffset, maxSpanCount) == 0;
        boolean isBottom = true;
        if (maxSpanCount - currentSpanIndex - currentSpan < this.getCount() - itemPosition - 1) {
            isBottom = false;
        } else {
            for (int looper = adapterPosition + 1; looper < positionOffset + this.getCount(); ++looper) {
                int groupIndex = spanSizeLookup.getSpanGroupIndex(looper, maxSpanCount);
                if (currentGroupIndex >= groupIndex) continue;
                isBottom = false;
                break;
            }
        }
        if (isLeft) {
            itemPositionType |= isVertical ? 1 : 2;
        }
        if (isRight) {
            itemPositionType |= isVertical ? 4 : 8;
        }
        if (isTop) {
            itemPositionType |= isVertical ? (isReverseLayout ? 8 : 2) : (isReverseLayout ? 4 : 1);
        }
        if (isBottom) {
            itemPositionType |= isVertical ? (isReverseLayout ? 2 : 8) : (isReverseLayout ? 1 : 4);
        }
        return itemPositionType;
    }

    private int getPositionTypeLinear(int itemPosition, RecyclerView.LayoutManager layoutManager) {
        boolean isLastItem;
        boolean isFirstItem;
        int positionType = 0;
        boolean isReverseLayout = this.isReverseLayout(layoutManager);
        boolean isVertical = this.isVertical(layoutManager);
        boolean bl = isReverseLayout ? this.getCount() - 1 == itemPosition : (isFirstItem = itemPosition == 0);
        if (isFirstItem) {
            positionType |= isVertical ? 2 : 1;
        }
        boolean bl2 = isReverseLayout ? itemPosition == 0 : (isLastItem = this.getCount() - 1 == itemPosition);
        if (isLastItem) {
            positionType |= isVertical ? 8 : 4;
        }
        positionType |= isVertical ? 1 : 2;
        return positionType |= isVertical ? 4 : 8;
    }

    private void toggleCurrentExpansion(int itemPosition) {
        int count = 0;
        for (ItemMetaData itemMetaData : this.metaDataList) {
            if (count == itemPosition) {
                if (itemMetaData.isExpanded()) {
                    itemMetaData.setExpanded(!itemMetaData.isExpanded());
                    this.onChanged(count, 1, "item_expansion_payload");
                    break;
                }
                itemMetaData.setExpanded(!itemMetaData.isExpanded());
                this.onChanged(count, 1, "item_expansion_payload");
            } else if (itemMetaData.isExpanded()) {
                itemMetaData.setExpanded(false);
                this.onChanged(count, 1, "item_expansion_payload");
                if (itemPosition < 0) break;
            }
            ++count;
        }
    }

    private void toggleCurrentSelection(int itemPosition) {
        int count = 0;
        for (ItemMetaData itemMetaData : this.metaDataList) {
            if (count == itemPosition) {
                if (itemMetaData.isSelected()) {
                    itemMetaData.setSelected(!itemMetaData.isSelected());
                    this.onChanged(count, 1, "selection_payload");
                    this.notifySelectionChanged(count);
                    break;
                }
                itemMetaData.setSelected(!itemMetaData.isSelected());
                this.onChanged(count, 1, "selection_payload");
                this.notifySelectionChanged(count);
                itemPosition = -1;
            } else if (itemMetaData.isSelected()) {
                itemMetaData.setSelected(false);
                this.onChanged(count, 1, "selection_payload");
                this.notifySelectionChanged(count);
            }
            ++count;
        }
    }

    private void toggleItemExpansion(int itemPosition) {
        if (itemPosition < this.getCount() && itemPosition >= 0) {
            ItemMetaData itemMetaData;
            itemMetaData.setExpanded(!(itemMetaData = this.metaDataList.get(itemPosition)).isExpanded());
            this.onChanged(itemPosition, 1, "item_expansion_payload");
        }
    }

    private void toggleItemSelection(int itemPosition) {
        if (itemPosition < this.getCount() && itemPosition >= 0) {
            ItemMetaData itemMetaData;
            itemMetaData.setSelected(!(itemMetaData = this.metaDataList.get(itemPosition)).isSelected());
            this.onChanged(itemPosition, 1, "selection_payload");
            this.notifySelectionChanged(itemPosition);
        }
    }

    private void notifySelectionChanged(int itemPosition) {
        if (this.onSelectionChangedListener != null) {
            this.onSelectionChangedListener.onSelectionChanged(this.dataList.get(itemPosition), this.metaDataList.get(itemPosition).isSelected(), this.getSelectedItems());
        }
    }
}

