/*
 * Decompiled with CFR 0.152.
 */
package mva3.adapter;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import mva3.adapter.ItemSection;
import mva3.adapter.NestedSection;
import mva3.adapter.Section;
import mva3.adapter.internal.Notifier;
import mva3.adapter.util.Mode;

public class HeaderSection<H>
extends NestedSection
implements Notifier {
    private final ItemSection<H> itemSection = new ItemSection();
    private final NestedSection nestedSection = new NestedSection();

    public HeaderSection() {
        super.addSection(this.itemSection);
        super.addSection(this.nestedSection);
    }

    public HeaderSection(@NonNull H header) {
        this();
        this.itemSection.setItem(header);
    }

    public H getHeader() {
        return this.itemSection.getItem();
    }

    public void setHeader(@NonNull H header) {
        this.itemSection.setItem(header);
    }

    @Override
    public void addSection(Section section) {
        this.nestedSection.addSection(section);
    }

    @Override
    void collapseSection() {
        if (this.nestedSection.isSectionVisible()) {
            this.nestedSection.hideSection();
            this.onChanged(0, 1, "section_expansion_payload");
        }
    }

    @Override
    boolean isSectionExpanded(int itemPosition) {
        return this.nestedSection.isSectionVisible();
    }

    @Override
    int onSectionExpansionToggled(int itemPosition, @NonNull Mode sectionExpansionMode) {
        Mode mode = this.getModeToHonor(sectionExpansionMode, this.sectionExpansionMode);
        int prevCount = this.getCount();
        switch (mode) {
            case SINGLE: {
                if (itemPosition < this.getCount() && itemPosition >= 0) {
                    if (!this.nestedSection.isSectionVisible()) {
                        this.nestedSection.showSection();
                    } else {
                        this.nestedSection.hideSection();
                    }
                    this.onChanged(0, 1, "section_expansion_payload");
                } else if (this.nestedSection.isSectionVisible()) {
                    this.nestedSection.hideSection();
                    this.onChanged(0, 1, "section_expansion_payload");
                }
                return itemPosition - prevCount;
            }
            case MULTIPLE: {
                if (itemPosition < this.getCount() && itemPosition >= 0) {
                    if (!this.nestedSection.isSectionVisible()) {
                        this.nestedSection.showSection();
                    } else {
                        this.nestedSection.hideSection();
                    }
                    this.onChanged(0, 1, "section_expansion_payload");
                }
                return itemPosition - prevCount;
            }
        }
        return itemPosition - prevCount;
    }

    @Override
    int getPositionType(int itemPosition, int adapterPosition, RecyclerView.LayoutManager layoutManager) {
        int result = super.getPositionType(itemPosition, adapterPosition, layoutManager);
        if (itemPosition == 0 && this.getCount() > 1) {
            result ^= 8;
        } else if (itemPosition != 0 && (result & 2) == 2) {
            result ^= 2;
        }
        return result;
    }
}

