/*
 * Decompiled with CFR 0.152.
 */
package mva3.adapter.internal;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.ItemTouchHelper;
import androidx.recyclerview.widget.RecyclerView;
import mva3.adapter.ItemViewHolder;
import mva3.adapter.MultiViewAdapter;

public final class ItemTouchCallback
extends ItemTouchHelper.Callback {
    private final MultiViewAdapter adapter;

    public ItemTouchCallback(MultiViewAdapter adapter) {
        this.adapter = adapter;
    }

    public int getMovementFlags(@NonNull RecyclerView recyclerView, @NonNull RecyclerView.ViewHolder viewHolder) {
        if (viewHolder instanceof ItemViewHolder) {
            ItemViewHolder itemViewHolder = (ItemViewHolder)viewHolder;
            int dragFlags = itemViewHolder.getDragDirections();
            int swipeFlags = itemViewHolder.getSwipeDirections();
            return ItemTouchCallback.makeMovementFlags((int)dragFlags, (int)swipeFlags);
        }
        return -1;
    }

    public boolean onMove(@NonNull RecyclerView recyclerView, RecyclerView.ViewHolder source, RecyclerView.ViewHolder target) {
        if (source.getItemViewType() != target.getItemViewType()) {
            return false;
        }
        this.adapter.onMove(source.getAdapterPosition(), target.getAdapterPosition());
        return true;
    }

    public boolean isLongPressDragEnabled() {
        return false;
    }

    public boolean isItemViewSwipeEnabled() {
        return true;
    }

    public void onSwiped(RecyclerView.ViewHolder viewHolder, int direction) {
        this.adapter.onItemDismiss(viewHolder.getAdapterPosition());
    }
}

