/*
 * Decompiled with CFR 0.152.
 */
package mva3.adapter.decorator;

import android.graphics.Canvas;
import android.graphics.Rect;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import mva3.adapter.MultiViewAdapter;
import mva3.adapter.decorator.SectionPositionType;

public abstract class Decorator {
    private MultiViewAdapter adapter;

    public Decorator(MultiViewAdapter adapter) {
        this.adapter = adapter;
    }

    public void addToRect(Rect outRect, int left, int top, int right, int bottom) {
        outRect.left += left;
        outRect.top += top;
        outRect.right += right;
        outRect.bottom += bottom;
    }

    public int getPositionType(int adapterPosition, RecyclerView parent) {
        return this.adapter.getPositionType(parent, adapterPosition);
    }

    public SectionPositionType getSectionPositionType(int adapterPosition) {
        return this.adapter.getSectionPositionType(adapterPosition);
    }

    public boolean isFirst(int positionType) {
        return this.isItemOnTopEdge(positionType);
    }

    public boolean isItemOnBottomEdge(int positionType) {
        return (positionType & 8) == 8;
    }

    public boolean isItemOnLeftEdge(int positionType) {
        return (positionType & 1) == 1;
    }

    public boolean isItemOnRightEdge(int positionType) {
        return (positionType & 4) == 4;
    }

    public boolean isItemOnTopEdge(int positionType) {
        return (positionType & 2) == 2;
    }

    public boolean isLast(int positionType) {
        return this.isItemOnBottomEdge(positionType);
    }

    public void onDraw(@NonNull Canvas canvas, @NonNull RecyclerView parent, @NonNull RecyclerView.State state, View child, int adapterPosition) {
    }

    public void onDrawOver(@NonNull Canvas canvas, @NonNull RecyclerView parent, @NonNull RecyclerView.State state, View child, int adapterPosition) {
    }

    public abstract void getItemOffsets(@NonNull Rect var1, @NonNull View var2, @NonNull RecyclerView var3, @NonNull RecyclerView.State var4, int var5);
}

