/*
 * Decompiled with CFR 0.152.
 */
package mva3.adapter.util;

import android.view.ViewGroup;
import androidx.annotation.LayoutRes;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.StaggeredGridLayoutManager;
import mva3.adapter.ItemBinder;
import mva3.adapter.ItemSection;
import mva3.adapter.ItemViewHolder;

public abstract class InfiniteLoadingHelper {
    private final InfiniteLoadingItemBinder itemBinder;
    private int totalPageCount;
    private ItemSection<String> footerSection;
    private int currentPage = 0;
    private boolean isLoading = false;
    private boolean canLoadMore = false;

    public InfiniteLoadingHelper(RecyclerView recyclerView, @LayoutRes int layoutId) {
        this(recyclerView, layoutId, Integer.MAX_VALUE);
    }

    public InfiniteLoadingHelper(RecyclerView recyclerView, @LayoutRes int layoutId, int totalPageCount) {
        this.itemBinder = new InfiniteLoadingItemBinder(layoutId);
        this.totalPageCount = totalPageCount;
        InfiniteScrollListener infiniteScrollListener = new InfiniteScrollListener(this);
        recyclerView.addOnScrollListener((RecyclerView.OnScrollListener)infiniteScrollListener);
    }

    public void markAllPagesLoaded() {
        this.completeLoading();
    }

    public void markCurrentPageLoaded() {
        this.isLoading = false;
        if (!this.canLoadMore) {
            this.completeLoading();
        }
    }

    public void setPageCount(int totalPageCount) {
        if (totalPageCount > this.currentPage && !this.canLoadMore) {
            this.canLoadMore = true;
            this.footerSection.showSection();
        }
        if (totalPageCount < this.currentPage) {
            this.completeLoading();
        }
        this.totalPageCount = totalPageCount;
    }

    public abstract void onLoadNextPage(int var1);

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public final ItemBinder<String, ItemViewHolder<String>> getItemBinder() {
        return this.itemBinder;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public final void setFooterSection(ItemSection<String> footerSection) {
        this.canLoadMore = true;
        this.footerSection = footerSection;
    }

    private void completeLoading() {
        this.canLoadMore = false;
        this.footerSection.hideSection();
    }

    private void loadNextPage() {
        this.isLoading = true;
        this.onLoadNextPage(++this.currentPage);
        if (this.currentPage >= this.totalPageCount) {
            this.canLoadMore = false;
        }
    }

    private static class InfiniteScrollListener
    extends RecyclerView.OnScrollListener {
        private final InfiniteLoadingHelper loadingHelper;

        InfiniteScrollListener(InfiniteLoadingHelper loadingHelper) {
            this.loadingHelper = loadingHelper;
        }

        public void onScrolled(@NonNull RecyclerView recyclerView, int dx, int dy) {
            if (dy > 0 && !this.loadingHelper.isLoading && this.loadingHelper.canLoadMore) {
                RecyclerView.LayoutManager layoutManager = recyclerView.getLayoutManager();
                if (layoutManager == null) {
                    return;
                }
                int totalItemCount = recyclerView.getLayoutManager().getItemCount();
                int lastVisibleItemPosition = 0;
                if (recyclerView.getLayoutManager() instanceof StaggeredGridLayoutManager) {
                    int[] lastVisibleItemPositions = ((StaggeredGridLayoutManager)recyclerView.getLayoutManager()).findLastVisibleItemPositions(null);
                    lastVisibleItemPosition = lastVisibleItemPositions[lastVisibleItemPositions.length - 1];
                } else if (recyclerView.getLayoutManager() instanceof LinearLayoutManager) {
                    lastVisibleItemPosition = ((LinearLayoutManager)recyclerView.getLayoutManager()).findLastVisibleItemPosition();
                }
                if (lastVisibleItemPosition + 1 >= totalItemCount) {
                    this.loadingHelper.loadNextPage();
                }
            }
        }
    }

    private static class InfiniteLoadingItemBinder
    extends ItemBinder<String, ItemViewHolder<String>> {
        @LayoutRes
        private final int layoutId;

        InfiniteLoadingItemBinder(@LayoutRes int layoutId) {
            this.layoutId = layoutId;
        }

        @Override
        public int getSpanSize(int maxSpanCount) {
            return maxSpanCount;
        }

        @Override
        public final ItemViewHolder<String> createViewHolder(ViewGroup parent) {
            return new ItemViewHolder<String>(this.inflate(parent, this.layoutId));
        }

        @Override
        public final void bindViewHolder(ItemViewHolder holder, String item) {
        }

        @Override
        public final boolean canBindData(Object item) {
            return item instanceof String && item.equals("LoadingItem");
        }
    }
}

