/*
 * Decompiled with CFR 0.152.
 */
package mva3.adapter;

import android.graphics.Canvas;
import android.graphics.Rect;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.recyclerview.widget.RecyclerView;
import java.util.ArrayList;
import java.util.List;
import mva3.adapter.Section;
import mva3.adapter.decorator.SectionPositionType;
import mva3.adapter.internal.Notifier;
import mva3.adapter.internal.RecyclerItem;
import mva3.adapter.util.Mode;

public class NestedSection
extends Section
implements Notifier {
    final List<Section> sections = new ArrayList<Section>();
    private int count = -1;

    public void addSection(Section section) {
        section.setNotifier(this);
        this.sections.add(section);
        section.onInserted(0, section.getCount());
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public final void onItemClicked(int itemPosition) {
        for (Section section : this.sections) {
            if (itemPosition >= section.getCount()) {
                itemPosition -= section.getCount();
                continue;
            }
            section.onItemClicked(itemPosition);
            return;
        }
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public final void notifySectionItemMoved(Section section, int fromPosition, int toPosition) {
        this.onMoved(this.getAdapterPosition(section, fromPosition), this.getAdapterPosition(section, toPosition));
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public final void notifySectionRangeChanged(Section section, int positionStart, int itemCount, Object payload) {
        this.onChanged(this.getAdapterPosition(section, positionStart), itemCount, payload);
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public final void notifySectionRangeInserted(Section section, int positionStart, int itemCount) {
        this.onInserted(this.getAdapterPosition(section, positionStart), itemCount);
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public final void notifySectionRangeRemoved(Section section, int positionStart, int itemCount) {
        this.onRemoved(this.getAdapterPosition(section, positionStart), itemCount);
    }

    @Override
    int getMaxSpanCount(int itemPosition, int spanCount) {
        for (Section section : this.sections) {
            if (itemPosition >= section.getCount()) {
                itemPosition -= section.getCount();
                continue;
            }
            return section.getMaxSpanCount(itemPosition, super.getMaxSpanCount(itemPosition, spanCount));
        }
        return spanCount;
    }

    @Override
    void collapseSection() {
        for (Section section : this.sections) {
            section.collapseSection();
        }
    }

    @Override
    boolean isSectionExpanded(int itemPosition) {
        for (Section section : this.sections) {
            if (itemPosition >= section.getCount()) {
                itemPosition -= section.getCount();
                continue;
            }
            return section.isSectionExpanded(itemPosition);
        }
        return false;
    }

    @Override
    SectionPositionType getSectionPositionType(int adapterPosition, int sectionPosition, int size) {
        SectionPositionType parentSectionPositionType = super.getSectionPositionType(adapterPosition, sectionPosition, size);
        if (parentSectionPositionType == SectionPositionType.MIDDLE) {
            return parentSectionPositionType;
        }
        SectionPositionType currentSectionPositionType = this.getSectionPositionType(adapterPosition);
        if (parentSectionPositionType == currentSectionPositionType) {
            return currentSectionPositionType;
        }
        return SectionPositionType.MIDDLE;
    }

    @Override
    void drawDecoration(int itemPosition, @NonNull Canvas canvas, @NonNull RecyclerView parent, @NonNull RecyclerView.State state, View child, int adapterPosition) {
        super.drawDecoration(itemPosition, canvas, parent, state, child, adapterPosition);
        this.drawChildSectionDecoration(itemPosition, canvas, parent, state, child, adapterPosition);
    }

    @Override
    void getDecorationOffsets(int itemPosition, @NonNull Rect outRect, @NonNull View view, @NonNull RecyclerView parent, @NonNull RecyclerView.State state, int adapterPosition) {
        super.getDecorationOffsets(itemPosition, outRect, view, parent, state, adapterPosition);
        this.getChildSectionOffsets(itemPosition, outRect, view, parent, state, adapterPosition);
    }

    @Override
    void onDataSetChanged() {
        super.onDataSetChanged();
        this.count = -1;
    }

    @Override
    Object getItem(int itemPosition) {
        for (Section section : this.sections) {
            if (itemPosition >= section.getCount()) {
                itemPosition -= section.getCount();
                continue;
            }
            return section.getItem(itemPosition);
        }
        throw new IllegalStateException();
    }

    @Override
    int getCount() {
        if (this.count == -1) {
            if (this.isSectionVisible()) {
                int itemCount = 0;
                for (Section section : this.sections) {
                    itemCount += section.getCount();
                }
                this.count = itemCount;
            } else {
                this.count = 0;
            }
        }
        return this.count;
    }

    @Override
    boolean isItemSelected(int itemPosition) {
        for (Section section : this.sections) {
            if (itemPosition >= section.getCount()) {
                itemPosition -= section.getCount();
                continue;
            }
            return section.isItemSelected(itemPosition);
        }
        return false;
    }

    @Override
    void onItemSelectionToggled(int itemPosition, @NonNull Mode selectionMode) {
        Mode selectionModeToHonor = this.getModeToHonor(selectionMode, this.selectionMode);
        for (Section section : this.sections) {
            section.onItemSelectionToggled(itemPosition, selectionModeToHonor);
            if ((itemPosition -= section.getCount()) >= 0 || selectionModeToHonor != Mode.MULTIPLE) continue;
            break;
        }
    }

    @Override
    void clearAllSelections() {
        for (Section section : this.sections) {
            section.clearAllSelections();
        }
    }

    @Override
    boolean isItemExpanded(int itemPosition) {
        for (Section section : this.sections) {
            if (itemPosition >= section.getCount()) {
                itemPosition -= section.getCount();
                continue;
            }
            return section.isItemExpanded(itemPosition);
        }
        return false;
    }

    @Override
    void onItemExpansionToggled(int itemPosition, @NonNull Mode expansionMode) {
        Mode expansionModeToHonor = this.getModeToHonor(expansionMode, this.expansionMode);
        for (Section section : this.sections) {
            section.onItemExpansionToggled(itemPosition, expansionModeToHonor);
            if ((itemPosition -= section.getCount()) >= 0 || expansionModeToHonor != Mode.MULTIPLE) continue;
            break;
        }
    }

    @Override
    void collapseAllItems() {
        for (Section section : this.sections) {
            section.collapseAllItems();
        }
    }

    @Override
    int onSectionExpansionToggled(int itemPosition, @NonNull Mode sectionExpansionMode) {
        Mode mode = this.getModeToHonor(sectionExpansionMode, this.sectionExpansionMode);
        if (itemPosition < this.getCount() && itemPosition >= 0) {
            this.onChildSectionExpansionToggled(itemPosition, mode);
        }
        return itemPosition - this.getCount();
    }

    @Override
    int getPositionType(int itemPosition, int adapterPosition, RecyclerView.LayoutManager layoutManager) {
        for (Section section : this.sections) {
            if (itemPosition >= section.getCount()) {
                itemPosition -= section.getCount();
                continue;
            }
            return section.getPositionType(itemPosition, adapterPosition, layoutManager);
        }
        return 0;
    }

    @Override
    void onItemDismiss(int itemPosition) {
        for (Section section : this.sections) {
            if (itemPosition >= section.getCount()) {
                itemPosition -= section.getCount();
                continue;
            }
            section.onItemDismiss(itemPosition);
            return;
        }
    }

    @Override
    boolean move(int initialPosition, int targetOffset) {
        int currentPosition = initialPosition;
        int targetPosition = initialPosition + targetOffset;
        for (Section section : this.sections) {
            if (currentPosition >= section.getCount()) {
                currentPosition -= section.getCount();
                continue;
            }
            if (currentPosition + targetOffset > section.getCount() || currentPosition + targetOffset <= 0) break;
            return section.move(currentPosition, targetOffset);
        }
        RecyclerItem itemToMove = null;
        currentPosition = initialPosition;
        for (Section section : this.sections) {
            if (currentPosition >= section.getCount()) {
                currentPosition -= section.getCount();
                continue;
            }
            itemToMove = section.startMovingItem(currentPosition);
            break;
        }
        if (null == itemToMove) {
            return false;
        }
        targetPosition -= initialPosition < targetPosition ? 1 : 0;
        for (Section section : this.sections) {
            if (targetPosition >= section.getCount()) {
                targetPosition -= section.getCount();
                continue;
            }
            section.finishMovingItem(targetPosition, itemToMove);
            return true;
        }
        return false;
    }

    @Override
    RecyclerItem startMovingItem(int itemPosition) {
        for (Section section : this.sections) {
            if (itemPosition >= section.getCount()) {
                itemPosition -= section.getCount();
                continue;
            }
            this.onDataSetChanged();
            return section.startMovingItem(itemPosition);
        }
        throw new IllegalStateException();
    }

    @Override
    void finishMovingItem(int currentPosition, RecyclerItem itemToMove) {
        for (Section section : this.sections) {
            if (currentPosition >= section.getCount()) {
                currentPosition -= section.getCount();
                continue;
            }
            this.onDataSetChanged();
            section.finishMovingItem(currentPosition, itemToMove);
        }
    }

    SectionPositionType getSectionPositionType(int itemPosition) {
        int sectionPosition = 0;
        for (Section section : this.sections) {
            if (itemPosition >= section.getCount()) {
                itemPosition -= section.getCount();
            } else {
                return section.getSectionPositionType(itemPosition, sectionPosition, this.sections.size());
            }
            ++sectionPosition;
        }
        return SectionPositionType.MIDDLE;
    }

    void removeAllSections() {
        for (Section section : this.sections) {
            section.setNotifier(null);
        }
        this.sections.clear();
        this.count = -1;
    }

    void onChildSectionExpansionToggled(int itemPosition, @NonNull Mode expansionMode) {
        for (Section section : this.sections) {
            itemPosition = section.onSectionExpansionToggled(itemPosition, expansionMode);
            if (itemPosition >= 0 || expansionMode != Mode.MULTIPLE) continue;
            return;
        }
    }

    void collapseAllSections() {
        for (Section section : this.sections) {
            section.collapseSection();
        }
    }

    void drawChildSectionDecoration(int itemPosition, @NonNull Canvas canvas, @NonNull RecyclerView parent, @NonNull RecyclerView.State state, View child, int adapterPosition) {
        for (Section section : this.sections) {
            if (itemPosition >= section.getCount()) {
                itemPosition -= section.getCount();
                continue;
            }
            section.drawDecoration(itemPosition, canvas, parent, state, child, adapterPosition);
            break;
        }
    }

    void getChildSectionOffsets(int itemPosition, @NonNull Rect outRect, @NonNull View view, @NonNull RecyclerView parent, @NonNull RecyclerView.State state, int adapterPosition) {
        for (Section section : this.sections) {
            if (itemPosition >= section.getCount()) {
                itemPosition -= section.getCount();
                continue;
            }
            section.getDecorationOffsets(itemPosition, outRect, view, parent, state, adapterPosition);
            break;
        }
    }

    private int getAdapterPosition(Section section, int position) {
        int sectionIndex = this.sections.indexOf(section);
        if (sectionIndex < 0) {
            throw new IllegalStateException("Section does not exist in parent!");
        }
        for (int i = 0; i < sectionIndex; ++i) {
            position += this.sections.get(i).getCount();
        }
        return position;
    }
}

