/*
 * Decompiled with CFR 0.152.
 */
package androidx.recyclerview.widget;

import androidx.recyclerview.widget.GridLayoutManager;
import mva3.adapter.MultiViewAdapter;
import mva3.adapter.internal.Cache;
import mva3.adapter.internal.SparseIntArrayCache;

public class SpanSizeLookup
extends GridLayoutManager.SpanSizeLookup {
    private MultiViewAdapter multiViewAdapter;
    private final Cache groupIndexCache;

    public SpanSizeLookup(Cache cache) {
        this.setSpanIndexCacheEnabled(true);
        this.groupIndexCache = cache;
    }

    public void clearCache() {
        this.groupIndexCache.clear();
        if (this.groupIndexCache instanceof SparseIntArrayCache) {
            super.invalidateSpanIndexCache();
        }
    }

    public void setAdapter(MultiViewAdapter multiViewAdapter) {
        this.multiViewAdapter = multiViewAdapter;
    }

    public int getSpanSize(int adapterPosition) {
        return this.multiViewAdapter.getSpanSize(adapterPosition);
    }

    public int getCachedSpanIndex(int position, int spanCount) {
        return super.getCachedSpanIndex(position, spanCount);
    }

    public int getSpanGroupIndex(int adapterPosition, int spanCount) {
        int group = this.groupIndexCache.get(adapterPosition, -1);
        if (group == -1) {
            int positionSpanSize = this.getSpanSize(adapterPosition);
            int previousPosition = adapterPosition - 1;
            int span = previousPosition < 0 ? 0 : this.getCachedSpanIndex(previousPosition, spanCount);
            group = previousPosition < 0 ? 0 : this.getSpanGroupIndex(previousPosition, spanCount);
            if ((span += previousPosition < 0 ? 0 : this.getSpanSize(previousPosition)) + positionSpanSize > spanCount) {
                ++group;
            }
            this.groupIndexCache.append(adapterPosition, group);
        }
        return group;
    }
}

