/*
 * Decompiled with CFR 0.152.
 */
package dev.adamko.dokkatoo.tasks;

import dev.adamko.dokkatoo.internal.DokkatooInternalApi;
import dev.adamko.dokkatoo.internal.UriUtilsKt;
import dev.adamko.dokkatoo.tasks.DokkatooTask;
import dev.adamko.dokkatoo.tasks.LogHtmlPublicationLinkTask;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.provider.ValueSource;
import org.gradle.api.provider.ValueSourceParameters;
import org.gradle.api.provider.ValueSourceSpec;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Console;
import org.gradle.api.tasks.TaskAction;
import org.gradle.work.DisableCachingByDefault;
import org.jetbrains.annotations.NotNull;

@DisableCachingByDefault(because="logging-only task")
@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\b'\u0018\u0000 \u000e2\u00020\u0001:\u0002\u000e\u000fB\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\f\u001a\u00020\rH\u0007R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u0010"}, d2={"Ldev/adamko/dokkatoo/tasks/LogHtmlPublicationLinkTask;", "Ldev/adamko/dokkatoo/tasks/DokkatooTask;", "providers", "Lorg/gradle/api/provider/ProviderFactory;", "(Lorg/gradle/api/provider/ProviderFactory;)V", "indexHtmlPath", "Lorg/gradle/api/provider/Property;", "", "getIndexHtmlPath", "()Lorg/gradle/api/provider/Property;", "serverUri", "getServerUri", "exec", "", "Companion", "ServerActiveCheck", "dokkatoo-plugin"})
public abstract class LogHtmlPublicationLinkTask
extends DokkatooTask {
    @NotNull
    public static final String ENABLE_TASK_PROPERTY_NAME = "dev.adamko.dokkatoo.tasks.logHtmlPublicationLinkEnabled";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Console
    @NotNull
    public abstract Property<String> getServerUri();

    @Console
    @NotNull
    public abstract Property<String> getIndexHtmlPath();

    @TaskAction
    public final void exec() {
        CharSequence charSequence;
        String serverUri = (String)this.getServerUri().getOrNull();
        String filePath = (String)this.getIndexHtmlPath().getOrNull();
        if (serverUri != null && !((charSequence = (CharSequence)filePath) == null || StringsKt.isBlank((CharSequence)charSequence))) {
            String string = UriUtilsKt.appendPath(new URI(serverUri), filePath).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"URI(serverUri).appendPath(filePath).toString()");
            String link = string;
            this.getLogger().lifecycle("Generated Dokka HTML publication: " + link);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Inject
    @DokkatooInternalApi
    public LogHtmlPublicationLinkTask(@NotNull ProviderFactory providers) {
        void valueSourceType$iv;
        void $this$of$iv;
        Intrinsics.checkNotNullParameter((Object)providers, (String)"providers");
        this.setGroup("other");
        ProviderFactory providerFactory = providers;
        Function1 function1 = ServerActiveCheck.class;
        Action configuration$iv = new Action(this){
            final /* synthetic */ LogHtmlPublicationLinkTask this$0;

            public final void execute(@NotNull ValueSourceSpec<ServerActiveCheck.Parameters> $this$of) {
                Intrinsics.checkNotNullParameter($this$of, (String)"$receiver");
                ((ServerActiveCheck.Parameters)$this$of.getParameters()).getUri().convention((Provider)this.this$0.getServerUri());
            }
            {
                this.this$0 = logHtmlPublicationLinkTask;
            }
        };
        boolean $i$f$of = false;
        Provider provider = $this$of$iv.of((Class)valueSourceType$iv, configuration$iv);
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"`of`(`valueSourceType`.java, `configuration`)");
        final Provider serverActive2 = provider;
        super.onlyIf("server URL is reachable", new Spec(){

            public final boolean isSatisfiedBy(Task it) {
                Object object = serverActive2.get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"serverActive.get()");
                return (Boolean)object;
            }
        });
        Provider provider2 = providers.gradleProperty(ENABLE_TASK_PROPERTY_NAME).orElse((Object)"true");
        Object object = logHtmlPublicationLinkTaskEnabled.1.INSTANCE;
        if (object != null) {
            function1 = object;
            object = new Transformer(function1){
                private final /* synthetic */ Function1 function;
                {
                    this.function = function1;
                }

                public final /* synthetic */ Object transform(Object p0) {
                    return this.function.invoke(p0);
                }
            };
        }
        Provider provider3 = provider2.map((Transformer)object);
        Intrinsics.checkNotNullExpressionValue((Object)provider3, (String)"providers\n      .gradleP\u2026  .map(String::toBoolean)");
        final Provider logHtmlPublicationLinkTaskEnabled2 = provider3;
        super.onlyIf("task is enabled via property", new Spec(){

            public final boolean isSatisfiedBy(Task it) {
                Object object = logHtmlPublicationLinkTaskEnabled2.get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"logHtmlPublicationLinkTaskEnabled.get()");
                return (Boolean)object;
            }
        });
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\b \u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0004J\r\u0010\u0005\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u0006\u00a8\u0006\b"}, d2={"Ldev/adamko/dokkatoo/tasks/LogHtmlPublicationLinkTask$ServerActiveCheck;", "Lorg/gradle/api/provider/ValueSource;", "", "Ldev/adamko/dokkatoo/tasks/LogHtmlPublicationLinkTask$ServerActiveCheck$Parameters;", "()V", "obtain", "()Ljava/lang/Boolean;", "Parameters", "dokkatoo-plugin"})
    public static abstract class ServerActiveCheck
    implements ValueSource<Boolean, Parameters> {
        @NotNull
        public Boolean obtain() {
            try {
                URI uri = URI.create((String)((Parameters)this.getParameters()).getUri().get());
                HttpClient client = HttpClient.newHttpClient();
                HttpRequest request = HttpRequest.newBuilder().uri(uri).timeout(Duration.ofMillis(10L)).GET().build();
                HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
                return response.statusCode() > 0;
            }
            catch (Exception ex) {
                return false;
            }
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001R\u0018\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0007\u00c0\u0006\u0001"}, d2={"Ldev/adamko/dokkatoo/tasks/LogHtmlPublicationLinkTask$ServerActiveCheck$Parameters;", "Lorg/gradle/api/provider/ValueSourceParameters;", "uri", "Lorg/gradle/api/provider/Property;", "", "getUri", "()Lorg/gradle/api/provider/Property;", "dokkatoo-plugin"})
        public static interface Parameters
        extends ValueSourceParameters {
            @NotNull
            public Property<String> getUri();
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Ldev/adamko/dokkatoo/tasks/LogHtmlPublicationLinkTask$Companion;", "", "()V", "ENABLE_TASK_PROPERTY_NAME", "", "dokkatoo-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

