/*
 * Decompiled with CFR 0.152.
 */
package dev.adamko.dokkatoo.internal;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.dokka.utilities.DokkaLogger;
import org.jetbrains.dokka.utilities.LoggingLevel;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0018\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001f\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010 \u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R$\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00078V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00078V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0012\u0010\n\"\u0004\b\u0013\u0010\fR\u000e\u0010\u0014\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Ldev/adamko/dokkatoo/internal/LoggerAdapter;", "Lorg/jetbrains/dokka/utilities/DokkaLogger;", "Ljava/lang/AutoCloseable;", "outputFile", "Ljava/io/File;", "(Ljava/io/File;)V", "value", "", "errorsCount", "getErrorsCount", "()I", "setErrorsCount", "(I)V", "errorsCounter", "Ljava/util/concurrent/atomic/AtomicInteger;", "logWriter", "Ljava/io/Writer;", "warningsCount", "getWarningsCount", "setWarningsCount", "warningsCounter", "close", "", "debug", "message", "", "error", "info", "log", "level", "Lorg/jetbrains/dokka/utilities/LoggingLevel;", "progress", "warn", "dokkatoo-plugin"})
public final class LoggerAdapter
implements DokkaLogger,
AutoCloseable {
    private final Writer logWriter;
    private final AtomicInteger warningsCounter;
    private final AtomicInteger errorsCounter;

    public int getWarningsCount() {
        return this.warningsCounter.get();
    }

    public void setWarningsCount(int value) {
        this.warningsCounter.set(value);
    }

    public int getErrorsCount() {
        return this.errorsCounter.get();
    }

    public void setErrorsCount(int value) {
        this.errorsCounter.set(value);
    }

    public void debug(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.log(LoggingLevel.DEBUG, message);
    }

    public void progress(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.log(LoggingLevel.PROGRESS, message);
    }

    public void info(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.log(LoggingLevel.INFO, message);
    }

    public void warn(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        LoggerAdapter loggerAdapter = this;
        int n = loggerAdapter.getWarningsCount();
        loggerAdapter.setWarningsCount(n + 1);
        this.log(LoggingLevel.WARN, message);
    }

    public void error(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        LoggerAdapter loggerAdapter = this;
        int n = loggerAdapter.getErrorsCount();
        loggerAdapter.setErrorsCount(n + 1);
        this.log(LoggingLevel.ERROR, message);
    }

    private final synchronized void log(LoggingLevel level, String message) {
        Appendable appendable = this.logWriter;
        CharSequence charSequence = '[' + level.name() + "] " + message;
        Appendable appendable2 = appendable.append(charSequence);
        Intrinsics.checkNotNullExpressionValue((Object)appendable2, (String)"append(value)");
        Intrinsics.checkNotNullExpressionValue((Object)appendable2.append('\n'), (String)"append('\\n')");
    }

    @Override
    public void close() {
        this.logWriter.close();
    }

    public LoggerAdapter(@NotNull File outputFile) {
        Intrinsics.checkNotNullParameter((Object)outputFile, (String)"outputFile");
        if (!outputFile.exists()) {
            outputFile.getParentFile().mkdirs();
            outputFile.createNewFile();
        }
        File file = outputFile;
        Charset charset = Charsets.UTF_8;
        int n = 8192;
        Object object = file;
        this.logWriter = (object = (Writer)new OutputStreamWriter((OutputStream)new FileOutputStream((File)object), charset)) instanceof BufferedWriter ? (BufferedWriter)object : new BufferedWriter((Writer)object, n);
        this.warningsCounter = new AtomicInteger();
        this.errorsCounter = new AtomicInteger();
    }
}

