/*
 * Decompiled with CFR 0.152.
 */
package de.wenzlaff.mindmap;

import de.wenzlaff.mindmap.be.Mindmap;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;

public class Generator {
    private static final String HILFE_TEXT = "Keine Parameter \u00fcbergeben. Aufruf: de.wenzlaff.mindmap.Generator [Ausgabe Datei Name HTML] [Mindmap Template Name] [Mindmap input Verzeichnis Pfad] [Konfig Pfad]";
    private static final String ITHOUGHT_EXTENSION = ".itmz";
    private static final String CONFLICT_DATEINAME = "conflict";

    public int generate(String ausgabeHtmlDateiName, String mindmapTemplate, List<String> inputVerzeichnise, Configuration configuration) {
        this.checkParameter(ausgabeHtmlDateiName, mindmapTemplate, inputVerzeichnise, configuration);
        ArrayList<Mindmap> mindmaps = new ArrayList<Mindmap>();
        inputVerzeichnise.forEach(inputVerzeichnis -> mindmaps.addAll(this.getMindmaps((String)inputVerzeichnis)));
        Collections.sort(mindmaps);
        this.generateHtml(ausgabeHtmlDateiName, mindmapTemplate, mindmaps, configuration);
        return mindmaps.size();
    }

    private void generateHtml(String ausgabeHtmlDateiName, String mindmapTemplate, List<Mindmap> inputMindmaps, Configuration configuration) {
        HashMap<String, Object> datenModell = new HashMap<String, Object>();
        datenModell.put("user", "Thomas Wenzlaff");
        datenModell.put("mindmaps", inputMindmaps);
        datenModell.put("datum", new Date());
        try {
            Template template = configuration.getTemplate(mindmapTemplate);
            OutputStreamWriter outputWriter = new OutputStreamWriter(System.out);
            template.process(datenModell, (Writer)outputWriter);
            try (FileWriter fileWriter = new FileWriter(new File(ausgabeHtmlDateiName));){
                template.process(datenModell, (Writer)fileWriter);
            }
        }
        catch (TemplateException | IOException e) {
            System.err.println("Fehler im Template. " + mindmapTemplate + " " + e.getMessage());
        }
    }

    private void checkParameter(String ausgabeHtmlDateiName, String mindmapTemplate, List<String> inputMindmaps, Configuration configuration) {
        if (ausgabeHtmlDateiName == null || ausgabeHtmlDateiName.isEmpty() || mindmapTemplate == null || mindmapTemplate.isEmpty() || inputMindmaps == null || inputMindmaps.isEmpty() || configuration == null) {
            throw new IllegalArgumentException(HILFE_TEXT);
        }
    }

    private List<Mindmap> getMindmaps(String mindmapInputPath) {
        ArrayList<Mindmap> mindmaps = new ArrayList<Mindmap>();
        List<Path> maps = Generator.getIThoughtMindmaps(mindmapInputPath);
        if (maps.isEmpty()) {
            System.err.println("Keine Dateien im Verzeichnis: " + mindmapInputPath);
        } else {
            for (Path map : maps) {
                Mindmap m = this.getMindmap(map);
                if (mindmaps.contains(m)) {
                    System.err.println("Die " + m + " Mindmap ist schon vorhanden in " + map);
                }
                mindmaps.add(m);
            }
        }
        return mindmaps;
    }

    private Mindmap getMindmap(Path map) {
        Mindmap m = new Mindmap();
        m.setPath(map);
        return m;
    }

    public Configuration getKonfiguration(String configPath) {
        Configuration cfg = new Configuration(Configuration.VERSION_2_3_29);
        try {
            cfg.setDirectoryForTemplateLoading(new File(configPath));
            cfg.setDefaultEncoding("UTF-8");
            cfg.setLocale(Locale.GERMANY);
            cfg.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
            cfg.setLogTemplateExceptions(false);
            cfg.setWrapUncheckedExceptions(true);
        }
        catch (IOException e) {
            System.err.println("Fehler beim laden der Template Konfiguration. " + configPath + " " + e.getMessage());
        }
        return cfg;
    }

    private static List<Path> getIThoughtMindmaps(String verzeichnis) {
        ArrayList<Path> fileNames = new ArrayList<Path>();
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(Paths.get(verzeichnis, new String[0]));){
            for (Path path : directoryStream) {
                String dateiPfad = path.toString();
                if (!Generator.isIThoughtDatei(dateiPfad)) continue;
                fileNames.add(path);
            }
        }
        catch (IOException ex) {
            System.err.println(ex.getMessage());
        }
        return fileNames;
    }

    private static boolean isIThoughtDatei(String dateiPfad) {
        return dateiPfad.endsWith(ITHOUGHT_EXTENSION) && !dateiPfad.contains(CONFLICT_DATEINAME);
    }
}

