/*
 * Decompiled with CFR 0.152.
 */
package de.weltraumschaf.commons.application;

import de.weltraumschaf.commons.application.ApplicationException;
import de.weltraumschaf.commons.application.IO;
import de.weltraumschaf.commons.application.IOStreams;
import de.weltraumschaf.commons.application.Invokable;
import de.weltraumschaf.commons.application.ShutDownHook;
import de.weltraumschaf.commons.system.DefaultExiter;
import de.weltraumschaf.commons.system.ExitCode;
import de.weltraumschaf.commons.system.Exitable;
import java.io.UnsupportedEncodingException;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class InvokableAdapter
implements Invokable {
    private final String[] args;
    private final ShutDownHook shutDownHook;
    private IO ioStreams;
    private Exitable exiter = new DefaultExiter();
    private final Runtime runtime;

    public InvokableAdapter(String[] args) {
        this(args, Runtime.getRuntime(), new ShutDownHook());
    }

    public InvokableAdapter(String[] args, Runtime runtime, ShutDownHook shutDownHook) {
        this.args = (String[])args.clone();
        this.runtime = runtime;
        this.shutDownHook = shutDownHook;
    }

    public static void main(Invokable invokable) {
        try {
            InvokableAdapter.main(invokable, IOStreams.newDefault());
        }
        catch (UnsupportedEncodingException ex) {
            Logger.getLogger(InvokableAdapter.class.getName()).log(Level.SEVERE, null, ex);
            invokable.exit(-1);
        }
    }

    public static void main(Invokable invokable, IO ioStreams) {
        InvokableAdapter.main(invokable, ioStreams, false);
    }

    public static void main(Invokable invokable, IO ioStreams, boolean debug) {
        invokable.setIoStreams(ioStreams);
        try {
            invokable.init();
            invokable.execute();
        }
        catch (Exception ex) {
            ioStreams.errorln(ex.getMessage());
            if (debug) {
                ioStreams.printStackTrace(ex);
            }
            if (ex instanceof ApplicationException) {
                invokable.exit(((ApplicationException)ex).getExitCode());
            }
            invokable.exit(-1);
        }
        invokable.exit(0);
    }

    @Override
    public final void init() {
        this.runtime.addShutdownHook(this.shutDownHook);
    }

    public final String[] getArgs() {
        return (String[])this.args.clone();
    }

    @Override
    public final IO getIoStreams() {
        return this.ioStreams;
    }

    @Override
    public final void setIoStreams(IO ioStreams) {
        this.ioStreams = ioStreams;
    }

    public final void registerShutdownHook(Runnable callback) {
        this.shutDownHook.register(callback);
    }

    @Override
    public final void exit(int status) {
        this.exiter.exit(status);
    }

    @Override
    public final void exit(ExitCode status) {
        this.exiter.exit(status);
    }

    @Override
    public final void setExiter(Exitable exiter) {
        this.exiter = exiter;
    }
}

