/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.gitchangelog.config;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.AbstractIdCredentialsListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernameListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import hudson.model.ItemGroup;
import hudson.security.ACL;
import hudson.util.ListBoxModel;
import java.util.List;
import org.acegisecurity.Authentication;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;

public class CredentialsHelper {
    public static Optional<String> findSecretString(String credentialsId) {
        Optional<StringCredentials> credentials;
        Optional token = Optional.absent();
        if (!Strings.isNullOrEmpty((String)credentialsId) && (credentials = CredentialsHelper.findCredentials(credentialsId)).isPresent()) {
            StringCredentials stringCredential = (StringCredentials)Preconditions.checkNotNull((Object)credentials.get(), (Object)"Credentials selected but not set!");
            token = Optional.of((Object)stringCredential.getSecret().getPlainText());
        }
        return token;
    }

    public static Optional<StandardUsernamePasswordCredentials> findSecretUsernamePassword(String credentialsId) {
        Optional<StandardUsernamePasswordCredentials> credentials;
        Optional token = Optional.absent();
        if (!Strings.isNullOrEmpty((String)credentialsId) && (credentials = CredentialsHelper.findUserCredentials(credentialsId)).isPresent()) {
            Preconditions.checkNotNull((Object)credentials.get(), (Object)"Credentials selected but not set!");
            return credentials;
        }
        return token;
    }

    public static ListBoxModel doFillUserNamePasswordCredentialsIdItems() {
        List<StandardUsernamePasswordCredentials> credentials = CredentialsHelper.getAllCredentials(StandardUsernamePasswordCredentials.class);
        AbstractIdCredentialsListBoxModel listBoxModel = new StandardUsernameListBoxModel().includeEmptyValue().withAll(credentials);
        return listBoxModel;
    }

    public static ListBoxModel doFillApiTokenCredentialsIdItems() {
        List<StringCredentials> credentials = CredentialsHelper.getAllCredentials(StringCredentials.class);
        AbstractIdCredentialsListBoxModel listBoxModel = new StandardListBoxModel().includeEmptyValue().withAll(credentials);
        return listBoxModel;
    }

    public static Optional<StringCredentials> findCredentials(String apiTokenCredentialsId) {
        if (Strings.isNullOrEmpty((String)apiTokenCredentialsId)) {
            return Optional.absent();
        }
        return Optional.fromNullable((Object)CredentialsMatchers.firstOrNull(CredentialsHelper.getAllCredentials(StringCredentials.class), (CredentialsMatcher)CredentialsMatchers.allOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.withId((String)apiTokenCredentialsId)})));
    }

    public static Optional<StandardUsernamePasswordCredentials> findUserCredentials(String apiTokenCredentialsId) {
        if (Strings.isNullOrEmpty((String)apiTokenCredentialsId)) {
            return Optional.absent();
        }
        return Optional.fromNullable((Object)CredentialsMatchers.firstOrNull(CredentialsHelper.getAllCredentials(StandardUsernamePasswordCredentials.class), (CredentialsMatcher)CredentialsMatchers.allOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.withId((String)apiTokenCredentialsId)})));
    }

    private static <C extends Credentials> List<C> getAllCredentials(Class<C> type) {
        ItemGroup itemGroup = null;
        Authentication authentication = ACL.SYSTEM;
        Object domainRequirement = null;
        return CredentialsProvider.lookupCredentials(type, itemGroup, (Authentication)authentication, (DomainRequirement[])new DomainRequirement[]{domainRequirement});
    }
}

