/*
 * Decompiled with CFR 0.152.
 */
package de.wellnerbou.jenkins.gitchangelog.tokenmacro;

import de.wellnerbou.gitchangelog.app.GitChangelogArgs;
import de.wellnerbou.gitchangelog.processors.ChangelogProcessor;
import de.wellnerbou.jenkins.gitchangelog.callable.GitChangelogMasterToSlaveCallable;
import hudson.AbortException;
import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import java.io.IOException;
import org.jenkinsci.plugins.tokenmacro.DataBoundTokenMacro;
import org.jenkinsci.plugins.tokenmacro.MacroEvaluationException;

public abstract class GitLogTokenMacro
extends DataBoundTokenMacro {
    public String evaluate(AbstractBuild<?, ?> build, TaskListener taskListener, String macroName) throws MacroEvaluationException, IOException, InterruptedException {
        FilePath workspace = build.getWorkspace();
        if (workspace == null) {
            throw new AbortException("no workspace for " + build);
        }
        GitChangelogArgs gitChangelogArgs = new GitChangelogArgs();
        ChangelogProcessor changelogProcessor = this.createChangelogProcessor();
        gitChangelogArgs.setChangelogProcessor(changelogProcessor);
        gitChangelogArgs.setRepo(workspace.getRemote());
        GitChangelogMasterToSlaveCallable task = new GitChangelogMasterToSlaveCallable(gitChangelogArgs);
        return (String)build.getWorkspace().act((Callable)task);
    }

    protected abstract ChangelogProcessor createChangelogProcessor();
}

