/*
 * Decompiled with CFR 0.152.
 */
package de.wellnerbou.jenkins.gitchangelog.publish;

import de.wellnerbou.gitchangelog.app.GitChangelogArgs;
import de.wellnerbou.gitchangelog.processors.ChangelogProcessor;
import de.wellnerbou.jenkins.gitchangelog.callable.GitChangelogMasterToSlaveCallable;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;

public class GitLogGenericPostPublishPerformer {
    private ChangelogProcessor changelogProcessor;
    private final String outputfile;
    private final String fromRev;
    private final String toRev;

    public GitLogGenericPostPublishPerformer(ChangelogProcessor changelogProcessor, String outputfile, String fromRev, String toRev) {
        this.changelogProcessor = changelogProcessor;
        this.outputfile = outputfile;
        this.fromRev = fromRev;
        this.toRev = toRev;
    }

    public boolean perform(AbstractBuild<?, ?> build, BuildListener listener) throws InterruptedException, IOException {
        EnvVars env = build.getEnvironment((TaskListener)listener);
        GitChangelogArgs gitChangelogArgs = this.createGitChangelogArgs(build.getWorkspace(), this.resolveAndExpandIfNotNull(this.fromRev, env), this.resolveAndExpandIfNotNull(this.toRev, env));
        PrintStream printStream = this.decideForPrintStream(listener);
        GitChangelogMasterToSlaveCallable task = new GitChangelogMasterToSlaveCallable(gitChangelogArgs);
        String result = (String)build.getWorkspace().act((Callable)task);
        printStream.println(result);
        this.closePrintStreamIfWrittenToFile(printStream);
        return true;
    }

    private void closePrintStreamIfWrittenToFile(PrintStream printStream) {
        if (this.shouldWriteToFile()) {
            printStream.close();
        }
    }

    private boolean shouldWriteToFile() {
        return this.outputfile != null && this.outputfile.length() > 0;
    }

    private PrintStream decideForPrintStream(BuildListener listener) throws FileNotFoundException {
        PrintStream printStream = listener.getLogger();
        if (this.shouldWriteToFile()) {
            File file = new File(this.outputfile);
            listener.getLogger().println("Saving processed git changelog to file " + file.getAbsolutePath() + ".");
            printStream = new PrintStream(file);
        }
        return printStream;
    }

    private GitChangelogArgs createGitChangelogArgs(FilePath workspace, String fromRev, String toRev) throws AbortException {
        if (workspace == null) {
            throw new AbortException("no workspace for " + workspace);
        }
        GitChangelogArgs gitChangelogArgs = new GitChangelogArgs();
        gitChangelogArgs.setChangelogProcessor(this.changelogProcessor);
        gitChangelogArgs.setRepo(workspace.getRemote());
        gitChangelogArgs.setToRev(toRev);
        gitChangelogArgs.setFromRev(fromRev);
        return gitChangelogArgs;
    }

    private String resolveAndExpandIfNotNull(String value, EnvVars env) {
        return value != null ? env.expand(value) : value;
    }
}

