/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.gitchangelog.steps;

import com.google.common.base.Strings;
import hudson.Extension;
import hudson.FilePath;
import hudson.remoting.Callable;
import hudson.util.ListBoxModel;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import jenkins.security.MasterToSlaveCallable;
import org.jenkinsci.plugins.gitchangelog.steps.GitChangelogStepDescriptor;
import org.jenkinsci.plugins.gitchangelog.steps.config.CustomIssueConfig;
import org.jenkinsci.plugins.gitchangelog.steps.config.ExtendedVariableConfig;
import org.jenkinsci.plugins.gitchangelog.steps.config.GitHubConfig;
import org.jenkinsci.plugins.gitchangelog.steps.config.GitLabConfig;
import org.jenkinsci.plugins.gitchangelog.steps.config.JiraConfig;
import org.jenkinsci.plugins.gitchangelog.steps.config.REF_TYPE;
import org.jenkinsci.plugins.gitchangelog.steps.config.RETURN_TYPE;
import org.jenkinsci.plugins.gitchangelog.steps.config.RefConfig;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import se.bjurr.gitchangelog.api.GitChangelogApi;
import se.bjurr.gitchangelog.api.exceptions.GitChangelogRepositoryException;

public class GitChangelogStep
extends Step
implements Serializable {
    private static final long serialVersionUID = 795555442767777209L;
    private RETURN_TYPE returnType;
    private String template;
    private String repo;
    private RefConfig from;
    private RefConfig to;
    private String ignoreTagsIfNameMatches;
    private String ignoreCommitsIfMessageMatches;
    private String ignoreCommitsIfOlderThan;
    private String untaggedName;
    private String readableTagName;
    private String dateFormat;
    private String noIssueName;
    private String timeZone;
    private Boolean removeIssueFromMessage;
    private Boolean ignoreCommitsWithoutIssue;
    private JiraConfig jira;
    private GitHubConfig gitHub;
    private GitLabConfig gitLab;
    private List<CustomIssueConfig> customIssues = new ArrayList<CustomIssueConfig>();
    private List<ExtendedVariableConfig> extendedVariables = new ArrayList<ExtendedVariableConfig>();

    public List<ExtendedVariableConfig> getExtendedVariables() {
        return this.extendedVariables;
    }

    public String getRepo() {
        return this.repo;
    }

    public RefConfig getFrom() {
        return this.from;
    }

    public RefConfig getTo() {
        return this.to;
    }

    @DataBoundSetter
    public void setFrom(RefConfig from) {
        this.from = from == null || Strings.isNullOrEmpty((String)from.getValue()) ? null : from;
    }

    @DataBoundSetter
    public void setTo(RefConfig to) {
        this.to = to == null || Strings.isNullOrEmpty((String)to.getValue()) ? null : to;
    }

    @DataBoundSetter
    public void setGitLab(GitLabConfig gitLab) {
        this.gitLab = gitLab == null || Strings.isNullOrEmpty((String)gitLab.getIssuePattern()) && Strings.isNullOrEmpty((String)gitLab.getProjectName()) && Strings.isNullOrEmpty((String)gitLab.getServer()) && Strings.isNullOrEmpty((String)gitLab.getToken()) ? null : gitLab;
    }

    public GitLabConfig getGitLab() {
        return this.gitLab;
    }

    @DataBoundSetter
    public void setRepo(String repo) {
        this.repo = Strings.emptyToNull((String)repo);
    }

    public String getIgnoreTagsIfNameMatches() {
        return this.ignoreTagsIfNameMatches;
    }

    @DataBoundSetter
    public void setIgnoreTagsIfNameMatches(String ignoreTagsIfNameMatches) {
        this.ignoreTagsIfNameMatches = Strings.emptyToNull((String)ignoreTagsIfNameMatches);
    }

    public String getIgnoreCommitsIfMessageMatches() {
        return this.ignoreCommitsIfMessageMatches;
    }

    @DataBoundSetter
    public void setIgnoreCommitsIfMessageMatches(String ignoreCommitsIfMessageMatches) {
        this.ignoreCommitsIfMessageMatches = Strings.emptyToNull((String)ignoreCommitsIfMessageMatches);
    }

    public String getIgnoreCommitsIfOlderThan() {
        return this.ignoreCommitsIfOlderThan;
    }

    @DataBoundSetter
    public void setIgnoreCommitsIfOlderThan(String ignoreCommitsIfOlderThan) {
        this.ignoreCommitsIfOlderThan = Strings.emptyToNull((String)ignoreCommitsIfOlderThan);
    }

    public String getUntaggedName() {
        return this.untaggedName;
    }

    @DataBoundSetter
    public void setUntaggedName(String untaggedName) {
        this.untaggedName = Strings.emptyToNull((String)untaggedName);
    }

    @DataBoundSetter
    public void setTemplate(String template) {
        this.template = Strings.emptyToNull((String)template);
    }

    public String getTemplate() {
        return this.template;
    }

    public String getReadableTagName() {
        return this.readableTagName;
    }

    @DataBoundSetter
    public void setReadableTagName(String readableTagName) {
        this.readableTagName = Strings.emptyToNull((String)readableTagName);
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    @DataBoundSetter
    public void setDateFormat(String dateFormat) {
        this.dateFormat = Strings.emptyToNull((String)dateFormat);
    }

    public String getNoIssueName() {
        return this.noIssueName;
    }

    @DataBoundSetter
    public void setNoIssueName(String noIssueName) {
        this.noIssueName = Strings.emptyToNull((String)noIssueName);
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    @DataBoundSetter
    public void setTimeZone(String timeZone) {
        this.timeZone = Strings.emptyToNull((String)timeZone);
    }

    public boolean isRemoveIssueFromMessage() {
        return this.removeIssueFromMessage != null && this.removeIssueFromMessage != false;
    }

    @DataBoundSetter
    public void setRemoveIssueFromMessage(Boolean removeIssueFromMessage) {
        this.removeIssueFromMessage = removeIssueFromMessage;
    }

    @DataBoundSetter
    public void setJira(JiraConfig jira) {
        this.jira = jira == null || Strings.isNullOrEmpty((String)jira.getIssuePattern()) && Strings.isNullOrEmpty((String)jira.getPassword()) && Strings.isNullOrEmpty((String)jira.getServer()) && Strings.isNullOrEmpty((String)jira.getUsername()) ? null : jira;
    }

    public JiraConfig getJira() {
        return this.jira;
    }

    @DataBoundSetter
    public void setGitHub(GitHubConfig gitHub) {
        this.gitHub = gitHub == null || Strings.isNullOrEmpty((String)gitHub.getApi()) && Strings.isNullOrEmpty((String)gitHub.getIssuePattern()) && Strings.isNullOrEmpty((String)gitHub.getToken()) ? null : gitHub;
    }

    public GitHubConfig getGitHub() {
        return this.gitHub;
    }

    @DataBoundSetter
    public void setReturnType(RETURN_TYPE returnType) {
        this.returnType = returnType;
    }

    public RETURN_TYPE getReturnType() {
        return this.returnType;
    }

    public List<CustomIssueConfig> getCustomIssues() {
        return this.customIssues;
    }

    @DataBoundSetter
    public void setCustomIssues(List<CustomIssueConfig> customIssues) {
        this.customIssues = customIssues;
    }

    @DataBoundSetter
    public void setExtendedVariables(List<ExtendedVariableConfig> extendedVariables) {
        this.extendedVariables = extendedVariables;
    }

    public boolean isIgnoreCommitsWithoutIssue() {
        return this.ignoreCommitsWithoutIssue != null && this.ignoreCommitsWithoutIssue != false;
    }

    @DataBoundSetter
    public void setIgnoreCommitsWithoutIssue(Boolean ignoreCommitsWithoutIssue) {
        this.ignoreCommitsWithoutIssue = ignoreCommitsWithoutIssue;
    }

    @DataBoundConstructor
    public GitChangelogStep() {
    }

    public StepExecution start(final StepContext context) {
        return new SynchronousNonBlockingStepExecution<Object>(context){
            private static final long serialVersionUID = 1L;

            protected Object run() throws Exception {
                final FilePath workspace = (FilePath)context.get(FilePath.class);
                MasterToSlaveCallable<Object, Exception> callable = new MasterToSlaveCallable<Object, Exception>(){
                    private static final long serialVersionUID = 1L;

                    public Object call() throws Exception {
                        return GitChangelogStep.this.perform(workspace);
                    }
                };
                return workspace.act((Callable)callable);
            }
        };
    }

    private Object perform(FilePath workspace) throws ParseException, GitChangelogRepositoryException {
        Date ignoreCommitsIfOlderThanDate = null;
        if (!Strings.isNullOrEmpty((String)this.ignoreCommitsIfOlderThan)) {
            SimpleDateFormat format = new SimpleDateFormat("YYYY-MM-dd HH:mm:ss", Locale.ENGLISH);
            ignoreCommitsIfOlderThanDate = format.parse(this.ignoreCommitsIfOlderThan);
        }
        String remoteRepo = workspace.getRemote() + "/" + Strings.nullToEmpty((String)this.repo);
        GitChangelogApi b = GitChangelogApi.gitChangelogApiBuilder().withFromRepo(remoteRepo).withDateFormat(this.dateFormat).withIgnoreCommitsOlderThan(ignoreCommitsIfOlderThanDate).withIgnoreCommitsWithMessage(Strings.nullToEmpty((String)this.ignoreCommitsIfMessageMatches)).withIgnoreCommitsWithoutIssue(this.ignoreCommitsWithoutIssue != null && this.ignoreCommitsWithoutIssue != false).withIgnoreTagsIfNameMatches(this.ignoreTagsIfNameMatches).withNoIssueName(this.noIssueName).withReadableTagName(this.readableTagName).withRemoveIssueFromMessageArgument(this.removeIssueFromMessage != null && this.removeIssueFromMessage != false).withTimeZone(this.timeZone).withUntaggedName(this.untaggedName);
        if (this.extendedVariables != null) {
            HashMap<String, String> extendedVariablesMap = new HashMap<String, String>();
            for (ExtendedVariableConfig e : this.extendedVariables) {
                extendedVariablesMap.put(e.getName(), e.getValue());
            }
            b.withExtendedVariables(extendedVariablesMap);
        }
        if (this.from != null && this.from.getType() == REF_TYPE.COMMIT) {
            b.withFromCommit(this.from.getValue());
        }
        if (this.from != null && this.from.getType() == REF_TYPE.REF) {
            b.withFromRef(this.from.getValue());
        }
        if (this.to != null && this.to.getType() == REF_TYPE.COMMIT) {
            b.withToCommit(this.to.getValue());
        }
        if (this.to != null && this.to.getType() == REF_TYPE.REF) {
            b.withToRef(this.to.getValue());
        }
        for (CustomIssueConfig issue : this.customIssues) {
            b.withCustomIssue(issue.getName(), issue.getIssuePattern(), issue.getLink(), issue.getTitle());
        }
        if (this.gitHub != null) {
            b.withGitHubApi(this.gitHub.getApi()).withGitHubIssuePattern(this.gitHub.getIssuePattern()).withGitHubToken(this.gitHub.getToken());
        }
        if (this.gitLab != null) {
            b.withGitLabIssuePattern(this.gitLab.getIssuePattern()).withGitLabProjectName(this.gitLab.getProjectName()).withGitLabServer(this.gitLab.getServer()).withGitLabToken(this.gitLab.getToken());
        }
        if (this.jira != null) {
            b.withJiraIssuePattern(this.jira.getIssuePattern()).withJiraServer(this.jira.getServer()).withJiraUsername(this.jira.getUsername()).withJiraPassword(this.jira.getPassword());
        }
        if (this.returnType == RETURN_TYPE.CONTEXT) {
            return b.getChangelog(true);
        }
        if (Strings.isNullOrEmpty((String)this.template)) {
            throw new RuntimeException("No template specified");
        }
        return b.withTemplateContent(this.template).render();
    }

    @Extension
    public static class DescriptorImpl
    extends GitChangelogStepDescriptor {
        public DescriptorImpl() {
            super("gitChangelog", "Changelog from Git repository");
        }

        @Restricted(value={NoExternalUse.class})
        public ListBoxModel doFillReturnTypeItems() {
            ListBoxModel items = new ListBoxModel();
            items.add(RETURN_TYPE.STRING.name());
            items.add(RETURN_TYPE.CONTEXT.name());
            return items;
        }
    }
}

