/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.gitchangelog.config;

import com.google.common.io.CharStreams;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.plugins.gitchangelog.config.CustomIssue;
import org.jenkinsci.plugins.gitchangelog.config.GitChangelogConfig;

public class GitChangelogConfigHelper {
    private static Logger logger = Logger.getLogger(GitChangelogConfigHelper.class.getName());

    public static GitChangelogConfig createNewConfig() {
        GitChangelogConfig config = new GitChangelogConfig();
        config.setConfigFile("git-changelog-settings.json");
        config.setDateFormat("YYYY-MM-dd HH:mm:ss");
        config.setSubDirectory("");
        config.setFile("CHANGELOG.html");
        config.setIgnoreCommitsIfMessageMatches("^\\[maven-release-plugin\\].*|^\\[Gradle Release Plugin\\].*|^Merge.*");
        config.setJiraIssuePattern("\\b[a-zA-Z]([a-zA-Z]+)-([0-9]+)\\b");
        config.setGitHubIssuePattern("#([0-9]+)");
        config.setNoIssueName("No issue");
        config.setReadableTagName("/([^/]+?)$");
        config.setTimeZone("UTC");
        config.setUntaggedName("Unreleased");
        config.setCreateFileTemplateContent(GitChangelogConfigHelper.getResourceAsString("fileTemplateDefault.mustache"));
        config.setShowSummaryTemplateContent(GitChangelogConfigHelper.getResourceAsString("summaryTemplateDefault.mustache"));
        config.setMediaWikiTemplateContent(GitChangelogConfigHelper.getResourceAsString("mediaWikiTemplateDefault.mustache"));
        ArrayList<CustomIssue> customIssues = new ArrayList<CustomIssue>();
        customIssues.add(new CustomIssue("", "", "", ""));
        customIssues.add(new CustomIssue("", "", "", ""));
        config.setCustomIssues(customIssues);
        return config;
    }

    private static String getResourceAsString(String filename) {
        try {
            return CharStreams.toString((Readable)new InputStreamReader(GitChangelogConfigHelper.class.getResourceAsStream(filename), StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "", e);
            return "";
        }
    }

    public static enum FROMTYPE {
        commit("commit"),
        firstCommit("0000000000000000000000000000000000000000"),
        master("master"),
        ref("ref");

        private final String reference;

        private FROMTYPE(String ref) {
            this.reference = ref;
        }

        public String getReference() {
            return this.reference;
        }
    }
}

