/*
 * Decompiled with CFR 0.152.
 */
package de.vandermeer.asciitable;

import de.vandermeer.asciitable.AT_Context;
import de.vandermeer.asciitable.AT_Renderer;
import de.vandermeer.asciitable.AT_Row;
import de.vandermeer.asciitable.AsciiTableException;
import de.vandermeer.skb.interfaces.document.IsTable;
import de.vandermeer.skb.interfaces.document.TableRowStyle;
import de.vandermeer.skb.interfaces.document.TableRowType;
import de.vandermeer.skb.interfaces.strategies.IsCollectionStrategy;
import de.vandermeer.skb.interfaces.strategies.collections.list.ArrayListStrategy;
import de.vandermeer.skb.interfaces.transformers.ClusterElementTransformer;
import de.vandermeer.skb.interfaces.transformers.StrBuilder_To_String;
import de.vandermeer.skb.interfaces.transformers.Transformer;
import de.vandermeer.skb.interfaces.transformers.textformat.TextAlignment;
import de.vandermeer.skb.interfaces.translators.CharacterTranslator;
import de.vandermeer.skb.interfaces.translators.HtmlElementTranslator;
import de.vandermeer.skb.interfaces.translators.TargetTranslator;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.text.StrBuilder;

public class AsciiTable
implements IsTable {
    protected AT_Context ctx;
    protected AT_Renderer renderer = AT_Renderer.create();
    protected final LinkedList<AT_Row> rows = new LinkedList();
    protected int colNumber;

    public AsciiTable() {
        this(null);
    }

    public AsciiTable(AT_Context ctx) {
        this.ctx = ctx != null ? ctx : new AT_Context();
    }

    public final AT_Row addRow(Object ... columns) {
        AT_Row ret = AT_Row.createContentRow(columns, TableRowStyle.NORMAL);
        if (this.colNumber == 0) {
            this.colNumber = columns.length;
        } else if (columns.length != this.colNumber) {
            throw new AsciiTableException("wrong columns argument", "wrong number of columns, expected " + this.colNumber + " received " + columns.length);
        }
        this.rows.add(ret);
        return ret;
    }

    public final void addRule() {
        this.rows.add(AT_Row.createRule(TableRowType.RULE, TableRowStyle.NORMAL));
    }

    public final void addRule(TableRowStyle style) {
        Validate.notNull((Object)style);
        Validate.validState((style != TableRowStyle.UNKNOWN ? 1 : 0) != 0, (String)"cannot add a rule of unknown style", (Object[])new Object[0]);
        this.rows.add(AT_Row.createRule(TableRowType.RULE, style));
    }

    public final void addStrongRule() {
        this.rows.add(AT_Row.createRule(TableRowType.RULE, TableRowStyle.STRONG));
    }

    public final void addHeavyRule() {
        this.rows.add(AT_Row.createRule(TableRowType.RULE, TableRowStyle.HEAVY));
    }

    public final void addLightRule() {
        this.rows.add(AT_Row.createRule(TableRowType.RULE, TableRowStyle.LIGHT));
    }

    public int getColNumber() {
        return this.colNumber;
    }

    public AT_Context getContext() {
        return this.ctx;
    }

    public LinkedList<AT_Row> getRawContent() {
        return this.rows;
    }

    public AT_Renderer getRenderer() {
        return this.renderer;
    }

    public String render() {
        return new StrBuilder().appendWithSeparators(this.renderer.render((LinkedList<AT_Row>)this.getRawContent(), this.getColNumber(), this.ctx), "\n").toString();
    }

    public String render(int width) {
        return new StrBuilder().appendWithSeparators(this.renderer.render((LinkedList<AT_Row>)this.getRawContent(), this.getColNumber(), this.ctx, this.ctx.getTextWidth(width)), "\n").toString();
    }

    public Collection<String> renderAsCollection() {
        return ClusterElementTransformer.create().transform(this.renderer.render((LinkedList<AT_Row>)this.getRawContent(), this.getColNumber(), this.ctx), (Transformer)StrBuilder_To_String.create(), (IsCollectionStrategy)ArrayListStrategy.create());
    }

    public Collection<String> renderAsCollection(int width) {
        return ClusterElementTransformer.create().transform(this.renderer.render((LinkedList<AT_Row>)this.getRawContent(), this.getColNumber(), this.ctx, this.ctx.getTextWidth(width)), (Transformer)StrBuilder_To_String.create(), (IsCollectionStrategy)ArrayListStrategy.create());
    }

    public AsciiTable setRenderer(AT_Renderer renderer) {
        if (renderer != null) {
            this.renderer = renderer;
        }
        return this;
    }

    public StrBuilder toLog() {
        StrBuilder ret = new StrBuilder();
        ret.append("AsciiTable: ").append("#rows=").append(this.rows.size()).append(", #columns=").append(this.getColNumber()).append(", w=").append(this.ctx.getWidth()).append(", tw=").append(this.ctx.getTextWidth()).appendNewLine();
        return ret;
    }

    public AsciiTable setPadding(int padding) {
        for (AT_Row row : this.rows) {
            if (row.getType() != TableRowType.CONTENT) continue;
            row.setPadding(padding);
        }
        return this;
    }

    public AsciiTable setPaddingBottom(int paddingBottom) {
        for (AT_Row row : this.rows) {
            if (row.getType() != TableRowType.CONTENT) continue;
            row.setPaddingBottom(paddingBottom);
        }
        return this;
    }

    public AsciiTable setPaddingBottomChar(Character paddingBottomChar) {
        for (AT_Row row : this.rows) {
            if (row.getType() != TableRowType.CONTENT) continue;
            row.setPaddingBottomChar(paddingBottomChar);
        }
        return this;
    }

    public AsciiTable setPaddingLeft(int paddingLeft) {
        for (AT_Row row : this.rows) {
            if (row.getType() != TableRowType.CONTENT) continue;
            row.setPaddingLeft(paddingLeft);
        }
        return this;
    }

    public AsciiTable setPaddingLeftChar(Character paddingLeftChar) {
        for (AT_Row row : this.rows) {
            if (row.getType() != TableRowType.CONTENT) continue;
            row.setPaddingLeftChar(paddingLeftChar);
        }
        return this;
    }

    public AsciiTable setPaddingLeftRight(int padding) {
        for (AT_Row row : this.rows) {
            if (row.getType() != TableRowType.CONTENT) continue;
            row.setPaddingLeftRight(padding);
        }
        return this;
    }

    public AsciiTable setPaddingLeftRight(int paddingLeft, int paddingRight) {
        for (AT_Row row : this.rows) {
            if (row.getType() != TableRowType.CONTENT) continue;
            row.setPaddingLeftRight(paddingLeft, paddingRight);
        }
        return this;
    }

    public AsciiTable setPaddingRight(int paddingRight) {
        for (AT_Row row : this.rows) {
            if (row.getType() != TableRowType.CONTENT) continue;
            row.setPaddingRight(paddingRight);
        }
        return this;
    }

    public AsciiTable setPaddingRightChar(Character paddingRightChar) {
        for (AT_Row row : this.rows) {
            if (row.getType() != TableRowType.CONTENT) continue;
            row.setPaddingRightChar(paddingRightChar);
        }
        return this;
    }

    public AsciiTable setPaddingTop(int paddingTop) {
        for (AT_Row row : this.rows) {
            if (row.getType() != TableRowType.CONTENT) continue;
            row.setPaddingTop(paddingTop);
        }
        return this;
    }

    public AsciiTable setPaddingTopBottom(int padding) {
        for (AT_Row row : this.rows) {
            if (row.getType() != TableRowType.CONTENT) continue;
            row.setPaddingTopBottom(padding);
        }
        return this;
    }

    public AsciiTable setPaddingTopBottom(int paddingTop, int paddingBottom) {
        for (AT_Row row : this.rows) {
            if (row.getType() != TableRowType.CONTENT) continue;
            row.setPaddingTopBottom(paddingTop, paddingBottom);
        }
        return this;
    }

    public AsciiTable setPaddingTopChar(Character paddingTopChar) {
        for (AT_Row row : this.rows) {
            if (row.getType() != TableRowType.CONTENT) continue;
            row.setPaddingTopChar(paddingTopChar);
        }
        return this;
    }

    public AsciiTable setTextAlignment(TextAlignment textAlignment) {
        for (AT_Row row : this.rows) {
            if (row.getType() != TableRowType.CONTENT) continue;
            row.setTextAlignment(textAlignment);
        }
        return this;
    }

    public AsciiTable setTargetTranslator(TargetTranslator targetTranslator) {
        for (AT_Row row : this.rows) {
            if (row.getType() != TableRowType.CONTENT) continue;
            row.setTargetTranslator(targetTranslator);
        }
        return this;
    }

    public AsciiTable setHtmlElementTranslator(HtmlElementTranslator htmlElementTranslator) {
        for (AT_Row row : this.rows) {
            if (row.getType() != TableRowType.CONTENT) continue;
            row.setHtmlElementTranslator(htmlElementTranslator);
        }
        return this;
    }

    public AsciiTable setCharTranslator(CharacterTranslator charTranslator) {
        for (AT_Row row : this.rows) {
            if (row.getType() != TableRowType.CONTENT) continue;
            row.setCharTranslator(charTranslator);
        }
        return this;
    }
}

