/*
 * Decompiled with CFR 0.152.
 */
package de.vandermeer.asciitable.v2.render;

import de.vandermeer.asciitable.v2.RenderedTable;
import de.vandermeer.asciitable.v2.V2_AsciiTable;
import de.vandermeer.asciitable.v2.render.BorderPosition;
import de.vandermeer.asciitable.v2.render.BorderType;
import de.vandermeer.asciitable.v2.render.ProcessedRow;
import de.vandermeer.asciitable.v2.render.V2_TableRenderer;
import de.vandermeer.asciitable.v2.render.V2_Utilities;
import de.vandermeer.asciitable.v2.render.width.V2_Width;
import de.vandermeer.asciitable.v2.row.ContentRow;
import de.vandermeer.asciitable.v2.row.RuleRow;
import de.vandermeer.asciitable.v2.row.V2_Row;
import de.vandermeer.asciitable.v2.themes.V2_E_TableThemes;
import de.vandermeer.asciitable.v2.themes.V2_RowTheme;
import de.vandermeer.asciitable.v2.themes.V2_TableTheme;
import de.vandermeer.asciitable.v2.themes.V2_TableThemeBuilder;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.StrBuilder;

public class V2_AsciiTableRenderer
implements V2_TableRenderer {
    char paddingChar = (char)32;
    V2_TableTheme theme = V2_E_TableThemes.PLAIN_7BIT.get();
    V2_Width width = null;
    List<ProcessedRow> rows = new LinkedList<ProcessedRow>();

    @Override
    public V2_AsciiTableRenderer setWidth(V2_Width width) {
        if (width != null) {
            this.width = width;
        }
        return this;
    }

    @Override
    public RenderedTable render(V2_AsciiTable table) {
        this.rows.clear();
        if (table == null || table.getColumnCount() == 0) {
            throw new IllegalArgumentException("wrong table argument: table is null or has no columns");
        }
        if (this.width == null) {
            throw new IllegalArgumentException("wrong table width argument: no width set");
        }
        int[] cols = this.width.setColumnCount(table.getColumnCount()).getColumnWidths(table.getDefaultPadding());
        V2_Utilities.fixTableRules(table);
        for (V2_Row row : table.getTable()) {
            this.rows.add(new ProcessedRow(row, cols, table.getColumnCount()));
        }
        BorderType[] array = V2_Utilities.getBorderTypes_TopRule(this.rows.size() > 1 ? this.rows.get(1) : null, this.rows.get(0).getOriginalRow(), table.getColumnCount());
        this.rows.get(0).setBorderTypes(array);
        array = V2_Utilities.getBorderTypes_BottomRule(this.rows.size() > 1 ? this.rows.get(this.rows.size() - 2) : null, this.rows.get(this.rows.size() - 1).getOriginalRow(), table.getColumnCount());
        this.rows.get(this.rows.size() - 1).setBorderTypes(array);
        if (this.rows.size() > 2) {
            for (int r = 1; r < this.rows.size() - 1; ++r) {
                array = V2_Utilities.getBorderTypes_MidRule(this.rows.get(r - 1), r < this.rows.size() - 2 ? this.rows.get(r + 1) : null, this.rows.get(r).getOriginalRow(), table.getColumnCount());
                this.rows.get(r).setBorderTypes(array);
            }
        }
        LinkedList<StrBuilder> ret = new LinkedList<StrBuilder>();
        for (ProcessedRow row : this.rows) {
            V2_Row original = row.getOriginalRow();
            if (original instanceof ContentRow) {
                ret.add(this.renderContentRow(row, cols));
                continue;
            }
            if (original instanceof RuleRow) {
                ret.add(this.renderRuleRow(row, cols));
                continue;
            }
            System.err.println("ERROR in renderering");
        }
        return new RenderedTable(ret);
    }

    protected final StrBuilder renderContentRow(ProcessedRow row, int[] cols) {
        StrBuilder ret = new StrBuilder(100);
        V2_RowTheme rt = null;
        String[][] columns = row.getProcessedColumns();
        BorderType[] borders = row.getBorderTypes();
        char[] alignment = ((ContentRow)row.getOriginalRow()).getAlignment();
        int[] padding = ((ContentRow)row.getOriginalRow()).getPadding();
        for (int i = 0; i < columns.length; ++i) {
            rt = this.theme.getContent();
            if (i != 0) {
                ret.appendNewLine();
            }
            int span = 0;
            for (int k = 0; k < borders.length; ++k) {
                if (borders[k] != BorderType.NONE) {
                    if (k == 0) {
                        ret.append(V2_Utilities.getChar(BorderPosition.LEFT, borders[k], rt));
                    } else if (k == borders.length - 1) {
                        ret.append(V2_Utilities.getChar(BorderPosition.RIGHT, borders[k], rt));
                    } else {
                        ret.append(V2_Utilities.getChar(BorderPosition.MIDDLE, borders[k], rt));
                    }
                }
                if (k >= columns[i].length) continue;
                if (ArrayUtils.contains((Object[])columns[i], null)) {
                    int s;
                    int width;
                    if (columns[i][k] == null) {
                        if (k == columns[i].length - 1) {
                            width = 0;
                            for (s = 0; s < span; ++s) {
                                width += cols[s];
                            }
                            width += span;
                            ret.appendFixedWidthPadRight((Object)"", width += cols[k], this.paddingChar);
                            continue;
                        }
                        ++span;
                        continue;
                    }
                    if ("".equals(columns[i][k])) {
                        for (int s2 = 0; s2 < span; ++s2) {
                            ret.appendFixedWidthPadRight((Object)"", cols[s2], this.paddingChar);
                        }
                        ret.appendFixedWidthPadRight((Object)"", span, this.paddingChar);
                        span = 0;
                        ret.appendFixedWidthPadRight((Object)columns[i][k], cols[k], this.paddingChar);
                        continue;
                    }
                    width = 0;
                    for (s = 0; s < span; ++s) {
                        width += cols[s];
                    }
                    width += span;
                    this.appendWithAlignment(alignment[k], ret, columns[i][k], width += cols[k], this.paddingChar, padding[k], i == columns.length);
                    span = 0;
                    continue;
                }
                this.appendWithAlignment(alignment[k], ret, columns[i][k], cols[k], this.paddingChar, padding[k], i == columns.length - 1);
            }
        }
        return ret;
    }

    private void appendWithAlignment(char alignment, StrBuilder sb, String str, int width, char paddingChar, int padding, boolean isLastLine) {
        int i;
        if (padding > 0) {
            width -= padding * 2;
        }
        for (i = 0; i < padding; ++i) {
            sb.append(paddingChar);
        }
        if ('l' == alignment) {
            sb.appendFixedWidthPadRight((Object)str, width, paddingChar);
        } else if ('r' == alignment) {
            sb.appendFixedWidthPadLeft((Object)str, width, paddingChar);
        } else if ('c' == alignment) {
            sb.append(StringUtils.center((String)str, (int)width, (char)paddingChar));
        } else if ('j' == alignment || 't' == alignment) {
            if (isLastLine) {
                if ('j' == alignment) {
                    sb.appendFixedWidthPadRight((Object)str, width, paddingChar);
                } else {
                    sb.appendFixedWidthPadLeft((Object)str, width, paddingChar);
                }
            } else {
                Object[] ar = StringUtils.split((String)str);
                int length = 0;
                for (String string : ar) {
                    length += string.length();
                }
                int first = (width - length) / (ar.length - 1) * (ar.length - 1);
                for (int i2 = 0; i2 < ar.length - 1; ++i2) {
                    if (first == 0) continue;
                    int n = i2;
                    ar[n] = ar[n] + " ";
                    --first;
                }
                int second = (width - length) % (ar.length - 1);
                for (int i3 = 0; i3 < ar.length - 1; ++i3) {
                    if (second == 0) continue;
                    int n = i3;
                    ar[n] = (String)ar[n] + " ";
                    --second;
                }
                sb.append(StringUtils.join((Object[])ar));
            }
        } else {
            System.err.println("ERROR RENDER ALIGNMENT");
        }
        for (i = 0; i < padding; ++i) {
            sb.append(paddingChar);
        }
    }

    protected final StrBuilder renderRuleRow(ProcessedRow row, int[] cols) {
        StrBuilder ret = new StrBuilder(100);
        V2_RowTheme rt = null;
        BorderType[] borders = row.getBorderTypes();
        RuleRow original = (RuleRow)row.getOriginalRow();
        block0 : switch (original.getRuleType()) {
            case BOTTOM: {
                switch (original.getRuleStyle()) {
                    case NORMAL: {
                        rt = this.theme.getBottom();
                        break;
                    }
                    case STRONG: {
                        rt = this.theme.getBottomStrong();
                    }
                }
                break;
            }
            case MID: {
                switch (original.getRuleStyle()) {
                    case NORMAL: {
                        rt = this.theme.getMid();
                        break;
                    }
                    case STRONG: {
                        rt = this.theme.getMidStrong();
                    }
                }
                break;
            }
            case TOP: {
                switch (original.getRuleStyle()) {
                    case NORMAL: {
                        rt = this.theme.getTop();
                        break block0;
                    }
                    case STRONG: {
                        rt = this.theme.getTopStrong();
                    }
                }
            }
        }
        for (int k = 0; k < borders.length; ++k) {
            if (k == 0) {
                ret.append(V2_Utilities.getChar(BorderPosition.LEFT, borders[k], rt));
            } else if (k == borders.length - 1) {
                ret.append(V2_Utilities.getChar(BorderPosition.RIGHT, borders[k], rt));
            } else {
                ret.append(V2_Utilities.getChar(BorderPosition.MIDDLE, borders[k], rt));
            }
            if (k >= cols.length) continue;
            ret.appendPadding(cols[k], rt.getMid());
        }
        return ret;
    }

    @Override
    public V2_AsciiTableRenderer setPaddingChar(char pChar) {
        this.paddingChar = pChar;
        return this;
    }

    @Override
    public V2_AsciiTableRenderer setTheme(V2_TableTheme theme) {
        if (theme != null) {
            V2_TableThemeBuilder.testTableTheme(theme);
            this.theme = theme;
        }
        return this;
    }
}

