/*
 * Decompiled with CFR 0.152.
 */
package de.vandermeer.asciitable.v2;

import de.vandermeer.asciitable.commons.ObjectToStringStyle;
import de.vandermeer.asciitable.commons.TableException;
import de.vandermeer.asciitable.v2.row.ContentRow;
import de.vandermeer.asciitable.v2.row.RuleRow;
import de.vandermeer.asciitable.v2.row.RuleStyle;
import de.vandermeer.asciitable.v2.row.RuleType;
import de.vandermeer.asciitable.v2.row.V2_Row;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class V2_AsciiTable {
    List<V2_Row> table = new LinkedList<V2_Row>();
    int colNumber;
    int defaultPadding = 1;

    public V2_AsciiTable setDefaultPadding(int padding) {
        this.defaultPadding = padding;
        return this;
    }

    public int getDefaultPadding() {
        return this.defaultPadding;
    }

    public final void addRule() {
        if (this.table.size() == 0) {
            this.table.add(new RuleRow(RuleType.TOP));
        } else {
            this.table.add(new RuleRow(RuleType.MID));
        }
    }

    public final void addStrongRule() {
        if (this.table.size() == 0) {
            this.table.add(new RuleRow(RuleType.TOP, RuleStyle.STRONG));
        } else {
            this.table.add(new RuleRow(RuleType.MID, RuleStyle.STRONG));
        }
    }

    public final List<V2_Row> getTable() {
        return this.table;
    }

    public final ContentRow addRow(Object ... columns) throws TableException {
        ContentRow ret = new ContentRow(columns, this.defaultPadding);
        if (this.colNumber == 0) {
            this.colNumber = columns.length;
        } else if (columns.length != this.colNumber) {
            throw new TableException("wrong columns argument", "wrong number of columns, expected " + this.colNumber + " received " + columns.length);
        }
        this.table.add(ret);
        return ret;
    }

    public final int getColumnCount() {
        return this.colNumber;
    }

    public String toString() {
        ToStringBuilder ret = new ToStringBuilder((Object)this, ObjectToStringStyle.getStyle()).append("column count   ", this.colNumber).append("table          ", this.table, false).append((Object)"").append((Object)"------------------------------------").append((Object)"");
        if (this.table != null && this.table.size() > 0) {
            for (V2_Row row : this.table) {
                ret.append((Object)row.toString(4));
                ret.append((Object)"");
            }
        }
        ret.append((Object)"------------------------------------");
        return ret.toString();
    }
}

