/*
 * Decompiled with CFR 0.152.
 */
package de.vandermeer.asciitable.v2.core;

import de.vandermeer.asciitable.commons.ArrayTransformations;
import de.vandermeer.asciitable.v2.core.E_AdjustedBorderType;
import de.vandermeer.asciitable.v2.core.TableRow;

public class ProcessedRow {
    TableRow original;
    String[][] procColumns;
    E_AdjustedBorderType[] adjustedBorders;

    public ProcessedRow(TableRow row, int[] width) {
        if (row == null) {
            throw new IllegalArgumentException("row cannot be null");
        }
        this.original = row;
        this._createContentArray(width);
        this._adjustBordersContentRow();
    }

    public final String[][] getProcessedColumns() {
        return this.procColumns;
    }

    public E_AdjustedBorderType[] getAdjustedBorders() {
        return this.adjustedBorders;
    }

    public TableRow getOriginalRow() {
        return this.original;
    }

    private final void _createContentArray(int[] width) {
        if (this.original.isContent()) {
            this.procColumns = new String[width.length - 1][];
            int i = 0;
            while (i < this.original.columns.length) {
                Object o = this.original.columns[i];
                this.procColumns[i] = ArrayTransformations.WRAP_LINES(width[i + 1], o);
                ++i;
            }
            this.procColumns = ArrayTransformations.NORMALISE_ARRAY(width.length - 1, this.procColumns);
            this.procColumns = ArrayTransformations.FLIP_ARRAY(this.procColumns);
        } else {
            this.procColumns = null;
        }
    }

    private final void _adjustBordersContentRow() {
        if (this.original.isContent()) {
            this.adjustedBorders = new E_AdjustedBorderType[this.original.columns.length + 1];
            if (this.original.borders[0]) {
                this.adjustedBorders[0] = E_AdjustedBorderType.CONTENT;
            }
            if (this.original.borders[this.original.columns.length]) {
                this.adjustedBorders[this.original.columns.length] = E_AdjustedBorderType.CONTENT;
            }
            String[] ar = this.procColumns[0];
            int i = 0;
            while (i < ar.length) {
                String content = ar[i];
                if (content == null) {
                    this.adjustedBorders[i + 1] = i == ar.length - 1 ? E_AdjustedBorderType.NONE : E_AdjustedBorderType.NONE;
                } else if ("".equals(content)) {
                    if (this.original.borders[i + 1]) {
                        this.adjustedBorders[i + 1] = E_AdjustedBorderType.CONTENT;
                    }
                } else if (this.original.borders[i + 1]) {
                    this.adjustedBorders[i + 1] = E_AdjustedBorderType.CONTENT;
                }
                ++i;
            }
        }
    }

    public final void adjustTopRuleBorder(ProcessedRow next) {
        if (this.original.isRule()) {
            switch (this.original.ruleType) {
                case TOP: {
                    E_AdjustedBorderType[] relAdj;
                    this.adjustedBorders = new E_AdjustedBorderType[this.original.borders.length];
                    int i = 0;
                    while (i < this.adjustedBorders.length) {
                        this.adjustedBorders[i] = E_AdjustedBorderType.NONE;
                        ++i;
                    }
                    if (next == null || (relAdj = next.adjustedBorders) == null) break;
                    int i2 = 0;
                    while (i2 < relAdj.length) {
                        switch (relAdj[i2]) {
                            case NONE: {
                                this.adjustedBorders[i2] = E_AdjustedBorderType.NONE;
                                break;
                            }
                            case UP: {
                                this.adjustedBorders[i2] = E_AdjustedBorderType.DOWN;
                                break;
                            }
                            case ALL: {
                                this.adjustedBorders[i2] = E_AdjustedBorderType.DOWN;
                                break;
                            }
                            case DOWN: {
                                this.adjustedBorders[i2] = E_AdjustedBorderType.NONE;
                                break;
                            }
                            case CONTENT: {
                                this.adjustedBorders[i2] = E_AdjustedBorderType.DOWN;
                            }
                        }
                        ++i2;
                    }
                    break;
                }
            }
        }
    }

    public final void adjustBottomRuleBorder(ProcessedRow prev) {
        if (this.original.isRule()) {
            switch (this.original.ruleType) {
                case BOTTOM: {
                    E_AdjustedBorderType[] relAdj;
                    this.adjustedBorders = new E_AdjustedBorderType[this.original.borders.length];
                    int i = 0;
                    while (i < this.adjustedBorders.length) {
                        this.adjustedBorders[i] = E_AdjustedBorderType.NONE;
                        ++i;
                    }
                    if (prev == null || (relAdj = prev.adjustedBorders) == null) break;
                    int i2 = 0;
                    while (i2 < relAdj.length) {
                        switch (relAdj[i2]) {
                            case NONE: {
                                this.adjustedBorders[i2] = E_AdjustedBorderType.NONE;
                                break;
                            }
                            case UP: {
                                this.adjustedBorders[i2] = E_AdjustedBorderType.NONE;
                                break;
                            }
                            case ALL: {
                                this.adjustedBorders[i2] = E_AdjustedBorderType.UP;
                                break;
                            }
                            case DOWN: {
                                this.adjustedBorders[i2] = E_AdjustedBorderType.UP;
                                break;
                            }
                            case CONTENT: {
                                this.adjustedBorders[i2] = E_AdjustedBorderType.UP;
                            }
                        }
                        ++i2;
                    }
                    break;
                }
            }
        }
    }

    public final void adjustMidRuleBorder(ProcessedRow prev, ProcessedRow next) {
        if (this.original.isRule()) {
            switch (this.original.ruleType) {
                case MID: {
                    int i;
                    E_AdjustedBorderType[] relAdj;
                    this.adjustedBorders = new E_AdjustedBorderType[this.original.borders.length];
                    int i2 = 0;
                    while (i2 < this.adjustedBorders.length) {
                        this.adjustedBorders[i2] = E_AdjustedBorderType.NONE;
                        ++i2;
                    }
                    if (prev != null && (relAdj = prev.adjustedBorders) != null) {
                        i = 0;
                        while (i < relAdj.length) {
                            switch (relAdj[i]) {
                                case NONE: {
                                    this.adjustedBorders[i] = E_AdjustedBorderType.NONE;
                                    break;
                                }
                                case UP: {
                                    this.adjustedBorders[i] = E_AdjustedBorderType.NONE;
                                    break;
                                }
                                case ALL: {
                                    this.adjustedBorders[i] = E_AdjustedBorderType.UP;
                                    break;
                                }
                                case DOWN: {
                                    this.adjustedBorders[i] = E_AdjustedBorderType.UP;
                                    break;
                                }
                                case CONTENT: {
                                    this.adjustedBorders[i] = E_AdjustedBorderType.UP;
                                }
                            }
                            ++i;
                        }
                    }
                    if (next == null || (relAdj = next.adjustedBorders) == null) break;
                    i = 0;
                    while (i < relAdj.length) {
                        switch (relAdj[i]) {
                            case NONE: 
                            case DOWN: {
                                break;
                            }
                            case UP: 
                            case ALL: 
                            case CONTENT: {
                                this.adjustedBorders[i] = this.adjustedBorders[i] == E_AdjustedBorderType.UP ? E_AdjustedBorderType.ALL : E_AdjustedBorderType.DOWN;
                            }
                        }
                        ++i;
                    }
                    break;
                }
            }
        }
    }
}

