/*
 * Decompiled with CFR 0.152.
 */
package de.vandermeer.asciitable.v2;

import de.vandermeer.asciitable.v2.AsciiTable;
import de.vandermeer.asciitable.v2.RenderedAsciiTable;
import de.vandermeer.asciitable.v2.core.E_AdjustedBorderType;
import de.vandermeer.asciitable.v2.core.E_BorderPosition;
import de.vandermeer.asciitable.v2.core.ProcessedRow;
import de.vandermeer.asciitable.v2.core.TableRow;
import de.vandermeer.asciitable.v2.core.Width;
import de.vandermeer.asciitable.v2.themes.E_TableThemes;
import de.vandermeer.asciitable.v2.themes.RowTheme;
import de.vandermeer.asciitable.v2.themes.TableTheme;
import de.vandermeer.asciitable.v2.themes.V2Validator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.StrBuilder;

public class AsciiTableRenderer {
    char paddingChar = (char)32;
    TableTheme theme = E_TableThemes.PLAIN_7BIT.get();
    Width width = null;
    List<ProcessedRow> rows = new LinkedList<ProcessedRow>();

    public AsciiTableRenderer setWidth(Width width) {
        if (width != null) {
            this.width = width;
        }
        return this;
    }

    public RenderedAsciiTable render(AsciiTable table) {
        if (table == null || table.getColumnCount() == 0) {
            throw new IllegalArgumentException("wrong table argument: table is null or has no columns");
        }
        if (this.width == null) {
            throw new IllegalArgumentException("wrong table width argument: no width set");
        }
        int[] cols = this.width.calculateWidth(table.getColumnCount());
        boolean[] borders = new boolean[cols.length];
        int i = 0;
        while (i < borders.length) {
            borders[i] = true;
            ++i;
        }
        table.fixRules();
        for (TableRow row : table.table) {
            this.rows.add(new ProcessedRow(row, cols));
        }
        this.rows.get(0).adjustTopRuleBorder(this.rows.size() > 1 ? this.rows.get(1) : null);
        this.rows.get(this.rows.size() - 1).adjustBottomRuleBorder(this.rows.size() > 1 ? this.rows.get(this.rows.size() - 2) : null);
        if (this.rows.size() > 2) {
            int r = 1;
            while (r < this.rows.size() - 1) {
                this.rows.get(r).adjustMidRuleBorder(this.rows.get(r - 1), r < this.rows.size() - 2 ? this.rows.get(r + 1) : null);
                ++r;
            }
        }
        LinkedList<StrBuilder> ret = new LinkedList<StrBuilder>();
        for (ProcessedRow row : this.rows) {
            ret.add(this.renderRow(row, cols));
        }
        return new RenderedAsciiTable(ret);
    }

    protected final StrBuilder renderRow(ProcessedRow row, int[] cols) {
        if (row.getOriginalRow().isContent()) {
            return this.renderContentRow(row, cols);
        }
        return this.renderRuleRow(row, cols);
    }

    protected final StrBuilder renderContentRow(ProcessedRow row, int[] cols) {
        StrBuilder ret = new StrBuilder(100);
        RowTheme rt = null;
        String[][] columns = row.getProcessedColumns();
        E_AdjustedBorderType[] borders = row.getAdjustedBorders();
        int i = 0;
        while (i < columns.length) {
            rt = this.theme.getContent();
            if (i != 0) {
                ret.appendNewLine();
            }
            int span = 0;
            int k = 0;
            while (k < borders.length) {
                if (borders[k] != E_AdjustedBorderType.NONE) {
                    if (k == 0) {
                        ret.append(this.getChar(E_BorderPosition.LEFT, borders[k], rt));
                    } else if (k == borders.length - 1) {
                        ret.append(this.getChar(E_BorderPosition.RIGHT, borders[k], rt));
                    } else {
                        ret.append(this.getChar(E_BorderPosition.MIDDLE, borders[k], rt));
                    }
                }
                if (k < columns[i].length) {
                    if (ArrayUtils.contains((Object[])columns[i], null)) {
                        int s;
                        int width;
                        if (columns[i][k] == null) {
                            if (k == columns[i].length - 1) {
                                width = 0;
                                s = 0;
                                while (s < span) {
                                    width += cols[s + 1];
                                    ++s;
                                }
                                width += span;
                                ret.appendFixedWidthPadRight((Object)"", width += cols[i + 1], this.paddingChar);
                            } else {
                                ++span;
                            }
                        } else if ("".equals(columns[i][k])) {
                            int s2 = 0;
                            while (s2 < span) {
                                ret.appendFixedWidthPadRight((Object)"", cols[s2 + 1], this.paddingChar);
                                ++s2;
                            }
                            ret.appendFixedWidthPadRight((Object)"", span, this.paddingChar);
                            span = 0;
                            ret.appendFixedWidthPadRight((Object)columns[i][k], cols[i + 1], this.paddingChar);
                        } else {
                            width = 0;
                            s = 0;
                            while (s < span) {
                                width += cols[s + 1];
                                ++s;
                            }
                            width += span;
                            ret.append(StringUtils.center((String)columns[i][k], (int)(width += cols[i + 1]), (char)this.paddingChar));
                            span = 0;
                        }
                    } else {
                        ret.appendFixedWidthPadRight((Object)columns[i][k], cols[i + 1], this.paddingChar);
                    }
                }
                ++k;
            }
            ++i;
        }
        return ret;
    }

    protected final StrBuilder renderRuleRow(ProcessedRow row, int[] cols) {
        StrBuilder ret = new StrBuilder(100);
        RowTheme rt = null;
        E_AdjustedBorderType[] borders = row.getAdjustedBorders();
        block0 : switch (row.getOriginalRow().getRuleType()) {
            case BOTTOM: {
                switch (row.getOriginalRow().getRuleStyle()) {
                    case NORMAL: {
                        rt = this.theme.getBottom();
                        break;
                    }
                    case STRONG: {
                        rt = this.theme.getBottomStrong();
                    }
                }
                break;
            }
            case MID: {
                switch (row.getOriginalRow().getRuleStyle()) {
                    case NORMAL: {
                        rt = this.theme.getMid();
                        break;
                    }
                    case STRONG: {
                        rt = this.theme.getMidStrong();
                    }
                }
                break;
            }
            case TOP: {
                switch (row.getOriginalRow().getRuleStyle()) {
                    case NORMAL: {
                        rt = this.theme.getTop();
                        break block0;
                    }
                    case STRONG: {
                        rt = this.theme.getTopStrong();
                    }
                }
            }
        }
        int k = 0;
        while (k < borders.length) {
            if (k == 0) {
                ret.append(this.getChar(E_BorderPosition.LEFT, borders[k], rt));
            } else if (k == borders.length - 1) {
                ret.append(this.getChar(E_BorderPosition.RIGHT, borders[k], rt));
            } else {
                ret.append(this.getChar(E_BorderPosition.MIDDLE, borders[k], rt));
            }
            if (k + 1 < cols.length) {
                ret.appendPadding(cols[k + 1], rt.getMid());
            }
            ++k;
        }
        return ret;
    }

    private char getChar(E_BorderPosition pos, E_AdjustedBorderType type, RowTheme tr) {
        switch (type) {
            case ALL: {
                switch (pos) {
                    case LEFT: {
                        return tr.getLeftBorder();
                    }
                    case MIDDLE: {
                        return tr.getMidBorderAll();
                    }
                    case RIGHT: {
                        return tr.getRightBorder();
                    }
                }
            }
            case CONTENT: {
                switch (pos) {
                    case LEFT: {
                        return tr.getLeftBorder();
                    }
                    case MIDDLE: {
                        return tr.getMidBorderAll();
                    }
                    case RIGHT: {
                        return tr.getRightBorder();
                    }
                }
            }
            case DOWN: {
                switch (pos) {
                    case LEFT: {
                        return tr.getLeftBorder();
                    }
                    case MIDDLE: {
                        return tr.getMidBorderDown();
                    }
                    case RIGHT: {
                        return tr.getRightBorder();
                    }
                }
            }
            case NONE: {
                return tr.getMid();
            }
            case UP: {
                switch (pos) {
                    case LEFT: {
                        return tr.getLeftBorder();
                    }
                    case MIDDLE: {
                        return tr.getMidBorderUp();
                    }
                    case RIGHT: {
                        return tr.getRightBorder();
                    }
                }
            }
        }
        return 'X';
    }

    public AsciiTableRenderer setPaddingChar(char pChar) {
        this.paddingChar = pChar;
        return this;
    }

    public AsciiTableRenderer setTheme(TableTheme theme) {
        if (theme != null) {
            V2Validator.testTableTheme(theme);
            this.theme = theme;
        }
        return this;
    }
}

