/*
 * Decompiled with CFR 0.152.
 */
package de.vandermeer.asciitable.v2;

import de.vandermeer.asciitable.commons.TableException;
import de.vandermeer.asciitable.commons.Table_ToStringStyle;
import de.vandermeer.asciitable.v2.core.E_RuleStyle;
import de.vandermeer.asciitable.v2.core.E_RuleType;
import de.vandermeer.asciitable.v2.core.TableRow;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class AsciiTable {
    List<TableRow> table = new LinkedList<TableRow>();
    int columns;

    public AsciiTable(int columns) {
        this.columns = columns;
    }

    public final void addRule() {
        if (this.table.size() == 0) {
            this.table.add(new TableRow(E_RuleType.TOP, this.columns));
        } else {
            this.table.add(new TableRow(E_RuleType.MID, this.columns));
        }
    }

    public final void addRuleStrong() {
        if (this.table.size() == 0) {
            this.table.add(new TableRow(E_RuleType.TOP, E_RuleStyle.STRONG, this.columns));
        } else {
            this.table.add(new TableRow(E_RuleType.MID, E_RuleStyle.STRONG, this.columns));
        }
    }

    public final TableRow addRow(Object ... columns) throws TableException {
        TableRow ret = new TableRow(columns, this.columns);
        this.table.add(ret);
        return ret;
    }

    public final int getColumnCount() {
        return this.columns;
    }

    public void fixRules() {
        if (this.table.get(0).getRuleType() != null && !E_RuleType.TOP.equals((Object)this.table.get(0).getRuleType())) {
            this.table.get(0).setRuleType(E_RuleType.TOP);
        }
        if (E_RuleType.MID.equals((Object)this.table.get(this.table.size() - 1).getRuleType())) {
            this.table.get(this.table.size() - 1).setRuleType(E_RuleType.BOTTOM);
        }
    }

    public String toString() {
        ToStringBuilder ret = new ToStringBuilder((Object)this, Table_ToStringStyle.TS_STYLE).append("column count   ", this.columns).append((Object)"------------------------------------").append("table          ", this.table, false);
        ret.append((Object)"------------------------------------");
        return ret.toString();
    }

    public boolean validate() {
        if (this.getColumnCount() == 0) {
            throw new IllegalArgumentException("wrong table argument: table is null or has no columns");
        }
        return true;
    }
}

