/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.doclet.cs.html.templates;

import com.sun.javadoc.RootDoc;
import de.unkrig.commons.doclet.html.Html;
import de.unkrig.commons.lang.AssertionUtil;
import de.unkrig.commons.lang.StringUtil;
import de.unkrig.commons.lang.protocol.Consumer;
import de.unkrig.commons.lang.protocol.Longjump;
import de.unkrig.commons.nullanalysis.Nullable;
import de.unkrig.commons.util.collections.ElementWithContext;
import de.unkrig.doclet.cs.CsDoclet;
import de.unkrig.notemplate.javadocish.IndexPages;
import de.unkrig.notemplate.javadocish.Options;
import de.unkrig.notemplate.javadocish.templates.AbstractDetailHtml;
import de.unkrig.notemplate.javadocish.templates.AbstractRightFrameHtml;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;

public class RuleDetailHtml
extends AbstractDetailHtml {
    public void render(ElementWithContext<CsDoclet.Rule> ruleTriplet, Html html, RootDoc rootDoc, Options options, Consumer<? super IndexPages.IndexEntry> indexEntries) {
        CsDoclet.Rule previousRule = (CsDoclet.Rule)ruleTriplet.previous();
        CsDoclet.Rule rule = (CsDoclet.Rule)ruleTriplet.current();
        CsDoclet.Rule nextRule = (CsDoclet.Rule)ruleTriplet.next();
        String ruleLink = rule.familyPlural() + "/" + rule.simpleName() + ".html";
        indexEntries.consume((Object)IndexPages.indexEntry((String)rule.name(), (String)ruleLink, (String)"Rule", (String)rule.shortDescription()));
        ArrayList<AbstractDetailHtml.SectionItem> propertyItems = new ArrayList<AbstractDetailHtml.SectionItem>();
        for (CsDoclet.RuleProperty property : rule.properties()) {
            Object tmp = property.defaultValue();
            if (tmp == null) {
                tmp = property.overrideDefaultValue();
            }
            Object defaultValue = tmp;
            String detailTitle = property.name() + " = ";
            switch (property.datatype()) {
                case BOOLEAN: {
                    detailTitle = detailTitle + (defaultValue == null ? "\"true|false" : (Boolean.TRUE.equals(defaultValue) ? "\"<u>true</u>|false\"" : "\"true|<u>false</u>\""));
                    break;
                }
                case MULTI_CHECK: {
                    CsDoclet.OptionProvider op = property.optionProvider();
                    if (op == null) {
                        rootDoc.printError(property.ref().position(), "Multi-check property lacks the option provider");
                        detailTitle = detailTitle + "???";
                        break;
                    }
                    detailTitle = detailTitle + "\"" + RuleDetailHtml.catValues(op, defaultValue == null ? new Object[]{} : ((String)defaultValue).split(","), ", ") + "\"";
                    break;
                }
                case REGEX: {
                    detailTitle = detailTitle + "<i><a href=\"http://docs.oracle.com/javase/8/docs/api/java/util/regex/Pattern.html\">regular-expression</a></i>";
                    if (defaultValue == null) break;
                    detailTitle = detailTitle + " (optional; default value is \"" + defaultValue + "\")";
                    break;
                }
                case SINGLE_SELECT: {
                    Object[] objectArray;
                    CsDoclet.OptionProvider op = property.optionProvider();
                    if (op == null) {
                        rootDoc.printError(property.ref().position(), "Single-select property lacks the option provider");
                        detailTitle = detailTitle + "???";
                        break;
                    }
                    StringBuilder stringBuilder = new StringBuilder().append(detailTitle).append("\"");
                    if (defaultValue == null) {
                        objectArray = new Object[]{};
                    } else {
                        Object[] objectArray2 = new Object[1];
                        objectArray = objectArray2;
                        objectArray2[0] = defaultValue;
                    }
                    detailTitle = stringBuilder.append(RuleDetailHtml.catValues(op, objectArray, " | ")).append("\"").toString();
                    break;
                }
                case FILE: 
                case HIDDEN: 
                case INTEGER: 
                case STRING: {
                    detailTitle = detailTitle + "\"<i>" + (Object)((Object)property.datatype()) + "</i>\"";
                    detailTitle = defaultValue == null ? detailTitle + " (mandatory)" : detailTitle + " (optional; default value is " + defaultValue + ")";
                }
            }
            propertyItems.add(new AbstractDetailHtml.SectionItem(property.name(), new String[]{property.name(), property.shortDescription()}, detailTitle, () -> {
                this.l("      " + property.longDescription());
                if (property.optionProvider() != null) {
                    this.l(new String[]{"      <p>Default values are <u>underlined</u>.</p>", "      <p>For a description of the individual values, click them.</p>"});
                }
            }));
            String ruleLink2 = rule.familyPlural() + "/" + rule.ref().name().replace('.', '/');
            String propertyLink = ruleLink2 + "#property_" + property.name();
            indexEntries.consume((Object)IndexPages.indexEntry((String)property.name(), (String)propertyLink, (String)("Property of rule <a href=\"" + ruleLink2 + "\">" + rule.name() + "</a>"), (String)property.shortDescription()));
        }
        AbstractDetailHtml.Section propertiesSection = new AbstractDetailHtml.Section("property", "Props", "Property Summary", "Properties", new String[]{"Name", "Description"}, "Property Detail", null, null);
        propertiesSection.items.addAll(propertyItems);
        String familyCap = StringUtil.firstLetterToUpperCase((String)rule.familySingular());
        String previousRuleLink = "Prev " + familyCap;
        if (previousRule != null) {
            previousRuleLink = "<a href=\"" + previousRule.simpleName() + ".html\"><span class=\"typeNameLink\">" + previousRuleLink + "</span></a>";
        }
        String nextRuleLink = "Next " + familyCap;
        if (nextRule != null) {
            nextRuleLink = "<a href=\"" + nextRule.simpleName() + ".html\"><span class=\"typeNameLink\">" + nextRuleLink + "</span></a>";
        }
        super.rDetail(familyCap + " \"" + rule.name() + "\"", options, new String[]{"../stylesheet.css", "../stylesheet2.css"}, new String[]{"Overview", "../overview-summary.html", familyCap, AbstractRightFrameHtml.HIGHLIT, "Deprecated", "../deprecated-list.html", "Index", "../" + (options.splitIndex ? "index-files/index-1.html" : "index-all.html"), "Help", "../help-doc.html"}, new String[]{previousRuleLink, nextRuleLink}, new String[]{"Frames", "../index.html?" + rule.familyPlural() + "/" + rule.simpleName() + ".html", "No Frames", "#top"}, new String[]{"All Rules", "../allrules-noframe.html"}, null, familyCap + " \"" + rule.name() + "\"", familyCap + " \"" + rule.name() + "\"", () -> {
            this.l(new String[]{"      <div class=\"description\">", "        " + rule.longDescription()});
            CsDoclet.Quickfix[] qfs = rule.quickfixes();
            if (qfs != null && qfs.length > 0) {
                this.l(new String[]{"        <h3>Quickfixes:</h3>", "          <dl>"});
                for (CsDoclet.Quickfix qf : qfs) {
                    String link;
                    try {
                        link = html.makeLink(rule.ref(), qf.ref(), true, qf.label(), null, rootDoc);
                    }
                    catch (Longjump l) {
                        link = qf.label();
                    }
                    this.l(new String[]{"            <dt>" + link + "</dt>", "            <dd>" + qf.shortDescription() + "</dd>"});
                }
                this.l("          </dl>");
            }
            this.l("      </div>");
        }, Collections.singletonList(propertiesSection));
    }

    private static String catValues(CsDoclet.OptionProvider optionProvider, @Nullable Object[] defaultValues, String glue) {
        CsDoclet.ValueOption[] valueOptions = optionProvider.valueOptions();
        assert (valueOptions.length >= 1);
        HashSet<String> dvs = new HashSet<String>();
        if (defaultValues != null) {
            for (Object o : defaultValues) {
                dvs.add(o.toString());
            }
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (true) {
            CsDoclet.ValueOption vo = valueOptions[i];
            sb.append("<a href=\"../option-providers/").append(optionProvider.className()).append(".html#");
            sb.append(vo.name()).append("_detail\">");
            if (dvs.contains(vo.name())) {
                sb.append("<u>").append(vo.name()).append("</u>");
            } else {
                sb.append(vo.name());
            }
            sb.append("</a>");
            if (++i == valueOptions.length) break;
            sb.append(glue);
        }
        return sb.toString();
    }

    static {
        AssertionUtil.enableAssertionsForThisClass();
    }
}

