/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.gui;

import de.uniks.networkparser.buffer.CharacterBuffer;

public class RGBColor {
    public static final RGBColor WHITE = new RGBColor().withValue(255.0f, 255.0f, 255.0f);
    public static final RGBColor TANSPARENT = new RGBColor().withValue(0.0f, 0.0f, 0.0f);
    public static final RGBColor BLACK = new RGBColor().withValue(0.0f, 0.0f, 0.0f);
    public static final RGBColor RED = new RGBColor().withValue(255.0f, 0.0f, 0.0f);
    public static final RGBColor GREEN = new RGBColor().withValue(0.0f, 255.0f, 0.0f);
    public static final RGBColor BLUE = new RGBColor().withValue(0.0f, 0.0f, 255.0f);
    public static final RGBColor PURPLE = new RGBColor().withValue(127.5f, 0.0f, 127.5f);
    public static final RGBColor YELLOW = new RGBColor().withValue(255.0f, 255.0f, 0.0f);
    public static final RGBColor ORANGE = new RGBColor().withValue(255.0f, 127.5f, 0.0f);
    private int argb;
    private float red;
    private float green;
    private float blue;
    private float cyan;
    private float magenta;
    private float yellow;

    public RGBColor withValue(float red, float green, float blue) {
        boolean a = true;
        int ia = (int)(255.0 * (double)a);
        int ir = (int)(255.0 * (double)red * (double)a);
        int ig = (int)(255.0 * (double)green * (double)a);
        int ib = (int)(255.0 * (double)blue * (double)a);
        this.argb = ia << 24 | ir << 16 | ig << 8 | ib << 0;
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.calcCMYK();
        return this;
    }

    public static RGBColor create(String value) {
        RGBColor color = new RGBColor();
        if (value == null) {
            return color;
        }
        int red = Integer.valueOf(value.substring(0, 2), 16);
        int green = Integer.valueOf(value.substring(2, 4), 16);
        int blue = Integer.valueOf(value.substring(4, 6), 16);
        color.withValue(red, green, blue);
        return color;
    }

    public static RGBColor create(float red, float green, float blue) {
        RGBColor color = new RGBColor().withValue(red, green, blue);
        return color;
    }

    public int getRed() {
        return (int)this.red;
    }

    public RGBColor withRed(int red) {
        this.red = red;
        return this;
    }

    public int getGreen() {
        return (int)this.green;
    }

    public RGBColor withGreen(int green) {
        this.green = green;
        return this;
    }

    public int getBlue() {
        return (int)this.blue;
    }

    public RGBColor withBlue(int blue) {
        this.blue = blue;
        return this;
    }

    public int getArgb() {
        return this.argb;
    }

    private int min(int a, int b) {
        return a <= b ? a : b;
    }

    public RGBColor add(RGBColor second) {
        RGBColor color = new RGBColor();
        float newRed = (float)(this.getRed() + second.getRed()) / 2.0f;
        float newGreen = (float)(this.getGreen() + second.getGreen()) / 2.0f;
        float newBlue = (float)(this.getBlue() + second.getBlue()) / 2.0f;
        color.withValue(newRed, newGreen, newBlue);
        return color;
    }

    private void calcCMYK() {
        int black = this.min(this.min(255 - (int)this.red, 255 - (int)this.green), 255 - (int)this.blue);
        if (black != 255) {
            this.cyan = (255.0f - this.red - (float)black) / (float)(255 - black);
            this.magenta = (255.0f - this.green - (float)black) / (float)(255 - black);
            this.yellow = (255.0f - this.blue - (float)black) / (float)(255 - black);
        } else {
            this.cyan = 255 - (int)this.red;
            this.magenta = 255 - (int)this.green;
            this.yellow = 255 - (int)this.blue;
        }
    }

    public RGBColor minus(RGBColor second) {
        RGBColor color = new RGBColor();
        if (this.getRed() == second.getRed() && this.getGreen() == second.getGreen() && this.getBlue() == second.getBlue()) {
            return color;
        }
        color.withRed(this.getRed() * 2 - second.getRed());
        color.withGreen(this.getGreen() * 2 - second.getGreen());
        color.withBlue(this.getBlue() * 2 - second.getBlue());
        return color;
    }

    public static RGBColor minus(String colorA, String colorB) {
        return RGBColor.create(colorA).minus(RGBColor.create(colorB));
    }

    public float getCyan() {
        return this.cyan;
    }

    public float getMagenta() {
        return this.magenta;
    }

    public float getYellow() {
        return this.yellow;
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof RGBColor)) {
            return false;
        }
        if (other.hashCode() == this.hashCode()) {
            return true;
        }
        RGBColor otherColor = (RGBColor)other;
        if (otherColor.getRed() != this.getRed()) {
            return false;
        }
        if (otherColor.getGreen() != this.getGreen()) {
            return false;
        }
        return otherColor.getBlue() == this.getBlue();
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        CharacterBuffer buffer = new CharacterBuffer().withBufferLength(7);
        buffer.with("#");
        this.addHex((int)this.red, buffer);
        this.addHex((int)this.green, buffer);
        this.addHex((int)this.blue, buffer);
        return buffer.toString();
    }

    private void addHex(int value, CharacterBuffer buffer) {
        int t = value / 16;
        int rest = value - t * 16;
        if (t > 9) {
            buffer.with((char)(65 + t - 10));
        } else {
            buffer.with((char)(48 + t));
        }
        if (rest > 9) {
            buffer.with((char)(65 + rest - 10));
        } else {
            buffer.with((char)(48 + rest));
        }
    }
}

