/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser;

import de.uniks.networkparser.interfaces.LocalisationInterface;
import de.uniks.networkparser.interfaces.SendableEntityCreator;
import java.util.TreeMap;

public class TextItems
implements SendableEntityCreator,
LocalisationInterface {
    public static final String PROPERTY_VALUE = "value";
    private TreeMap<String, String> values = new TreeMap();
    private LocalisationInterface customLanguage = null;

    @Override
    public Object getValue(Object entity, String attribute) {
        return ((TextItems)entity).get(attribute);
    }

    @Override
    public boolean setValue(Object entity, String attribute, Object value, String type) {
        return ((TextItems)entity).set(attribute, value);
    }

    public Object get(String attribute) {
        if (this.values.containsKey(attribute)) {
            return this.values.get(attribute);
        }
        return attribute;
    }

    @Override
    public String getText(String label, Object model, Object gui) {
        String text = null;
        if (this.customLanguage != null && (text = this.customLanguage.getText(label, model, gui)) != null) {
            return text;
        }
        text = this.getLabelValue(label + "." + System.getProperty("java.class.version", ""));
        if (text != null) {
            return text;
        }
        text = this.getLabelValue(label);
        if (text != null) {
            return text;
        }
        return label;
    }

    private String getLabelValue(String label) {
        if (this.values.containsKey(label)) {
            return this.values.get(label);
        }
        return null;
    }

    public void addTextLabel(String key, String value) {
        this.values.put(key, value);
    }

    public boolean set(String attribute, Object value) {
        return false;
    }

    @Override
    public String[] getProperties() {
        return new String[]{PROPERTY_VALUE};
    }

    @Override
    public Object getSendableInstance(boolean prototyp) {
        return new TextItems();
    }

    public void setCustomLanguage(LocalisationInterface value) {
        this.customLanguage = value;
    }
}

