/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.bson4jackson;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.io.IOContext;
import de.undercouch.bson4jackson.BsonGenerator;
import de.undercouch.bson4jackson.BsonParser;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;

public class BsonFactory
extends JsonFactory {
    private static final long serialVersionUID = 1991836957699496674L;
    private static final int DEFAULT_BSON_GENERATOR_FEATURE_FLAGS = 0;
    private static final int DEFAULT_BSON_PARSER_FEATURE_FLAGS = 0;
    protected int _bsonGeneratorFeatures = 0;
    protected int _bsonParserFeatures = 0;

    public BsonFactory() {
        this(null);
    }

    public BsonFactory(ObjectCodec oc) {
        super(oc);
    }

    public final BsonFactory configure(BsonGenerator.Feature f, boolean state) {
        if (state) {
            return this.enable(f);
        }
        return this.disable(f);
    }

    public BsonFactory enable(BsonGenerator.Feature f) {
        this._bsonGeneratorFeatures |= f.getMask();
        return this;
    }

    public BsonFactory disable(BsonGenerator.Feature f) {
        this._bsonGeneratorFeatures &= ~f.getMask();
        return this;
    }

    public final boolean isEnabled(BsonGenerator.Feature f) {
        return (this._bsonGeneratorFeatures & f.getMask()) != 0;
    }

    public final BsonFactory configure(BsonParser.Feature f, boolean state) {
        if (state) {
            return this.enable(f);
        }
        return this.disable(f);
    }

    public BsonFactory enable(BsonParser.Feature f) {
        this._bsonParserFeatures |= f.getMask();
        return this;
    }

    public BsonFactory disable(BsonParser.Feature f) {
        this._bsonParserFeatures &= ~f.getMask();
        return this;
    }

    public final boolean isEnabled(BsonParser.Feature f) {
        return (this._bsonParserFeatures & f.getMask()) != 0;
    }

    public BsonGenerator createJsonGenerator(OutputStream out, JsonEncoding enc) throws IOException {
        return this.createJsonGenerator(out);
    }

    public BsonGenerator createJsonGenerator(OutputStream out) throws IOException {
        BsonGenerator g = new BsonGenerator(this._generatorFeatures, this._bsonGeneratorFeatures, out);
        ObjectCodec codec = this.getCodec();
        if (codec != null) {
            g.setCodec(codec);
        }
        return g;
    }

    public BsonParser createJsonParser(InputStream in) throws IOException {
        return this._createJsonParser(in, this._createContext(in, false));
    }

    protected BsonParser _createJsonParser(InputStream in, IOContext ctxt) throws IOException, JsonParseException {
        BsonParser p = new BsonParser(ctxt, this._parserFeatures, this._bsonParserFeatures, in);
        ObjectCodec codec = this.getCodec();
        if (codec != null) {
            p.setCodec(codec);
        }
        return p;
    }

    protected JsonParser _createJsonParser(Reader r, IOContext ctxt) throws IOException, JsonParseException {
        throw new UnsupportedOperationException("Can not create reader for non-byte-based source");
    }

    protected JsonParser _createJsonParser(byte[] data, int offset, int len, IOContext ctxt) throws IOException, JsonParseException {
        return this._createJsonParser(new ByteArrayInputStream(data, offset, len), ctxt);
    }

    protected JsonGenerator _createUTF8JsonGenerator(OutputStream out, IOContext ctxt) throws IOException {
        return this.createJsonGenerator(out, ctxt.getEncoding());
    }

    protected JsonGenerator _createJsonGenerator(Writer out, IOContext ctxt) throws IOException {
        throw new UnsupportedOperationException("Can not create generator for non-byte-based target");
    }

    protected Writer _createWriter(OutputStream out, JsonEncoding enc, IOContext ctxt) throws IOException {
        throw new UnsupportedOperationException("Can not create generator for non-byte-based target");
    }
}

