/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.bson4jackson.io;

import de.undercouch.bson4jackson.io.StaticBuffers;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;

public class DynamicOutputBuffer {
    public static final ByteOrder DEFAULT_BYTE_ORDER = ByteOrder.BIG_ENDIAN;
    private static final StaticBuffers.Key BUFFER_KEY = StaticBuffers.Key.BUFFER2;
    public static final int DEFAULT_BUFFER_SIZE = Math.max(65536, 8192);
    private final ByteOrder _order;
    private final int _bufferSize;
    private int _position;
    private int _flushPosition;
    private int _size;
    private List<ByteBuffer> _buffers = new ArrayList<ByteBuffer>(1);
    private Charset _utf8;
    private CharsetEncoder _utf8Encoder;
    private Queue<ByteBuffer> _buffersToReuse;
    private int _reuseBuffersCount = 0;

    public DynamicOutputBuffer() {
        this(DEFAULT_BYTE_ORDER);
    }

    public DynamicOutputBuffer(int n) {
        this(DEFAULT_BYTE_ORDER, n);
    }

    public DynamicOutputBuffer(ByteOrder byteOrder) {
        this(byteOrder, DEFAULT_BUFFER_SIZE);
    }

    public DynamicOutputBuffer(ByteOrder byteOrder, int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Initial buffer size must be larger than 0");
        }
        this._order = byteOrder;
        this._bufferSize = n;
        this.clear();
    }

    public void setReuseBuffersCount(int n) {
        this._reuseBuffersCount = n;
        if (this._buffersToReuse != null) {
            if (this._reuseBuffersCount == 0) {
                this._buffersToReuse = null;
            } else {
                while (this._reuseBuffersCount < this._buffersToReuse.size()) {
                    this._buffersToReuse.poll();
                }
            }
        }
    }

    private ByteBuffer allocateBuffer() {
        if (this._buffersToReuse != null && !this._buffersToReuse.isEmpty()) {
            ByteBuffer byteBuffer = this._buffersToReuse.poll();
            byteBuffer.rewind();
            byteBuffer.limit(byteBuffer.capacity());
            return byteBuffer;
        }
        ByteBuffer byteBuffer = StaticBuffers.getInstance().byteBuffer(BUFFER_KEY, this._bufferSize);
        byteBuffer.limit(this._bufferSize);
        return byteBuffer.order(this._order);
    }

    private void deallocateBuffer(int n) {
        ByteBuffer byteBuffer = this._buffers.set(n, null);
        if (byteBuffer != null && this._reuseBuffersCount > 0) {
            if (this._buffersToReuse == null) {
                this._buffersToReuse = new LinkedList<ByteBuffer>();
            }
            if (this._reuseBuffersCount > this._buffersToReuse.size()) {
                this._buffersToReuse.add(byteBuffer);
            }
        }
    }

    private ByteBuffer addNewBuffer() {
        ByteBuffer byteBuffer = this.allocateBuffer();
        this._buffers.add(byteBuffer);
        return byteBuffer;
    }

    private ByteBuffer getBuffer(int n) {
        int n2 = n / this._bufferSize;
        while (n2 >= this._buffers.size()) {
            this.addNewBuffer();
        }
        return this._buffers.get(n2);
    }

    private void adaptSize(int n) {
        if (n > this._size) {
            this._size = n;
        }
    }

    private Charset getUTF8Charset() {
        if (this._utf8 == null) {
            this._utf8 = Charset.forName("UTF-8");
        }
        return this._utf8;
    }

    private CharsetEncoder getUTF8Encoder() {
        if (this._utf8Encoder == null) {
            this._utf8Encoder = this.getUTF8Charset().newEncoder();
        }
        return this._utf8Encoder;
    }

    public int size() {
        return this._size;
    }

    public void clear() {
        if (this._buffersToReuse != null && !this._buffersToReuse.isEmpty()) {
            StaticBuffers.getInstance().releaseByteBuffer(BUFFER_KEY, this._buffersToReuse.peek());
        } else if (!this._buffers.isEmpty()) {
            StaticBuffers.getInstance().releaseByteBuffer(BUFFER_KEY, this._buffers.get(0));
        }
        if (this._buffersToReuse != null) {
            this._buffersToReuse.clear();
        }
        this._buffers.clear();
        this._position = 0;
        this._flushPosition = 0;
        this._size = 0;
    }

    public void putByte(byte by) {
        this.putByte(this._position, by);
        ++this._position;
    }

    public void putBytes(byte ... byArray) {
        this.putBytes(this._position, byArray);
        this._position += byArray.length;
    }

    public void putByte(int n, byte by) {
        this.adaptSize(n + 1);
        ByteBuffer byteBuffer = this.getBuffer(n);
        int n2 = n % this._bufferSize;
        byteBuffer.put(n2, by);
    }

    public void putBytes(int n, byte ... byArray) {
        this.adaptSize(n + byArray.length);
        ByteBuffer byteBuffer = null;
        int n2 = this._bufferSize;
        for (byte by : byArray) {
            if (n2 == this._bufferSize) {
                byteBuffer = this.getBuffer(n);
                n2 = n % this._bufferSize;
            }
            byteBuffer.put(n2, by);
            ++n2;
            ++n;
        }
    }

    public void putInt(int n) {
        this.putInt(this._position, n);
        this._position += 4;
    }

    public void putInt(int n, int n2) {
        this.adaptSize(n + 4);
        ByteBuffer byteBuffer = this.getBuffer(n);
        int n3 = n % this._bufferSize;
        if (byteBuffer.limit() - n3 >= 4) {
            byteBuffer.putInt(n3, n2);
        } else {
            byte by = (byte)n2;
            byte by2 = (byte)(n2 >> 8);
            byte by3 = (byte)(n2 >> 16);
            byte by4 = (byte)(n2 >> 24);
            if (this._order == ByteOrder.BIG_ENDIAN) {
                this.putBytes(n, by4, by3, by2, by);
            } else {
                this.putBytes(n, by, by2, by3, by4);
            }
        }
    }

    public void putLong(long l) {
        this.putLong(this._position, l);
        this._position += 8;
    }

    public void putLong(int n, long l) {
        this.adaptSize(n + 8);
        ByteBuffer byteBuffer = this.getBuffer(n);
        int n2 = n % this._bufferSize;
        if (byteBuffer.limit() - n2 >= 8) {
            byteBuffer.putLong(n2, l);
        } else {
            byte by = (byte)l;
            byte by2 = (byte)(l >> 8);
            byte by3 = (byte)(l >> 16);
            byte by4 = (byte)(l >> 24);
            byte by5 = (byte)(l >> 32);
            byte by6 = (byte)(l >> 40);
            byte by7 = (byte)(l >> 48);
            byte by8 = (byte)(l >> 56);
            if (this._order == ByteOrder.BIG_ENDIAN) {
                this.putBytes(n, by8, by7, by6, by5, by4, by3, by2, by);
            } else {
                this.putBytes(n, by, by2, by3, by4, by5, by6, by7, by8);
            }
        }
    }

    public void putFloat(float f) {
        this.putFloat(this._position, f);
        this._position += 4;
    }

    public void putFloat(int n, float f) {
        this.putInt(n, Float.floatToRawIntBits(f));
    }

    public void putDouble(double d) {
        this.putDouble(this._position, d);
        this._position += 8;
    }

    public void putDouble(int n, double d) {
        this.putLong(n, Double.doubleToRawLongBits(d));
    }

    public void putString(CharSequence charSequence) {
        this.putString(this._position, charSequence);
        this._position += charSequence.length() * 2;
    }

    public void putString(int n, CharSequence charSequence) {
        for (int i = 0; i < charSequence.length(); ++i) {
            char c = charSequence.charAt(i);
            byte by = (byte)c;
            byte by2 = (byte)(c >> 8);
            if (this._order == ByteOrder.BIG_ENDIAN) {
                this.putBytes(n, by2, by);
            } else {
                this.putBytes(n, by, by2);
            }
            n += 2;
        }
    }

    public int putUTF8(String string) {
        int n = this.putUTF8(this._position, string);
        this._position += n;
        return n;
    }

    public int putUTF8(int n, String string) {
        ByteBuffer byteBuffer = null;
        CharsetEncoder charsetEncoder = this.getUTF8Encoder();
        CharBuffer charBuffer = CharBuffer.wrap(string);
        int n2 = n;
        ByteBuffer byteBuffer2 = this.getBuffer(n2);
        int n3 = n2 % this._bufferSize;
        byteBuffer2.position(n3);
        while (charBuffer.remaining() > 0) {
            CoderResult coderResult = charsetEncoder.encode(charBuffer, byteBuffer2, true);
            if (byteBuffer2 == byteBuffer) {
                byteBuffer2.flip();
                while (byteBuffer2.remaining() > 0) {
                    this.putByte(n2, byteBuffer2.get());
                    ++n2;
                }
            } else {
                n2 += byteBuffer2.position() - n3;
            }
            if (coderResult.isOverflow()) {
                if (byteBuffer2.remaining() > 0) {
                    if (byteBuffer == null) {
                        byteBuffer = ByteBuffer.allocate(4);
                    }
                    byteBuffer.rewind();
                    byteBuffer2 = byteBuffer;
                    n3 = 0;
                    continue;
                }
                byteBuffer2 = this.getBuffer(n2);
                n3 = n2 % this._bufferSize;
                byteBuffer2.position(n3);
                continue;
            }
            if (!coderResult.isError()) continue;
            try {
                coderResult.throwException();
            }
            catch (CharacterCodingException characterCodingException) {
                throw new RuntimeException("Could not encode string", characterCodingException);
            }
        }
        this.adaptSize(n2);
        return n2 - n;
    }

    public void flushTo(OutputStream outputStream) throws IOException {
        int n = this._flushPosition / this._bufferSize;
        int n2 = this._position / this._bufferSize;
        if (n < n2) {
            this.flushTo(Channels.newChannel(outputStream));
        }
    }

    public void flushTo(WritableByteChannel writableByteChannel) throws IOException {
        int n = this._position / this._bufferSize;
        for (int i = this._flushPosition / this._bufferSize; i < n; ++i) {
            ByteBuffer byteBuffer = this._buffers.get(i);
            byteBuffer.rewind();
            writableByteChannel.write(byteBuffer);
            this.deallocateBuffer(i);
            this._flushPosition += this._bufferSize;
        }
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        this.writeTo(Channels.newChannel(outputStream));
    }

    public void writeTo(WritableByteChannel writableByteChannel) throws IOException {
        int n = this._flushPosition / this._bufferSize;
        int n2 = this._buffers.size();
        int n3 = this._size - this._flushPosition;
        while (n < n2) {
            int n4 = Math.min(n3, this._bufferSize);
            ByteBuffer byteBuffer = this._buffers.get(n);
            byteBuffer.position(n4);
            byteBuffer.flip();
            writableByteChannel.write(byteBuffer);
            ++n;
            n3 -= n4;
        }
    }
}

