/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.test.api.jupiter;

import de.tum.in.test.api.internal.ConfigurationUtils;
import de.tum.in.test.api.jupiter.JupiterContext;
import de.tum.in.test.api.jupiter.UnifiedInvocationInterceptor;
import de.tum.in.test.api.security.ArtemisSecurityConfiguration;
import de.tum.in.test.api.security.ArtemisSecurityManager;
import java.util.Optional;
import org.apiguardian.api.API;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.InvocationInterceptor;
import org.junit.jupiter.api.extension.ReflectiveInvocationContext;

@API(status=API.Status.INTERNAL)
public final class JupiterSecurityExtension
implements UnifiedInvocationInterceptor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T interceptGenericInvocation(InvocationInterceptor.Invocation<T> invocation, ExtensionContext extensionContext, Optional<ReflectiveInvocationContext<?>> invocationContext) throws Throwable {
        JupiterContext testContext = JupiterContext.of(extensionContext);
        ArtemisSecurityConfiguration configuration = ConfigurationUtils.generateConfiguration(testContext);
        String accessToken = ArtemisSecurityManager.install(configuration);
        Throwable failure = null;
        try {
            Object object = invocation.proceed();
            return (T)object;
        }
        catch (Throwable t) {
            failure = t;
        }
        finally {
            try {
                ArtemisSecurityManager.uninstall(accessToken);
            }
            catch (Exception e) {
                if (failure == null) {
                    failure = e;
                }
                failure.addSuppressed(e);
            }
        }
        throw failure;
    }
}

