/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.test.api.security;

import de.tum.in.test.api.TrustedThreads;
import de.tum.in.test.api.util.PackageRule;
import de.tum.in.test.api.util.PathRule;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import org.apiguardian.api.API;

@API(status=API.Status.INTERNAL)
public final class ArtemisSecurityConfiguration {
    private final Optional<Class<?>> testClass;
    private final Optional<Method> testMethod;
    private final Path executionPath;
    private final List<String> whitelistedClassNames;
    private final Optional<Set<PathRule>> whitelistedPaths;
    private final Set<PathRule> blacklistedPaths;
    private final Set<Integer> allowedLocalPorts;
    private final OptionalInt allowLocalPortsAbove;
    private final Set<Integer> excludedLocalPorts;
    private final OptionalInt allowedThreadCount;
    private final Set<PackageRule> blacklistedPackages;
    private final Set<PackageRule> whitelistedPackages;
    private final Set<PackageRule> trustedPackages;
    private final TrustedThreads.TrustScope threadTrustScope;

    ArtemisSecurityConfiguration(Optional<Class<?>> testClass, Optional<Method> testMethod, Path executionPath, Collection<String> whitelistedClassNames, Optional<Collection<PathRule>> whitelistedPaths, Collection<PathRule> blacklistedPaths, Set<Integer> allowedLocalPorts, OptionalInt allowLocalPortsAbove, Set<Integer> excludedLocalPorts, OptionalInt allowedThreadCount, Set<PackageRule> blacklistedPackages, Set<PackageRule> whitelistedPackages, Set<PackageRule> trustedPackages, TrustedThreads.TrustScope threadTrustScope) {
        this.testClass = Objects.requireNonNull(testClass);
        this.testMethod = Objects.requireNonNull(testMethod);
        this.executionPath = executionPath.toAbsolutePath();
        this.whitelistedClassNames = List.copyOf(whitelistedClassNames);
        this.whitelistedPaths = whitelistedPaths.map(Set::copyOf);
        this.blacklistedPaths = Set.copyOf(blacklistedPaths);
        this.allowedLocalPorts = Set.copyOf(allowedLocalPorts);
        this.allowLocalPortsAbove = Objects.requireNonNull(allowLocalPortsAbove);
        this.excludedLocalPorts = Set.copyOf(excludedLocalPorts);
        this.allowedThreadCount = Objects.requireNonNull(allowedThreadCount);
        this.blacklistedPackages = Set.copyOf(blacklistedPackages);
        this.whitelistedPackages = Set.copyOf(whitelistedPackages);
        this.trustedPackages = Set.copyOf(trustedPackages);
        this.threadTrustScope = threadTrustScope;
    }

    public Optional<Class<?>> testClass() {
        return this.testClass;
    }

    public Optional<Method> testMethod() {
        return this.testMethod;
    }

    public Path executionPath() {
        return this.executionPath;
    }

    public List<String> whitelistedClassNames() {
        return this.whitelistedClassNames;
    }

    public Optional<Set<PathRule>> whitelistedPaths() {
        return this.whitelistedPaths;
    }

    public Set<PathRule> blacklistedPaths() {
        return this.blacklistedPaths;
    }

    public Set<Integer> allowedLocalPorts() {
        return this.allowedLocalPorts;
    }

    public OptionalInt allowLocalPortsAbove() {
        return this.allowLocalPortsAbove;
    }

    public Set<Integer> excludedLocalPorts() {
        return this.excludedLocalPorts;
    }

    public OptionalInt allowedThreadCount() {
        return this.allowedThreadCount;
    }

    public Set<PackageRule> blacklistedPackages() {
        return this.blacklistedPackages;
    }

    public Set<PackageRule> whitelistedPackages() {
        return this.whitelistedPackages;
    }

    public Set<PackageRule> trustedPackages() {
        return this.trustedPackages;
    }

    public TrustedThreads.TrustScope threadTrustScope() {
        return this.threadTrustScope;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ArtemisSecurityConfiguration)) {
            return false;
        }
        ArtemisSecurityConfiguration other = (ArtemisSecurityConfiguration)obj;
        return Objects.equals(this.executionPath, other.executionPath) && Objects.equals(this.testClass, other.testClass) && Objects.equals(this.testMethod, other.testMethod) && Objects.equals(this.whitelistedClassNames, other.whitelistedClassNames) && Objects.equals(this.allowedLocalPorts, other.allowedLocalPorts) && Objects.equals(this.allowLocalPortsAbove, other.allowLocalPortsAbove) && Objects.equals(this.excludedLocalPorts, other.excludedLocalPorts) && Objects.equals(this.allowedThreadCount, other.allowedThreadCount) && Objects.equals(this.whitelistedPaths, other.whitelistedPaths) && Objects.equals(this.blacklistedPaths, other.blacklistedPaths) && Objects.equals(this.blacklistedPackages, other.blacklistedPackages) && Objects.equals(this.whitelistedPackages, other.whitelistedPackages) && Objects.equals((Object)this.threadTrustScope, (Object)other.threadTrustScope);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.executionPath, this.testClass, this.testMethod, this.whitelistedClassNames, this.allowedThreadCount, this.whitelistedPaths, this.blacklistedPaths, this.blacklistedPackages, this.whitelistedPackages, this.threadTrustScope});
    }

    public String toString() {
        return String.format("ArtemisSecurityConfigurationImpl [whitelistedClassNames=%s, executionPath=%s, testClass=%s, testMethod=%s, whitelistedPaths=%s, blacklistedPaths=%s, allowedLocalPorts=%s, allowLocalPortsAbove=%s, excludedLocalPorts=%s, allowedThreadCount=%s, blacklistedPackages=%s, whitelistedPackages=%s, trustedPackages=%s, threadTrustScope=%s]", new Object[]{this.whitelistedClassNames, this.executionPath, this.testClass, this.testMethod, this.whitelistedPaths, this.blacklistedPaths, this.allowedLocalPorts, this.allowLocalPortsAbove, this.excludedLocalPorts, this.allowedThreadCount, this.blacklistedPackages, this.whitelistedPackages, this.trustedPackages, this.threadTrustScope});
    }

    public String shortDesc() {
        return String.format("ASC-Impl [testMethod=%s, executionPath=%s, whitelistedPaths=%s, blacklistedPaths=%s, allowedLocalPorts=%s, trustedPackages=%s]", this.testMethod, this.executionPath, this.whitelistedPaths, this.blacklistedPaths, this.allowedLocalPorts, this.trustedPackages);
    }
}

