/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.test.api.internal;

import de.tum.in.test.api.PrivilegedExceptionsOnly;
import de.tum.in.test.api.StrictTimeout;
import de.tum.in.test.api.internal.BlacklistedInvoker;
import de.tum.in.test.api.internal.PrivilegedException;
import de.tum.in.test.api.internal.TestContext;
import de.tum.in.test.api.internal.TestContextUtils;
import de.tum.in.test.api.localization.Messages;
import de.tum.in.test.api.security.ArtemisSecurityManager;
import java.lang.invoke.CallSite;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.jupiter.api.function.ThrowingSupplier;
import org.opentest4j.AssertionFailedError;

public final class TimeoutUtils {
    private TimeoutUtils() {
    }

    public static Optional<Duration> findTimeout(TestContext context) {
        Optional<StrictTimeout> strictTimeout = TestContextUtils.findAnnotationIn(context, StrictTimeout.class);
        return strictTimeout.map(st -> Duration.of(st.value(), st.unit().toChronoUnit()));
    }

    public static <T> T performTimeoutExecution(ThrowingSupplier<T> execution, TestContext context) throws Throwable {
        Optional<Duration> timeout = TimeoutUtils.findTimeout(context);
        if (timeout.isEmpty()) {
            return (T)execution.get();
        }
        return (T)TimeoutUtils.executeWithTimeout(timeout.get(), () -> TimeoutUtils.rethrowThrowableSafe(execution), context);
    }

    private static <T> T rethrowThrowableSafe(ThrowingSupplier<T> execution) throws Exception {
        try {
            return (T)execution.get();
        }
        catch (Error | Exception e) {
            throw e;
        }
        catch (Throwable t) {
            throw new ExecutionException(t);
        }
    }

    private static <T> T executeWithTimeout(Duration timeout, Callable<T> action, TestContext context) throws Throwable {
        ArtemisSecurityManager.revokeThreadWhitelisting();
        ExecutorService executorService = Executors.newSingleThreadExecutor(new WhitelistedThreadFactory());
        try {
            Future future = executorService.submit(action);
            Object object = BlacklistedInvoker.invokeChecked(() -> future.get(timeout.toMillis(), TimeUnit.MILLISECONDS));
            return (T)object;
        }
        catch (ExecutionException ex) {
            if (ex.getCause() instanceof ExecutionException) {
                throw ex.getCause().getCause();
            }
            throw ex.getCause();
        }
        catch (TimeoutException ex) {
            throw TimeoutUtils.generateTimeoutFailure(timeout, context);
        }
        finally {
            executorService.shutdownNow();
        }
    }

    private static AssertionFailedError generateTimeoutFailure(Duration timeout, TestContext context) {
        AssertionFailedError failure = new AssertionFailedError(Messages.formatLocalized("timeout.failure_message", TimeoutUtils.formatDuration(timeout)));
        if (TestContextUtils.findAnnotationIn(context, PrivilegedExceptionsOnly.class).isPresent()) {
            throw new PrivilegedException((Throwable)failure);
        }
        return failure;
    }

    private static String formatDuration(Duration duration) {
        ArrayList<CallSite> parts = new ArrayList<CallSite>();
        long h = duration.toHours();
        int m = duration.toMinutesPart();
        int s = duration.toSecondsPart();
        int ms = duration.toMillisPart();
        if (h != 0L) {
            parts.add((CallSite)((Object)(h + " h")));
        }
        if (m != 0) {
            parts.add((CallSite)((Object)(m + " min")));
        }
        if (s != 0) {
            parts.add((CallSite)((Object)(s + " s")));
        }
        if (ms != 0) {
            parts.add((CallSite)((Object)(ms + " ms")));
        }
        return String.join((CharSequence)" ", parts);
    }

    static {
        ArtemisSecurityManager.isInstalled();
    }

    private static class WhitelistedThreadFactory
    implements ThreadFactory {
        private static final AtomicInteger TIMEOUT_THREAD_ID = new AtomicInteger(1);

        private WhitelistedThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r, "ajts-to-" + TIMEOUT_THREAD_ID.getAndIncrement());
            if (thread.getPriority() != 5) {
                thread.setPriority(5);
            }
            ArtemisSecurityManager.requestThreadWhitelisting(thread);
            return thread;
        }
    }
}

