/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.test.api.jqwik;

import de.tum.in.test.api.context.TestContext;
import de.tum.in.test.api.internal.ReportingUtils;
import de.tum.in.test.api.internal.TestGuardUtils;
import de.tum.in.test.api.jqwik.JqwikContext;
import java.util.Optional;
import net.jqwik.api.lifecycle.AroundPropertyHook;
import net.jqwik.api.lifecycle.PropertyExecutionResult;
import net.jqwik.api.lifecycle.PropertyExecutor;
import net.jqwik.api.lifecycle.PropertyLifecycleContext;
import org.apiguardian.api.API;

@API(status=API.Status.INTERNAL)
public final class JqwikTestGuard
implements AroundPropertyHook {
    public int aroundPropertyProximity() {
        return 10;
    }

    public PropertyExecutionResult aroundProperty(PropertyLifecycleContext context, PropertyExecutor property) throws Throwable {
        JqwikContext jqwikContext = JqwikContext.of(context);
        TestGuardUtils.checkForHidden(jqwikContext);
        return (PropertyExecutionResult)ReportingUtils.doProceedAndPostProcess(() -> JqwikTestGuard.postProcess(property.execute(), jqwikContext), jqwikContext);
    }

    private static PropertyExecutionResult postProcess(PropertyExecutionResult per, TestContext context) {
        Optional t = per.throwable();
        if (t.isEmpty()) {
            return per;
        }
        Throwable newT = ReportingUtils.processThrowable((Throwable)t.get(), context);
        if (newT instanceof Error && !(newT instanceof AssertionError)) {
            throw (Error)newT;
        }
        return per.mapTo(per.status(), newT);
    }
}

