/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.test.api.internal.sanitization;

import de.tum.in.test.api.internal.BlacklistedInvoker;
import de.tum.in.test.api.internal.sanitization.ThrowableSanitizer;
import de.tum.in.test.api.internal.sanitization.ThrowableUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.UnaryOperator;
import org.apiguardian.api.API;

@API(status=API.Status.INTERNAL)
public final class ThrowableInfo {
    private final Class<? extends Throwable> type;
    private String message;
    private Throwable cause;
    private StackTraceElement[] stackTrace;
    private Throwable[] suppressed;
    private Map<String, Object> additionalProperties;
    private boolean sanitized;

    private ThrowableInfo(Class<? extends Throwable> type, String message, Throwable cause, StackTraceElement[] stackTrace, Throwable[] suppressed, Map<String, Object> additionalProperties) {
        this.type = type;
        this.message = message;
        this.cause = cause;
        this.stackTrace = stackTrace;
        this.suppressed = suppressed;
        this.additionalProperties = additionalProperties;
    }

    public Class<? extends Throwable> getType() {
        return this.type;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Throwable getCause() {
        return this.cause;
    }

    public void setCause(Throwable cause) {
        this.cause = cause;
        this.sanitized = false;
    }

    public StackTraceElement[] getStackTrace() {
        return this.stackTrace;
    }

    public void setStackTrace(StackTraceElement[] stackTrace) {
        this.stackTrace = stackTrace;
    }

    public Throwable[] getSuppressed() {
        return (Throwable[])this.suppressed.clone();
    }

    public void setSuppressed(Throwable[] suppressed) {
        this.suppressed = suppressed;
        this.sanitized = false;
    }

    public Map<String, Object> getAdditionalProperties() {
        return Collections.unmodifiableMap(this.additionalProperties);
    }

    public void setAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        this.sanitized = false;
    }

    public boolean isSanitized() {
        return this.sanitized;
    }

    public ThrowableInfo sanitize() {
        this.cause = ThrowableSanitizer.sanitize(this.cause);
        this.suppressed = (Throwable[])this.suppressed.clone();
        for (int i = 0; i < this.suppressed.length; ++i) {
            this.suppressed[i] = ThrowableSanitizer.sanitize(this.suppressed[i]);
        }
        this.sanitized = this.additionalProperties.isEmpty();
        return this;
    }

    public ThrowableInfo sanitize(BiFunction<String, Object, Object> additionalPropertySanitizer) {
        this.sanitize();
        this.additionalProperties = new HashMap<String, Object>(this.additionalProperties);
        this.additionalProperties.replaceAll(additionalPropertySanitizer);
        this.sanitized = true;
        return this;
    }

    public Map<String, Object> toPropertyMap() {
        HashMap<String, Object> properties = new HashMap<String, Object>(this.additionalProperties);
        properties.put("message", this.message);
        properties.put("cause", this.cause);
        properties.put("stackTrace", this.stackTrace);
        properties.put("suppressed", this.suppressed);
        return properties;
    }

    public <T> T getProperty(PropertyKey<T> key) {
        return key.cast(this.additionalProperties.get(key.name()));
    }

    public <T> void setProperty(PropertyKey<T> key, T newValue) {
        this.additionalProperties.put(key.name(), key.cast(newValue));
    }

    public static ThrowableInfo of(Class<? extends Throwable> type, String message, Throwable cause, StackTraceElement[] stackTrace, Throwable[] suppressed, Map<String, Object> additionalProperties) {
        return new ThrowableInfo(type, message, cause, (StackTraceElement[])stackTrace.clone(), (Throwable[])suppressed.clone(), new HashMap<String, Object>(additionalProperties));
    }

    public static ThrowableInfo of(Class<? extends Throwable> type, Map<String, Object> properties) {
        String message = (String)properties.get("message");
        Throwable cause = (Throwable)properties.get("cause");
        StackTraceElement[] stackTrace = (StackTraceElement[])properties.get("stackTrace");
        Throwable[] suppressed = (Throwable[])properties.get("suppressed");
        HashMap<String, Object> additionalProperties = new HashMap<String, Object>(properties);
        for (String throwableProperty : ThrowableUtils.THROWABLE_PROPERTIES) {
            additionalProperties.remove(throwableProperty);
        }
        return new ThrowableInfo(type, message, cause, (StackTraceElement[])stackTrace.clone(), (Throwable[])suppressed.clone(), additionalProperties);
    }

    public static ThrowableInfo getEssentialInfosSafeFrom(Throwable source) {
        String message = BlacklistedInvoker.invoke(source::getMessage);
        Throwable cause = BlacklistedInvoker.invoke(source::getCause);
        StackTraceElement[] stackTrace = BlacklistedInvoker.invoke(source::getStackTrace);
        Throwable[] suppressed = source.getSuppressed();
        return ThrowableInfo.of(source.getClass(), message, cause, stackTrace, suppressed, Map.of());
    }

    public static class PropertyKey<T> {
        private final Class<T> type;
        private final String name;
        private final UnaryOperator<T> sanitizer;

        public PropertyKey(Class<T> type, String name, UnaryOperator<T> sanitizer) {
            this.type = Objects.requireNonNull(type);
            this.name = Objects.requireNonNull(name);
            this.sanitizer = Objects.requireNonNull(sanitizer);
        }

        public PropertyKey(Class<T> type, String name) {
            this(type, name, UnaryOperator.identity());
        }

        public final String name() {
            return this.name;
        }

        public final Class<T> type() {
            return this.type;
        }

        public T sanitize(T value) {
            return (T)this.sanitizer.apply(value);
        }

        final T cast(Object value) {
            if (value == null && this.type.isPrimitive()) {
                throw new NullPointerException("cannot cast null to primitive: " + String.valueOf(this.type));
            }
            if (Byte.TYPE.equals(this.type)) {
                return Byte.class.cast(value);
            }
            if (Short.TYPE.equals(this.type)) {
                return Short.class.cast(value);
            }
            if (Character.TYPE.equals(this.type)) {
                return Character.class.cast(value);
            }
            if (Integer.TYPE.equals(this.type)) {
                return Integer.class.cast(value);
            }
            if (Long.TYPE.equals(this.type)) {
                return Long.class.cast(value);
            }
            if (Float.TYPE.equals(this.type)) {
                return Float.class.cast(value);
            }
            if (Double.TYPE.equals(this.type)) {
                return Double.class.cast(value);
            }
            return this.type.cast(value);
        }
    }
}

