/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.test.api.internal;

import de.tum.in.test.api.WithIOManager;
import de.tum.in.test.api.context.TestContext;
import de.tum.in.test.api.context.TestContextUtils;
import de.tum.in.test.api.io.AresIOContext;
import de.tum.in.test.api.io.IOManager;
import de.tum.in.test.api.io.IOTesterManager;
import de.tum.in.test.api.security.ArtemisSecurityManager;
import java.lang.annotation.AnnotationFormatError;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.HashMap;
import java.util.Objects;
import java.util.function.Supplier;
import org.apiguardian.api.API;

@API(status=API.Status.INTERNAL)
public final class IOExtensionUtils {
    private static final Class<IOTesterManager> DEFAULT_IO_MANAGER = IOTesterManager.class;
    private static final HashMap<Class<? extends IOManager<?>>, Supplier<? extends IOManager<?>>> ioManagerCache;
    private final AresIOContext context;
    private final IOManager<?> ioManager;
    private final Class<?> controllerClass;

    public IOExtensionUtils(TestContext testContext) {
        this.context = AresIOContext.from(testContext);
        this.ioManager = IOExtensionUtils.createIOManagerFor(testContext);
        this.controllerClass = this.ioManager.getControllerClass();
    }

    public void beforeTestExecution() {
        this.ioManager.beforeTestExecution(this.context);
    }

    public void afterTestExecution() {
        this.ioManager.afterTestExecution(this.context);
    }

    public boolean providesController() {
        return this.controllerClass != null;
    }

    public Object getControllerInstance() {
        return this.providesController() ? this.ioManager.getControllerInstance(this.context) : null;
    }

    public boolean canProvideControllerFor(Class<?> targetType) {
        return this.providesController() && Objects.class != targetType && targetType.isAssignableFrom(this.controllerClass);
    }

    private static IOManager<?> createIOManagerFor(TestContext testContext) {
        Class<IOTesterManager> ioManagerClass = TestContextUtils.findAnnotationIn(testContext, WithIOManager.class).map(WithIOManager::value).orElse(DEFAULT_IO_MANAGER);
        return (IOManager)ioManagerCache.computeIfAbsent(ioManagerClass, IOExtensionUtils::generateIOManagerSupplier).get();
    }

    private static Supplier<IOManager<?>> generateIOManagerSupplier(Class<? extends IOManager<?>> ioManagerClass) {
        try {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            MethodHandle contructor = lookup.findConstructor(ioManagerClass, MethodType.methodType(Void.TYPE));
            MethodHandle factory = LambdaMetafactory.metafactory(lookup, "get", MethodType.methodType(Supplier.class), contructor.type().generic(), contructor, contructor.type()).getTarget();
            return factory.invokeExact();
        }
        catch (Throwable e) {
            throw new AnnotationFormatError("Could not create IOManager Supplier for type " + ioManagerClass.getCanonicalName() + ". Make sure a public no-args constructor is available.", e);
        }
    }

    static {
        ArtemisSecurityManager.isInstalled();
        ioManagerCache = new HashMap();
    }
}

