/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.test.api.dynamic;

import de.tum.in.test.api.dynamic.Check;
import de.tum.in.test.api.dynamic.Checkable;
import de.tum.in.test.api.dynamic.DynamicClass;
import de.tum.in.test.api.localization.Messages;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apiguardian.api.API;

@API(status=API.Status.MAINTAINED)
public class DynamicField<T>
implements Checkable {
    private final DynamicClass<?> owner;
    private final List<String> name;
    private final DynamicClass<T> type;
    private final boolean ignoreCase;
    private Field field;

    public DynamicField(DynamicClass<?> dClass, Class<T> fType, boolean ignoreCase, String ... possibleNames) {
        this(dClass, DynamicClass.toDynamic(fType), ignoreCase, possibleNames);
    }

    public DynamicField(DynamicClass<?> dClass, DynamicClass<T> fType, boolean ignoreCase, String ... possibleNames) {
        this.owner = Objects.requireNonNull(dClass);
        this.name = ignoreCase ? Stream.of(possibleNames).map(String::toLowerCase).collect(Collectors.toUnmodifiableList()) : List.of(possibleNames);
        this.type = Objects.requireNonNull(fType);
        this.ignoreCase = ignoreCase;
    }

    public Field toField() {
        if (this.field == null) {
            Optional<Field> of = this.findField(this.owner.toClass());
            if (!of.isPresent()) {
                throw Messages.localizedFailure("dynamics.field.not_found", this.name);
            }
            this.field = of.get();
            this.field.trySetAccessible();
        }
        return this.field;
    }

    @Override
    public boolean exists() {
        if (this.field == null) {
            Optional<Field> of = this.findField(this.owner.toClass());
            if (!of.isPresent()) {
                return false;
            }
            this.field = of.get();
            this.field.trySetAccessible();
        }
        return true;
    }

    public T getOf(Object o) {
        try {
            return this.type.cast(this.toField().get(o));
        }
        catch (IllegalAccessException e) {
            throw Messages.localizedFailure(e, "dynamics.field.access", this.name, this.owner);
        }
        catch (IllegalArgumentException e) {
            throw Messages.localizedFailure(e, "dynamics.field.target", this.name, this.owner);
        }
        catch (ClassCastException e) {
            throw Messages.localizedFailure(e, "dynamics.field.cast", this.name, this.owner, this.type.getName());
        }
    }

    public T getStatic() {
        try {
            return this.getOf(null);
        }
        catch (NullPointerException e) {
            throw Messages.localizedFailure(e, "dynamics.field.static", this.name, this.owner);
        }
    }

    public void setOf(Object o, T newValue) {
        if (Modifier.isFinal(this.toField().getModifiers())) {
            throw Messages.localizedFailure("dynamics.field.final", this.name, this.owner);
        }
        try {
            this.toField().set(o, this.type.cast(newValue));
        }
        catch (IllegalAccessException e) {
            throw Messages.localizedFailure(e, "dynamics.field.access", this.name, this.owner);
        }
        catch (IllegalArgumentException e) {
            throw Messages.localizedFailure(e, "dynamics.field.target", this.name, this.owner);
        }
        catch (ClassCastException e) {
            throw Messages.localizedFailure(e, "dynamics.field.cast_set", this.name, this.owner, this.type.getName(), newValue == null ? "null" : newValue.getClass());
        }
    }

    public void setStatic(T newValue) {
        try {
            this.setOf(null, newValue);
        }
        catch (NullPointerException e) {
            throw Messages.localizedFailure(e, "dynamics.field.static", this.name, this.owner);
        }
    }

    private Optional<Field> findField(Class<?> c) {
        return this.fieldsOf(c).stream().filter(f -> this.name.contains(this.ignoreCase ? f.getName().toLowerCase() : f.getName())).findFirst();
    }

    private List<Field> fieldsOf(Class<?> c) {
        ArrayList<Field> al = new ArrayList<Field>();
        for (Class<?> current = c; current != Object.class; current = current.getSuperclass()) {
            for (Field ff : current.getDeclaredFields()) {
                if (!this.type.toClass().isAssignableFrom(ff.getType())) continue;
                al.add(ff);
            }
        }
        return al;
    }

    public String toString() {
        return this.owner.toString() + "." + String.valueOf(this.name);
    }

    @Override
    public void check(Check ... checks) {
        int modifiers = this.toField().getModifiers();
        for (Check check : checks) {
            check.checkModifiers(modifiers, () -> Messages.localized("dynamics.field.name", this));
        }
    }
}

