/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.test.api.dynamic;

import de.tum.in.test.api.dynamic.Check;
import de.tum.in.test.api.dynamic.Checkable;
import de.tum.in.test.api.dynamic.DynamicClass;
import de.tum.in.test.api.dynamic.DynamicMethod;
import de.tum.in.test.api.localization.Messages;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Objects;
import org.apiguardian.api.API;

@API(status=API.Status.MAINTAINED)
public class DynamicConstructor<T>
implements Checkable {
    private final DynamicClass<T> owner;
    private final DynamicClass<?>[] parameters;
    private Constructor<T> constructor;

    public DynamicConstructor(DynamicClass<T> dClass, Object ... dynamicableParams) {
        this.owner = Objects.requireNonNull(dClass);
        this.parameters = DynamicClass.toDynamic(Objects.requireNonNull(dynamicableParams));
    }

    public Constructor<T> toConstructor() {
        if (this.constructor == null) {
            try {
                this.constructor = this.owner.toClass().getDeclaredConstructor(DynamicClass.resolveAll(this.parameters));
                this.constructor.trySetAccessible();
            }
            catch (NoSuchMethodException e) {
                throw Messages.localizedFailure(e, "dynamics.constructor.not_found", this.owner, DynamicMethod.descParams(this.parameters));
            }
        }
        return this.constructor;
    }

    @Override
    public boolean exists() {
        if (this.constructor == null) {
            try {
                this.constructor = this.owner.toClass().getDeclaredConstructor(DynamicClass.resolveAll(this.parameters));
                this.constructor.trySetAccessible();
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    public T newInstance(Object ... params) {
        try {
            return this.toConstructor().newInstance(params);
        }
        catch (InstantiationException e) {
            throw Messages.localizedFailure(e, "dynamics.constructor.abstract", this.owner);
        }
        catch (IllegalAccessException e) {
            throw Messages.localizedFailure(e, "dynamics.constructor.access", this);
        }
        catch (IllegalArgumentException e) {
            throw Messages.localizedFailure(e, "dynamics.constructor.arguments", this, DynamicMethod.descArgs(params));
        }
        catch (InvocationTargetException e) {
            return (T)DynamicClass.rethrowUnchecked(e.getCause());
        }
    }

    public String toString() {
        return this.owner.toString() + DynamicMethod.descParams(this.parameters);
    }

    @Override
    public void check(Check ... checks) {
        this.toConstructor();
        int modifiers = this.toConstructor().getModifiers();
        for (Check check : checks) {
            check.checkModifiers(modifiers, () -> Messages.localized("dynamics.constructor.name", this));
        }
    }
}

