/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.test.api.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;

class ClassMemberAccessor {
    private ClassMemberAccessor() {
    }

    static Method getMethod(Class<?> clazz, String methodName, boolean findNonPublic, Class<?>[] parameterTypes) throws NoSuchMethodException {
        if (findNonPublic) {
            return ClassMemberAccessor.getNonPublicMethod(clazz, methodName, parameterTypes);
        }
        try {
            return clazz.getMethod(methodName, parameterTypes);
        }
        catch (NoSuchMethodException nsme) {
            return clazz.getDeclaredMethod(methodName, parameterTypes);
        }
    }

    private static Method getNonPublicMethod(Class<?> declaringClass, String methodName, Class<?>[] parameterTypes) throws NoSuchMethodException {
        return (Method)ClassMemberAccessor.getClassHierarchy(declaringClass).flatMap(c -> {
            try {
                return ClassMemberAccessor.getInheritedMethod(declaringClass, c, methodName, parameterTypes).stream();
            }
            catch (NoSuchMethodException nsme) {
                return Stream.empty();
            }
        }).findFirst().orElseThrow(() -> new NoSuchMethodException(methodName));
    }

    private static Optional<Method> getInheritedMethod(Class<?> targetClass, Class<?> declaringClass, String methodName, Class<?>[] parameterTypes) throws NoSuchMethodException {
        Method method = declaringClass.getDeclaredMethod(methodName, parameterTypes);
        if (ClassMemberAccessor.isInheritable(targetClass, declaringClass, method.getModifiers(), true)) {
            return Optional.of(method);
        }
        return Optional.empty();
    }

    static Field getField(Class<?> clazz, String fieldName, boolean findNonPublic) throws NoSuchFieldException {
        if (findNonPublic) {
            return ClassMemberAccessor.getNonPublicField(clazz, fieldName);
        }
        try {
            return clazz.getField(fieldName);
        }
        catch (NoSuchFieldException nsfe) {
            return clazz.getDeclaredField(fieldName);
        }
    }

    private static Field getNonPublicField(Class<?> declaringClass, String fieldName) throws NoSuchFieldException {
        return (Field)ClassMemberAccessor.getClassHierarchy(declaringClass).flatMap(c -> {
            try {
                return ClassMemberAccessor.getInheritedField(declaringClass, c, fieldName).stream();
            }
            catch (NoSuchFieldException nsfe) {
                return Stream.empty();
            }
        }).findFirst().orElseThrow(() -> new NoSuchFieldException(fieldName));
    }

    private static Optional<Field> getInheritedField(Class<?> targetClass, Class<?> declaringClass, String fieldName) throws NoSuchFieldException {
        Field field = declaringClass.getDeclaredField(fieldName);
        if (ClassMemberAccessor.isInheritable(targetClass, declaringClass, field.getModifiers(), false)) {
            return Optional.of(field);
        }
        return Optional.empty();
    }

    private static Stream<Class<?>> getClassHierarchy(Class<?> clazz) {
        Stream<Class> directSuperclasses = Stream.concat(Stream.of(clazz.getSuperclass()), Arrays.stream(clazz.getInterfaces())).filter(Objects::nonNull);
        return Stream.concat(Stream.of(clazz), directSuperclasses.flatMap(ClassMemberAccessor::getClassHierarchy));
    }

    private static boolean isInheritable(Class<?> targetClass, Class<?> declaredInClass, int modifier, boolean isMethod) {
        if (targetClass.equals(declaredInClass)) {
            return true;
        }
        if (isMethod && declaredInClass.isInterface() && Modifier.isStatic(modifier)) {
            return false;
        }
        boolean isInheritable = Modifier.isProtected(modifier) || Modifier.isPublic(modifier);
        boolean isInheritableInPackage = !Modifier.isPrivate(modifier) && targetClass.getPackage().equals(declaredInClass.getPackage());
        return isInheritable || isInheritableInPackage;
    }
}

