/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.test.api.internal.sanitization;

import de.tum.in.test.api.internal.sanitization.SanitizationException;
import de.tum.in.test.api.internal.sanitization.ThrowableCreator;
import de.tum.in.test.api.internal.sanitization.ThrowableSanitizer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.platform.commons.support.ReflectionSupport;

final class ThrowableUtils {
    static final String MESSAGE = "message";
    static final String CAUSE = "cause";
    static final String STACK_TRACE = "stackTrace";
    static final String SUPPRESSED = "suppressed";
    static final Set<String> IGNORE_PROPERTIES = Set.of("class", "toString", "hashCode", "fillInStackTrace", "localizedMessage");
    static final Set<String> THROWABLE_PROPERTIES = Stream.concat(IGNORE_PROPERTIES.stream(), Stream.of("message", "stackTrace", "cause", "suppressed")).collect(Collectors.toUnmodifiableSet());
    static final BiFunction<String, Object, Object> PROPERTY_SANITIZER = (name, value) -> {
        if (value == null) {
            return value;
        }
        if (value instanceof Throwable) {
            return ThrowableSanitizer.sanitize((Throwable)value);
        }
        if (value instanceof Throwable[]) {
            return Arrays.stream((Throwable[])value).map(ThrowableSanitizer::sanitize).toArray(Throwable[]::new);
        }
        return value;
    };
    private static final Comparator<Map.Entry<String, Method>> ORDER_PROPERTIES_BY_RELEVANCE = Map.Entry.comparingByKey((firstProperty, secondProperty) -> {
        boolean firstIsLessImportant = THROWABLE_PROPERTIES.contains(firstProperty);
        boolean secondIsLessImportant = THROWABLE_PROPERTIES.contains(secondProperty);
        if (firstIsLessImportant && !secondIsLessImportant) {
            return 1;
        }
        if (secondIsLessImportant && !firstIsLessImportant) {
            return -1;
        }
        return firstProperty.compareTo((String)secondProperty);
    });

    private ThrowableUtils() {
    }

    static ThrowableCreator getThrowableCreatorFor(Class<? extends Throwable> type) {
        Constructor<? extends Throwable> preferredConstructor = ThrowableUtils.findPreferredConstructor(type);
        return ThrowableUtils.getThrowableCreatorFor(type, preferredConstructor);
    }

    static ThrowableCreator getThrowableCreatorFor(Class<? extends Throwable> type, Constructor<? extends Throwable> constructor) {
        Set<Map.Entry<String, Method>> propertiesWithMethods = ThrowableUtils.getRelevantPropertiesWithMethods(type, IGNORE_PROPERTIES);
        return info -> {
            Map<String, Object> originalProperties = info.toPropertyMap();
            Map<Class<?>, List<Object>> originalPropertyValuesByType = ThrowableUtils.getValuesByPropertyType(propertiesWithMethods.stream().sorted(ORDER_PROPERTIES_BY_RELEVANCE), originalProperties);
            Object[] argumentsForCopy = ThrowableUtils.provideArguments(constructor, originalPropertyValuesByType);
            try {
                return (Throwable)constructor.newInstance(argumentsForCopy);
            }
            catch (InvocationTargetException e) {
                throw new SanitizationException(type, e.getCause());
            }
            catch (Exception e) {
                throw new SanitizationException(type, (Throwable)e);
            }
        };
    }

    static <T extends Throwable> Constructor<T> findPreferredConstructor(Class<T> type) {
        Constructor<?>[] allConstructors = type.getConstructors();
        if (allConstructors.length == 0) {
            return null;
        }
        Map<Class, Long> classPropertyTypeCount = ThrowableUtils.getRelevantPropertiesWithMethods(type, IGNORE_PROPERTIES).stream().collect(Collectors.groupingBy(property -> ((Method)property.getValue()).getReturnType(), Collectors.counting()));
        return Stream.of(allConstructors).filter(constructor -> ThrowableUtils.isSatisfiableByProperties(constructor, classPropertyTypeCount)).sorted(ThrowableUtils.getConstructorPreferenceOrder()).findFirst().orElse(allConstructors[0]);
    }

    static boolean isSatisfiableByProperties(Constructor<?> constructor, Map<? extends Class<?>, Long> propertyTypeCount) {
        Map parameterTypeCount = Stream.of(constructor.getParameterTypes()).collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
        return parameterTypeCount.entrySet().stream().mapToLong(e -> propertyTypeCount.getOrDefault(e.getKey(), 0L) - (Long)e.getValue()).min().orElse(0L) >= 0L;
    }

    static Comparator<Constructor<?>> getConstructorPreferenceOrder() {
        return Comparator.comparingInt(Constructor::getParameterCount).thenComparingLong(x -> Stream.of(x.getParameterTypes()).filter(String.class::equals).count()).reversed();
    }

    static Set<Map.Entry<String, Method>> getPropertiesWithMethods(Class<?> type) {
        return ThrowableUtils.getRelevantPropertiesWithMethods(type, Set.of());
    }

    static Set<Map.Entry<String, Method>> getRelevantPropertiesWithMethods(Class<?> type, Set<String> namesToIgnore) {
        return Stream.of(type.getMethods()).map(method -> {
            String propertyName = ThrowableUtils.extractProperty(method);
            if (propertyName == null || namesToIgnore.contains(propertyName)) {
                return null;
            }
            return Map.entry(propertyName, method);
        }).filter(Objects::nonNull).collect(Collectors.toUnmodifiableSet());
    }

    static Map<String, Object> retrievePropertyValues(Object instance, Set<Map.Entry<String, Method>> properties) {
        return properties.stream().collect(Collectors.groupingBy(Map.Entry::getKey, Collectors.mapping(property -> ReflectionSupport.invokeMethod((Method)((Method)property.getValue()), (Object)instance, (Object[])new Object[0]), Collectors.reducing(null, (a, b) -> a != null ? a : b))));
    }

    static Map<Class<?>, List<Object>> getValuesByPropertyType(Stream<Map.Entry<String, Method>> propertiesWithMethods, Map<String, Object> concretePropertyValues) {
        return propertiesWithMethods.collect(Collectors.groupingBy(property -> ((Method)property.getValue()).getReturnType(), Collectors.mapping(property -> concretePropertyValues.get(property.getKey()), Collectors.toList())));
    }

    static String extractProperty(Method method) {
        if (method.getParameterCount() > 0) {
            return null;
        }
        if (method.isBridge() || method.isSynthetic()) {
            return null;
        }
        if (Void.TYPE.equals(method.getReturnType())) {
            return null;
        }
        String name = method.getName();
        if (name.startsWith("get") && name.length() > 3 && Character.isUpperCase(name.charAt(3))) {
            StringBuilder propertyName = new StringBuilder(name);
            propertyName.delete(0, 3);
            propertyName.setCharAt(0, Character.toLowerCase(propertyName.charAt(0)));
            name = propertyName.toString();
        }
        return name;
    }

    static Object[] provideArguments(Constructor<?> constructor, Map<Class<?>, List<Object>> valueSource) {
        HashSet used = new HashSet();
        return Stream.of(constructor.getParameterTypes()).map(argType -> {
            List valueList = (List)valueSource.get(argType);
            if (valueList != null) {
                for (Object value : valueList) {
                    if (!used.add(value)) continue;
                    return value;
                }
            }
            return null;
        }).toArray();
    }
}

