/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.test.api.structural.testutils;

import de.tum.in.test.api.localization.Messages;
import de.tum.in.test.api.structural.testutils.ScanResult;
import de.tum.in.test.api.structural.testutils.ScanResultType;
import info.debatty.java.stringsimilarity.Damerau;
import info.debatty.java.stringsimilarity.JaroWinkler;
import info.debatty.java.stringsimilarity.NormalizedLevenshtein;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

@API(status=API.Status.STABLE)
public class ClassNameScanner {
    private static final Logger LOG = LoggerFactory.getLogger(ClassNameScanner.class);
    private static final JaroWinkler JARO_WINKLER = new JaroWinkler();
    private static final NormalizedLevenshtein NORMALIZED_LEVENSHTEIN = new NormalizedLevenshtein();
    private static final Damerau DAMERAU_LEVENSHTEIN = new Damerau();
    private final String expectedClassName;
    private final String expectedPackageName;
    private final Map<String, List<String>> observedClasses = new HashMap<String, List<String>>();
    private final ScanResult scanResult;
    private static String pomXmlPath = "pom.xml";
    private static String buildGradlePath = "build.gradle";
    private static final Pattern gradleSourceDirPattern = Pattern.compile("def\\s+assignmentSrcDir\\s*=\\s*\"(?<dir>.+)\"");

    public ClassNameScanner(String expectedClassName, String expectedPackageName) {
        this.expectedClassName = expectedClassName;
        this.expectedPackageName = expectedPackageName;
        this.findObservedClassesInProject();
        this.scanResult = this.computeScanResult();
    }

    public ScanResult getScanResult() {
        return this.scanResult;
    }

    private ScanResult computeScanResult() {
        if (this.observedClasses.containsKey(this.expectedClassName)) {
            List<String> observedPackageNames = this.observedClasses.get(this.expectedClassName);
            return this.createScanResult(this.getScanResultTypeClassFound(observedPackageNames), this.expectedClassName, observedPackageNames.toString());
        }
        for (Map.Entry<String, List<String>> observedClass : this.observedClasses.entrySet()) {
            boolean classCorrectlyPlaced;
            String foundObservedClassName = observedClass.getKey();
            List<String> observedPackageNames = observedClass.getValue();
            String foundObservedPackageNames = observedPackageNames.toString();
            boolean classPresentMultiple = observedPackageNames.size() > 1;
            boolean bl = classCorrectlyPlaced = !classPresentMultiple && observedPackageNames.contains(this.expectedPackageName);
            if (foundObservedClassName.equalsIgnoreCase(this.expectedClassName)) {
                return this.createScanResult(foundObservedClassName, foundObservedPackageNames, classPresentMultiple, classCorrectlyPlaced, ScanResultType.WRONG_CASE_MULTIPLE, ScanResultType.WRONG_CASE_CORRECT_PLACE, ScanResultType.WRONG_CASE_MISPLACED);
            }
            if (!ClassNameScanner.isMisspelledWithHighProbability(this.expectedClassName, foundObservedClassName)) continue;
            return this.createScanResult(foundObservedClassName, foundObservedPackageNames, classPresentMultiple, classCorrectlyPlaced, ScanResultType.TYPOS_MULTIPLE, ScanResultType.TYPOS_CORRECT_PLACE, ScanResultType.TYPOS_MISPLACED);
        }
        return this.createScanResult(ScanResultType.NOTFOUND, this.expectedClassName, null);
    }

    private ScanResult createScanResult(String foundObservedClassName, String foundObservedPackageName, boolean classPresentMultiple, boolean classCorrectlyPlaced, ScanResultType multipleTimes, ScanResultType correctPlace, ScanResultType misplaced) {
        ScanResultType scanResultType = classPresentMultiple ? multipleTimes : (classCorrectlyPlaced ? correctPlace : misplaced);
        return this.createScanResult(scanResultType, foundObservedClassName, foundObservedPackageName);
    }

    private ScanResultType getScanResultTypeClassFound(List<String> observedPackageNames) {
        boolean classIsCorrectlyPlaced;
        boolean classIsPresentMultipleTimes = observedPackageNames.size() > 1;
        boolean bl = classIsCorrectlyPlaced = !classIsPresentMultipleTimes && observedPackageNames.contains(this.expectedPackageName);
        ScanResultType scanResultType = classIsPresentMultipleTimes ? ScanResultType.CORRECT_NAME_MULTIPLE : (classIsCorrectlyPlaced ? ScanResultType.CORRECT_NAME_CORRECT_PLACE : ScanResultType.CORRECT_NAME_MISPLACED);
        return scanResultType;
    }

    private ScanResult createScanResult(ScanResultType scanResultType, String foundClassName, String foundPackageName) {
        String scanResultMessage = this.createScanResultMessage(scanResultType, foundClassName, foundPackageName);
        return new ScanResult(scanResultType, scanResultMessage);
    }

    private String createScanResultMessage(ScanResultType scanResultType, String foundClassName, String foundPackageName) {
        switch (scanResultType) {
            case CORRECT_NAME_CORRECT_PLACE: {
                return Messages.localized("structural.scan.correctNameCorrectPlace", foundClassName);
            }
            case CORRECT_NAME_MISPLACED: {
                return Messages.localized("structural.scan.correctNameMisplaced", foundClassName, foundPackageName);
            }
            case CORRECT_NAME_MULTIPLE: {
                return Messages.localized("structural.scan.correctNameMultiple", foundClassName, foundPackageName);
            }
            case WRONG_CASE_CORRECT_PLACE: {
                return Messages.localized("structural.scan.wrongCaseCorrectPlace", this.expectedClassName, foundClassName);
            }
            case WRONG_CASE_MISPLACED: {
                return Messages.localized("structural.scan.wrongCaseMisplaced", this.expectedClassName, this.expectedPackageName, foundClassName, foundPackageName);
            }
            case WRONG_CASE_MULTIPLE: {
                return Messages.localized("structural.scan.wrongCaseMultiple", this.expectedClassName, this.expectedPackageName, foundClassName, foundPackageName);
            }
            case TYPOS_CORRECT_PLACE: {
                return Messages.localized("structural.scan.typosCorrectPlace", this.expectedClassName, foundClassName);
            }
            case TYPOS_MISPLACED: {
                return Messages.localized("structural.scan.typosMisplaced", this.expectedClassName, this.expectedPackageName, foundClassName, foundPackageName);
            }
            case TYPOS_MULTIPLE: {
                return Messages.localized("structural.scan.typosMultiple", this.expectedClassName, this.expectedPackageName, foundClassName, this.observedClasses.get(foundClassName).toString());
            }
            case NOTFOUND: {
                return Messages.localized("structural.scan.notFound", this.expectedClassName, this.expectedPackageName);
            }
        }
        return Messages.localized("structural.scan.default", new Object[0]);
    }

    private void findObservedClassesInProject() {
        String assignmentFolderName;
        if (ClassNameScanner.isMavenProject()) {
            assignmentFolderName = ClassNameScanner.getAssignmentFolderNameForMavenProject();
        } else if (ClassNameScanner.isGradleProject()) {
            assignmentFolderName = ClassNameScanner.getAssignmentFolderNameForGradleProject();
        } else {
            LOG.error("Could not find any build file. Contact your instructor.");
            return;
        }
        if (assignmentFolderName == null) {
            LOG.error("Could not retrieve source directory from project file. Contact your instructor.");
            return;
        }
        this.walkProjectFileStructure(assignmentFolderName, new File(assignmentFolderName), this.observedClasses);
    }

    private static boolean isMavenProject() {
        if (pomXmlPath == null) {
            return false;
        }
        File projectFile = new File(pomXmlPath);
        return projectFile.exists() && !projectFile.isDirectory();
    }

    private static boolean isGradleProject() {
        if (buildGradlePath == null) {
            return false;
        }
        File projectFile = new File(buildGradlePath);
        return projectFile.exists() && !projectFile.isDirectory();
    }

    private static String getAssignmentFolderNameForMavenProject() {
        try {
            File pomFile = new File(pomXmlPath);
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            documentBuilderFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document pomXmlDocument = documentBuilder.parse(pomFile);
            NodeList buildNodes = pomXmlDocument.getElementsByTagName("build");
            for (int i = 0; i < buildNodes.getLength(); ++i) {
                Node buildNode = buildNodes.item(i);
                if (buildNode.getNodeType() != 1) continue;
                Element buildNodeElement = (Element)buildNode;
                String sourceDirectoryPropertyValue = buildNodeElement.getElementsByTagName("sourceDirectory").item(0).getTextContent();
                return sourceDirectoryPropertyValue.substring(sourceDirectoryPropertyValue.indexOf("}") + 2);
            }
        }
        catch (IOException | NullPointerException | ParserConfigurationException | SAXException e) {
            LOG.error("Could not retrieve the source directory from the pom.xml file. Contact your instructor.", (Throwable)e);
        }
        return null;
    }

    private static String getAssignmentFolderNameForGradleProject() {
        try {
            Path path = Path.of(buildGradlePath, new String[0]);
            String fileContent = Files.readString(path);
            Matcher matcher = gradleSourceDirPattern.matcher(fileContent);
            if (matcher.find()) {
                return matcher.group("dir");
            }
            return null;
        }
        catch (IOException | NullPointerException e) {
            LOG.error("Could not retrieve the source directory from the build.gradle file. Contact your instructor.", (Throwable)e);
            return null;
        }
    }

    private void walkProjectFileStructure(String assignmentFolderName, File node, Map<String, List<String>> foundClasses) {
        String[] subNodes;
        String fileName = node.getName();
        if (fileName.endsWith(".java") || fileName.endsWith(".kt")) {
            String[] fileNameComponents = fileName.split("\\.");
            String className = fileNameComponents[fileNameComponents.length - 2];
            Path packagePath = Path.of(assignmentFolderName, new String[0]).relativize(Path.of(node.getPath(), new String[0]).getParent());
            String packageName = StreamSupport.stream(packagePath.spliterator(), false).map(Object::toString).collect(Collectors.joining("."));
            if (foundClasses.containsKey(className)) {
                foundClasses.get(className).add(packageName);
            } else {
                foundClasses.put(className, new ArrayList<String>(List.of(packageName)));
            }
        }
        if (node.isDirectory() && (subNodes = node.list()) != null && subNodes.length > 0) {
            for (String currentSubNode : subNodes) {
                this.walkProjectFileStructure(assignmentFolderName, new File(node, currentSubNode), foundClasses);
            }
        }
    }

    public static String getPomXmlPath() {
        return pomXmlPath;
    }

    public static void setPomXmlPath(String path) {
        pomXmlPath = path;
    }

    public static String getBuildGradlePath() {
        return buildGradlePath;
    }

    public static void setBuildGradlePath(String path) {
        buildGradlePath = path;
    }

    static boolean isMisspelledWithHighProbability(String a, String b) {
        int lengthDifferenceAbs = Math.abs(a.length() - b.length());
        if (lengthDifferenceAbs > 2) {
            return false;
        }
        double distance = DAMERAU_LEVENSHTEIN.distance(a, b);
        if (distance <= 1.0 && Math.max(a.length(), b.length()) > 2) {
            return true;
        }
        if (distance > 2.0) {
            return false;
        }
        return JARO_WINKLER.similarity(a, b) > 0.9 || NORMALIZED_LEVENSHTEIN.similarity(a, b) > 0.9;
    }
}

