/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.test.api.jqwik;

import de.tum.in.test.api.internal.IOExtensionUtils;
import de.tum.in.test.api.jqwik.JqwikContext;
import java.util.Set;
import java.util.function.Predicate;
import net.jqwik.api.Arbitraries;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.lifecycle.AroundPropertyHook;
import net.jqwik.api.lifecycle.PropertyExecutionResult;
import net.jqwik.api.lifecycle.PropertyExecutor;
import net.jqwik.api.lifecycle.PropertyLifecycleContext;
import net.jqwik.api.providers.ArbitraryProvider;
import net.jqwik.api.providers.TypeUsage;
import net.jqwik.engine.providers.RegisteredArbitraryProviders;
import org.apiguardian.api.API;

@API(status=API.Status.INTERNAL)
public final class JqwikIOExtension
implements AroundPropertyHook {
    public int aroundPropertyProximity() {
        return 20;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertyExecutionResult aroundProperty(PropertyLifecycleContext context, PropertyExecutor property) throws Throwable {
        IOExtensionUtils ioExtensionUtils = new IOExtensionUtils(JqwikContext.of(context));
        ioExtensionUtils.beforeTestExecution();
        ControllerProvider controllerProvider = null;
        if (ioExtensionUtils.providesController()) {
            controllerProvider = new ControllerProvider(ioExtensionUtils::canProvideControllerFor, ioExtensionUtils.getControllerInstance());
            RegisteredArbitraryProviders.register((ArbitraryProvider)controllerProvider);
        }
        try {
            PropertyExecutionResult propertyExecutionResult = property.execute();
            return propertyExecutionResult;
        }
        finally {
            if (ioExtensionUtils.providesController()) {
                RegisteredArbitraryProviders.unregister(controllerProvider);
            }
            ioExtensionUtils.afterTestExecution();
        }
    }

    private static class ControllerProvider
    implements ArbitraryProvider {
        private final Predicate<Class<?>> canProvideControllerFor;
        private final Object controllerInstance;

        private ControllerProvider(Predicate<Class<?>> canProvideControllerFor, Object controllerInstance) {
            this.canProvideControllerFor = canProvideControllerFor;
            this.controllerInstance = controllerInstance;
        }

        public boolean canProvideFor(TypeUsage targetType) {
            return this.canProvideControllerFor.test(targetType.getRawType());
        }

        public Set<Arbitrary<?>> provideFor(TypeUsage targetType, ArbitraryProvider.SubtypeProvider subtypeProvider) {
            return Set.of(Arbitraries.just((Object)this.controllerInstance));
        }
    }
}

