/*
 * Decompiled with CFR 0.152.
 */
package de.tum.ei.lkn.eces.webgraphgui.color;

import de.tum.ei.lkn.eces.core.Controller;
import de.tum.ei.lkn.eces.core.RootSystem;
import de.tum.ei.lkn.eces.core.annotations.ComponentBelongsTo;
import de.tum.ei.lkn.eces.graph.Edge;
import de.tum.ei.lkn.eces.webgraphgui.color.ColoringScheme;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

@ComponentBelongsTo(system=ColoringSystem.class)
public class ColoringSystem
extends RootSystem {
    private HashMap<String, ColoringScheme> regColoringMap = new HashMap();

    public ColoringSystem(Controller controller) {
        super(controller);
    }

    public boolean addColoringScheme(ColoringScheme newSch, String name) {
        if (!this.regColoringMap.containsValue(newSch) && !this.regColoringMap.containsKey(name)) {
            this.regColoringMap.put(name, newSch);
            return false;
        }
        return true;
    }

    public String[] getColoringSchemeList() {
        String[] returnStringList = new String[this.regColoringMap.size()];
        int i = 0;
        Iterator<String> iterator = this.regColoringMap.keySet().iterator();
        while (iterator.hasNext()) {
            String name;
            returnStringList[i] = name = iterator.next();
            ++i;
        }
        return returnStringList;
    }

    public String getColor(String schemeName, Edge edge) {
        for (Map.Entry<String, ColoringScheme> entry : this.regColoringMap.entrySet()) {
            String entryName = entry.getKey();
            ColoringScheme entryScheme = entry.getValue();
            if (!entryName.equals(schemeName)) continue;
            return entryScheme.getColor(edge);
        }
        return null;
    }

    public boolean schemeIsPolling(String schemeName, Edge edge) {
        for (Map.Entry<String, ColoringScheme> entry : this.regColoringMap.entrySet()) {
            String entryName = entry.getKey();
            ColoringScheme entryScheme = entry.getValue();
            if (!entryName.equals(schemeName)) continue;
            return entryScheme.isPolling(edge);
        }
        return false;
    }
}

