/*
 * Decompiled with CFR 0.152.
 */
package de.tum.ei.lkn.eces.webgraphgui;

import de.tum.ei.lkn.eces.core.Component;
import de.tum.ei.lkn.eces.core.Controller;
import de.tum.ei.lkn.eces.core.Entity;
import de.tum.ei.lkn.eces.core.Mapper;
import de.tum.ei.lkn.eces.core.MapperSpace;
import de.tum.ei.lkn.eces.dnm.NCRequestData;
import de.tum.ei.lkn.eces.dnm.mappers.NCRequestDataMapper;
import de.tum.ei.lkn.eces.dnm.proxies.DetServProxy;
import de.tum.ei.lkn.eces.graph.Edge;
import de.tum.ei.lkn.eces.graph.Graph;
import de.tum.ei.lkn.eces.graph.Node;
import de.tum.ei.lkn.eces.graph.mappers.EdgeMapper;
import de.tum.ei.lkn.eces.graph.mappers.NodeMapper;
import de.tum.ei.lkn.eces.network.Host;
import de.tum.ei.lkn.eces.network.NetworkNode;
import de.tum.ei.lkn.eces.network.ToNetwork;
import de.tum.ei.lkn.eces.network.mappers.NetworkNodeMapper;
import de.tum.ei.lkn.eces.network.mappers.ToNetworkMapper;
import de.tum.ei.lkn.eces.network.util.NetworkInterface;
import de.tum.ei.lkn.eces.routing.DeleteRequest;
import de.tum.ei.lkn.eces.routing.SelectedRoutingAlgorithm;
import de.tum.ei.lkn.eces.routing.algorithms.RoutingAlgorithm;
import de.tum.ei.lkn.eces.routing.algorithms.mcsp.astarprune.AStarPruneAlgorithm;
import de.tum.ei.lkn.eces.routing.mappers.DeleteRequestMapper;
import de.tum.ei.lkn.eces.routing.mappers.RequestMapper;
import de.tum.ei.lkn.eces.routing.mappers.RequestNameMapper;
import de.tum.ei.lkn.eces.routing.mappers.SelectedRoutingAlgorithmMapper;
import de.tum.ei.lkn.eces.routing.mappers.UnicastRequestMapper;
import de.tum.ei.lkn.eces.routing.proxies.PathProxy;
import de.tum.ei.lkn.eces.routing.requests.RequestName;
import de.tum.ei.lkn.eces.routing.requests.UnicastRequest;
import de.tum.ei.lkn.eces.webgraphgui.ChannelStateful;
import de.tum.ei.lkn.eces.webgraphgui.MessageConverter;
import de.tum.ei.lkn.eces.webgraphgui.NettyHttpFileHandler;
import de.tum.ei.lkn.eces.webgraphgui.color.ColoringSystem;
import de.uni_kl.cs.discodnc.curves.CurvePwAffine;
import de.uni_kl.cs.discodnc.numbers.Num;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.ContinuationWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.log4j.Logger;
import org.json.JSONObject;

@ChannelHandler.Sharable
public class NettyInboundHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger logger = Logger.getLogger(NettyInboundHandler.class);
    protected NettyHttpFileHandler httpFileHandler = new NettyHttpFileHandler();
    protected WebSocketServerHandshaker handshaker;
    private StringBuilder frameBuffer = null;
    private Set<ChannelStateful> allChannels = new CopyOnWriteArraySet<ChannelStateful>();
    private ColoringSystem coloringSys;
    private Controller mController;
    private RequestMapper requestMapper;
    Mapper<Node> nodeMapper;
    Mapper<Edge> edgeMapper;
    Mapper<DeleteRequest> deleteRequestMapper;
    protected NCRequestDataMapper ncRequestDataMapper;
    protected SelectedRoutingAlgorithmMapper selectedRoutingAlgorithmMapper;
    protected UnicastRequestMapper unicastRequestMapper;
    protected RequestNameMapper requestNameMapper;
    Set<Graph> registeredGraphsList = new CopyOnWriteArraySet<Graph>();

    public NettyInboundHandler(Controller controller) {
        this(controller, null);
    }

    public NettyInboundHandler(Controller controller, ColoringSystem passedColSys) {
        this.coloringSys = passedColSys;
        this.mController = controller;
        this.nodeMapper = new NodeMapper(this.mController);
        this.edgeMapper = new EdgeMapper(this.mController);
        this.requestMapper = new RequestMapper(this.mController);
        this.deleteRequestMapper = new DeleteRequestMapper(this.mController);
        this.unicastRequestMapper = new UnicastRequestMapper(this.mController);
        this.ncRequestDataMapper = new NCRequestDataMapper(this.mController);
        this.requestNameMapper = new RequestNameMapper(this.mController);
        this.selectedRoutingAlgorithmMapper = new SelectedRoutingAlgorithmMapper(this.mController);
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        ChannelStateful newChannel = new ChannelStateful(ctx.channel());
        this.allChannels.add(newChannel);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof FullHttpRequest) {
            this.handleHttpRequest(ctx, (FullHttpRequest)msg);
        } else if (msg instanceof WebSocketFrame) {
            this.handleWebSocketFrame(ctx, (WebSocketFrame)msg);
        }
    }

    protected boolean handleREST(ChannelHandlerContext ctx, FullHttpRequest req) {
        return false;
    }

    protected void handleHttpRequest(ChannelHandlerContext ctx, FullHttpRequest req) throws Exception {
        if (!req.getDecoderResult().isSuccess()) {
            this.httpFileHandler.sendError(ctx, HttpResponseStatus.BAD_REQUEST);
            return;
        }
        if (req.getMethod() == HttpMethod.POST) {
            this.httpFileHandler.sendError(ctx, HttpResponseStatus.FORBIDDEN);
            return;
        }
        if (req.getMethod() != HttpMethod.GET) {
            this.httpFileHandler.sendError(ctx, HttpResponseStatus.FORBIDDEN);
            return;
        }
        if ("/".equals(req.getUri())) {
            this.httpFileHandler.sendRedirect(ctx, "/index.html");
            return;
        }
        String upgradeHeader = req.headers().get("Upgrade");
        if (upgradeHeader != null && "websocket".equalsIgnoreCase(upgradeHeader)) {
            String url = "ws://" + req.headers().get("Host") + "/websocket";
            WebSocketServerHandshakerFactory wsFactory = new WebSocketServerHandshakerFactory(url, null, false);
            this.handshaker = wsFactory.newHandshaker((HttpRequest)req);
            if (this.handshaker == null) {
                WebSocketServerHandshakerFactory.sendUnsupportedVersionResponse((Channel)ctx.channel());
            } else {
                this.handshaker.handshake(ctx.channel(), req);
            }
        } else {
            boolean handled = this.handleREST(ctx, req);
            if (!handled) {
                this.httpFileHandler.sendFile(ctx, req);
            }
        }
    }

    protected void handleMessageCompleted(ChannelHandlerContext ctx, String frameText) {
        JSONObject messageObject = new JSONObject(frameText);
        logger.debug((Object)("Message Recieved! frameText: " + frameText));
        if (messageObject.getString("type").equals("connected")) {
            this.sendInitial(ctx);
        } else if (messageObject.getString("type").equals("elementClicked")) {
            for (ChannelStateful channelStateful : this.allChannels) {
                if (channelStateful.getChannel() != ctx.channel()) continue;
                channelStateful.setActiveEntity(messageObject.getLong("data"));
                this.sendCurrentEntityObject(channelStateful);
            }
        } else if (messageObject.getString("type").equals("activeGraph")) {
            for (ChannelStateful channelStateful : this.allChannels) {
                if (channelStateful.getChannel() != ctx.channel()) continue;
                Long graphEntityId = messageObject.getLong("currentGraph");
                channelStateful.setActiveGraph(graphEntityId);
                for (Graph graph : this.registeredGraphsList) {
                    Entity graphEntity = graph.getEntity();
                    if (graphEntity.getId() != graphEntityId.longValue()) continue;
                    String graphString = this.nodeMapper.createJSONObject(graphEntity).toString();
                    channelStateful.getChannel().writeAndFlush((Object)new TextWebSocketFrame(graphString));
                    logger.debug((Object)("Sent GraphEntity: " + graphString));
                    return;
                }
            }
        } else if (messageObject.getString("type").equals("getColors")) {
            for (ChannelStateful channelStateful : this.allChannels) {
                if (channelStateful.getChannel() != ctx.channel()) continue;
                channelStateful.setPolling(false);
                String schemeName = messageObject.getString("schemeName");
                Long activeGraphEntityID = messageObject.getLong("activeGraphEntityID");
                channelStateful.setActiveColoring(schemeName);
                this.sendAllColors(channelStateful, activeGraphEntityID);
                Graph graph = null;
                for (Graph value : this.registeredGraphsList) {
                    if (value.getId() != channelStateful.getActiveGraph()) continue;
                    graph = value;
                }
                if (!this.coloringSys.schemeIsPolling(schemeName, (Edge)graph.getEdges().iterator().next())) continue;
                channelStateful.setPolling(true);
                this.startColorDaemon(channelStateful, activeGraphEntityID);
            }
        } else if (messageObject.get("type").equals("removeFlow")) {
            Long entityId = Long.valueOf(messageObject.get("entityId").toString());
            this.deleteRequestMapper.attachComponent(this.mController.createEntity(), (Component)new DeleteRequest(entityId));
        } else if (messageObject.get("type").equals("newFlow")) {
            try {
                Long source = Long.valueOf(messageObject.get("source").toString());
                Long destination = Long.valueOf(messageObject.get("destination").toString());
                Double burst = Double.valueOf(messageObject.get("burst").toString());
                Double rate = Double.valueOf(messageObject.get("rate").toString());
                Double deadline = Double.valueOf(messageObject.get("deadline").toString());
                String name = String.valueOf(messageObject.get("name").toString());
                logger.info((Object)String.format("Direct request to add: name=%s source=%d destination=%d burst=%.2fKB rate=%.2fKbps deadline=%.2fms", name, source, destination, burst, rate, deadline));
                Entity entity = this.mController.createEntity();
                Node sourceNode = null;
                Node destNode = null;
                for (Graph graph : this.registeredGraphsList) {
                    for (Node node : graph.getNodes()) {
                        if (node.getEntity().getId() == source.longValue()) {
                            sourceNode = node;
                        }
                        if (node.getEntity().getId() != destination.longValue()) continue;
                        destNode = node;
                    }
                }
                if (sourceNode == null) {
                    logger.error((Object)("Impossible to find a node with entity ID " + source + ". Not creating request!"));
                    return;
                }
                if (destNode == null) {
                    logger.error((Object)("Impossible to find a node with entity ID " + destination + ". Not creating request!"));
                    return;
                }
                if (destNode.getGraph().getEntity().getId() != sourceNode.getGraph().getEntity().getId()) {
                    logger.error((Object)"The two nodes do not belong to the same graph. Not creating request!");
                    return;
                }
                AStarPruneAlgorithm algorithm = new AStarPruneAlgorithm(this.mController, true);
                algorithm.setProxy((PathProxy)new DetServProxy(this.mController));
                MapperSpace mapperSpace = this.mController.startMapperSpace();
                Object object = null;
                try {
                    this.unicastRequestMapper.attachComponent(entity, (Component)new UnicastRequest(sourceNode, destNode));
                    this.ncRequestDataMapper.attachComponent(entity, (Component)new NCRequestData(CurvePwAffine.getFactory().createTokenBucket(rate * 1000.0 / 8.0, burst * 1000.0), Num.getFactory().create(deadline / 1000.0)));
                    this.selectedRoutingAlgorithmMapper.attachComponent(entity, (Component)new SelectedRoutingAlgorithm((RoutingAlgorithm)algorithm));
                    this.requestNameMapper.attachComponent(entity, (Component)new RequestName(name));
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (mapperSpace != null) {
                        if (object != null) {
                            try {
                                mapperSpace.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            mapperSpace.close();
                        }
                    }
                }
            }
            catch (NumberFormatException e) {
                logger.error((Object)("Impossible to add the manually entered flow: requested value is not a number: " + e.getMessage()));
            }
        } else {
            ctx.channel().writeAndFlush((Object)new TextWebSocketFrame("ERROR: following Message could not be processed: " + frameText));
        }
    }

    protected void sendInitial(ChannelHandlerContext ctx) {
        logger.debug((Object)"sendingInitial...");
        for (Graph graph : this.registeredGraphsList) {
            long graphid = graph.getWaitEntity().getId();
            for (Node node : graph.getNodes()) {
                MessageConverter.getNodeMessage(node, graphid, this.getNodeType(node));
                String nodeString = MessageConverter.getNodeMessage(node, graphid, this.getNodeType(node));
                ctx.channel().writeAndFlush((Object)new TextWebSocketFrame(nodeString));
                for (Edge edge : node.getOutgoingConnections()) {
                    String edgestring = MessageConverter.getEdgeMessage(edge, graphid);
                    ctx.channel().writeAndFlush((Object)new TextWebSocketFrame(edgestring));
                }
            }
        }
        if (this.coloringSys != null) {
            String[] coloringSchemes;
            for (String coloringScheme : coloringSchemes = this.coloringSys.getColoringSchemeList()) {
                String schemeString = MessageConverter.getColorSchemeMessage(coloringScheme);
                logger.debug((Object)schemeString);
                ctx.channel().writeAndFlush((Object)new TextWebSocketFrame(schemeString));
            }
        } else {
            String schemeString = MessageConverter.getColorSchemeMessage("No Coloring System Loaded!");
            ctx.channel().writeAndFlush((Object)new TextWebSocketFrame(schemeString));
        }
    }

    protected void sendCurrentEntityObject(ChannelStateful channelStateful) {
        Channel channel = channelStateful.getChannel();
        long currentEntityId = channelStateful.getActiveEntity();
        for (Graph graph : this.registeredGraphsList) {
            String graphString = this.nodeMapper.createJSONObject(graph.getEntity()).toString();
            channel.writeAndFlush((Object)new TextWebSocketFrame(graphString));
            logger.debug((Object)("Sent GraphEntity: " + graphString));
            for (Node node : graph.getNodes()) {
                Entity nodeEntity = node.getWaitEntity();
                if (nodeEntity.getId() == currentEntityId) {
                    String nodestring = this.nodeMapper.createJSONObject(nodeEntity).toString();
                    channel.writeAndFlush((Object)new TextWebSocketFrame(nodestring));
                    logger.debug((Object)("Sent NodeEntity: " + nodestring));
                    return;
                }
                for (Edge edge : node.getOutgoingConnections()) {
                    Entity edgeEntity = edge.getWaitEntity();
                    if (edgeEntity.getId() != currentEntityId) continue;
                    String edgestring = this.edgeMapper.createJSONObject(edgeEntity).toString();
                    channel.writeAndFlush((Object)new TextWebSocketFrame(edgestring));
                    logger.debug((Object)("Sent EdgeEntity: " + edgestring));
                    return;
                }
            }
        }
    }

    protected void sendError(Channel channel, String errorTypeString, String errorMsg) {
        String response = MessageConverter.getErrorMessage(errorTypeString, errorMsg);
        channel.writeAndFlush((Object)new TextWebSocketFrame(response));
    }

    protected void sendAllColors(ChannelStateful channelStateful, long activeGraphId) {
        if (this.coloringSys == null) {
            return;
        }
        logger.trace((Object)"sendingAllColors...");
        for (Graph graph : this.registeredGraphsList) {
            long graphid = graph.getWaitEntity().getId();
            if (graphid != activeGraphId) continue;
            for (Node node : graph.getNodes()) {
                for (Edge edge : node.getOutgoingConnections()) {
                    String colSchemeName = channelStateful.getActiveColoring();
                    String color = this.coloringSys.getColor(colSchemeName, edge);
                    if (color == null) continue;
                    String colorMessage = MessageConverter.getColorMessage(edge, color);
                    channelStateful.getChannel().writeAndFlush((Object)new TextWebSocketFrame(colorMessage));
                }
            }
        }
    }

    public void sendColorOfEdge(Edge edge) {
        if (this.coloringSys == null) {
            return;
        }
        logger.debug((Object)("sendColorOfEdge()... EdgeId=" + edge.getEntity().getId()));
        for (ChannelStateful channelStateful : this.allChannels) {
            String colSchemeName = channelStateful.getActiveColoring();
            String color = this.coloringSys.getColor(colSchemeName, edge);
            if (color == null) continue;
            String colorMessage = MessageConverter.getColorMessage(edge, color);
            channelStateful.getChannel().writeAndFlush((Object)new TextWebSocketFrame(colorMessage));
        }
    }

    public void sendWebsocketFrameToAll(String frameText) {
        if (frameText != null) {
            for (ChannelStateful channelWithActiveEntity : this.allChannels) {
                channelWithActiveEntity.getChannel().writeAndFlush((Object)new TextWebSocketFrame(frameText));
            }
            if (!this.allChannels.isEmpty()) {
                logger.debug((Object)("Broadcasted Webssocketframe: " + frameText));
            }
        }
    }

    protected void handleWebSocketFrame(ChannelHandlerContext ctx, WebSocketFrame frame) {
        if (frame instanceof CloseWebSocketFrame) {
            if (this.frameBuffer != null) {
                this.handleMessageCompleted(ctx, this.frameBuffer.toString());
            }
            this.handshaker.close(ctx.channel(), (CloseWebSocketFrame)frame.retain());
            return;
        }
        if (frame instanceof PingWebSocketFrame) {
            ctx.channel().writeAndFlush((Object)new PongWebSocketFrame(frame.content().retain()));
            return;
        }
        if (frame instanceof PongWebSocketFrame) {
            return;
        }
        if (frame instanceof TextWebSocketFrame) {
            this.frameBuffer = new StringBuilder();
            this.frameBuffer.append(((TextWebSocketFrame)frame).text());
        } else if (frame instanceof ContinuationWebSocketFrame) {
            if (this.frameBuffer != null) {
                this.frameBuffer.append(((ContinuationWebSocketFrame)frame).text());
            }
        } else {
            throw new UnsupportedOperationException(String.format("%s frame types not supported", frame.getClass().getName()));
        }
        if (frame.isFinalFragment()) {
            this.handleMessageCompleted(ctx, this.frameBuffer.toString());
            this.frameBuffer = null;
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        cause.printStackTrace();
        ctx.close();
    }

    public void componentStateNode(Node newNode, String newStatus) {
        Graph tmpGraph = newNode.getGraph();
        if (!this.registeredGraphsList.contains(tmpGraph)) {
            this.registeredGraphsList.add(tmpGraph);
        }
        long graphid = tmpGraph.getWaitEntity().getId();
        String nodeString = MessageConverter.getNodeMessage(newNode, graphid, newStatus, this.getNodeType(newNode));
        this.sendWebsocketFrameToAll(nodeString);
    }

    public void componentStateEdge(Edge newEdge, String newStatus) {
        Graph tmpGraph;
        try {
            tmpGraph = newEdge.getSource().getGraph();
        }
        catch (NullPointerException e) {
            logger.warn((Object)("ERROR: " + e.getMessage()));
            return;
        }
        if (!this.registeredGraphsList.contains(tmpGraph)) {
            this.registeredGraphsList.add(tmpGraph);
        }
        long graphid = tmpGraph.getWaitEntity().getId();
        String edgestring = MessageConverter.getEdgeMessage(newEdge, graphid, newStatus);
        this.sendWebsocketFrameToAll(edgestring);
    }

    public void addGraph(Graph newGraph) {
        if (!this.registeredGraphsList.contains(newGraph)) {
            this.registeredGraphsList.add(newGraph);
        }
    }

    public void updatedActiveEntity(long updatedEntityId) {
        for (ChannelStateful channelStateful : this.allChannels) {
            if (channelStateful.getActiveEntity() != updatedEntityId && channelStateful.getActiveGraph() != updatedEntityId) continue;
            this.sendCurrentEntityObject(channelStateful);
        }
    }

    protected void startColorDaemon(ChannelStateful channelStateful, long activeGraphId) {
        ColorDaemon colorDaemon = new ColorDaemon(channelStateful, activeGraphId);
        colorDaemon.start();
    }

    private String getNodeType(Node node) {
        String type = "switch";
        NetworkNode networkNode = null;
        NetworkNodeMapper networkNodeMapper = new NetworkNodeMapper(this.mController);
        ToNetworkMapper toNetworkMapper = new ToNetworkMapper(this.mController);
        ToNetwork toNetwork = (ToNetwork)toNetworkMapper.get(node.getEntity());
        if (toNetwork != null) {
            networkNode = (NetworkNode)networkNodeMapper.get(toNetwork.getNetworkEntity());
        }
        if (networkNode != null) {
            Collection hosts = networkNode.getNetwork().getHosts();
            for (Host host : hosts) {
                for (NetworkInterface ifc : host.getInterfaces()) {
                    if (host.getNetworkNode(ifc) != networkNode) continue;
                    type = "interface";
                }
            }
        }
        return type;
    }

    private class ColorDaemon
    extends Thread {
        ChannelStateful mChannelStateful;
        long mActiveGraph = 0L;

        ColorDaemon(ChannelStateful channelStateful, long activeGraphId) {
            this.mChannelStateful = channelStateful;
            this.mActiveGraph = activeGraphId;
            this.setDaemon(true);
        }

        @Override
        public void run() {
            while (this.mChannelStateful.isPolling() && this.mChannelStateful.getActiveGraph() == this.mActiveGraph) {
                NettyInboundHandler.this.sendAllColors(this.mChannelStateful, this.mActiveGraph);
                try {
                    ColorDaemon.sleep(100L);
                }
                catch (InterruptedException e) {
                    return;
                }
            }
            return;
        }
    }
}

