/*
 * Decompiled with CFR 0.152.
 */
package de.tum.ei.lkn.eces.routing.pathlist;

import de.tum.ei.lkn.eces.core.Controller;
import de.tum.ei.lkn.eces.graph.Edge;
import de.tum.ei.lkn.eces.routing.mappers.PathListMapper;
import de.tum.ei.lkn.eces.routing.pathlist.PathList;
import de.tum.ei.lkn.eces.webgraphgui.color.ColoringScheme;
import de.tum.ei.lkn.eces.webgraphgui.color.RGBColor;

public class PathListColoring
implements ColoringScheme {
    private PathListMapper pathListMapper;
    private int maxValue;

    public PathListColoring(Controller controller, int maxValue) {
        this.pathListMapper = new PathListMapper(controller);
        this.maxValue = maxValue;
    }

    public PathListColoring(Controller controller) {
        this(controller, 0);
    }

    @Override
    public String getColor(Edge edge) {
        if (this.pathListMapper.isIn(edge.getEntity())) {
            int size = ((PathList)this.pathListMapper.get(edge.getEntity())).getPathList().size();
            this.updateMaxValue(size);
            return RGBColor.percentToColor((double)size / (double)this.maxValue);
        }
        return RGBColor.gray();
    }

    @Override
    public boolean isPolling(Edge edge) {
        return true;
    }

    private void updateMaxValue(int value) {
        this.maxValue = value > this.maxValue ? value : this.maxValue;
    }
}

