/*
 * Decompiled with CFR 0.152.
 */
package de.tum.ei.lkn.eces.network.color;

import de.tum.ei.lkn.eces.core.Controller;
import de.tum.ei.lkn.eces.core.Mapper;
import de.tum.ei.lkn.eces.graph.Edge;
import de.tum.ei.lkn.eces.network.Queue;
import de.tum.ei.lkn.eces.network.mappers.QueueMapper;
import de.tum.ei.lkn.eces.webgraphgui.color.ColoringScheme;
import de.tum.ei.lkn.eces.webgraphgui.color.RGBColor;

public class QueueColoring
implements ColoringScheme {
    private Mapper<Queue> queueMapper;
    private double maxSize;

    public QueueColoring(Controller controller) {
        this.queueMapper = new QueueMapper(controller);
        this.maxSize = 0.0;
    }

    @Override
    public String getColor(Edge edge) {
        Queue queue = (Queue)this.queueMapper.get(edge.getEntity());
        if (queue != null) {
            this.updateMaxSize(queue.getSize());
            return RGBColor.percentToColor(1.0 - queue.getSize() / this.maxSize);
        }
        return RGBColor.gray();
    }

    private void updateMaxSize(double size) {
        this.maxSize = size > this.maxSize ? size : this.maxSize;
    }

    @Override
    public boolean isPolling(Edge edge) {
        return true;
    }
}

