/*
 * Decompiled with CFR 0.152.
 */
package de.tum.ei.lkn.eces.dnm.color;

import de.tum.ei.lkn.eces.core.Controller;
import de.tum.ei.lkn.eces.dnm.mappers.MHMQueueModelMapper;
import de.tum.ei.lkn.eces.dnm.queuemodels.MHMQueueModel;
import de.tum.ei.lkn.eces.graph.Edge;
import de.tum.ei.lkn.eces.webgraphgui.color.ColoringScheme;
import de.tum.ei.lkn.eces.webgraphgui.color.RGBColor;

public class AssignedRateColoring
implements ColoringScheme {
    private Controller controller;
    private double maxRate;

    public AssignedRateColoring(Controller controller) {
        this.controller = controller;
        this.maxRate = 0.0;
    }

    @Override
    public String getColor(Edge edge) {
        double value;
        try {
            value = this.getAvailableRate(edge);
        }
        catch (RuntimeException e) {
            return RGBColor.gray();
        }
        this.updateMaxAvailableRate(value);
        return RGBColor.percentToColor(1.0 - value / this.maxRate);
    }

    public double getAvailableRate(Edge edge) {
        if (new MHMQueueModelMapper(this.controller).isIn(edge.getEntity())) {
            return ((MHMQueueModel)new MHMQueueModelMapper(this.controller).get(edge.getEntity())).getMaximumTokenBucket().getUltAffineRate().doubleValue();
        }
        throw new RuntimeException("Not implemented");
    }

    private void updateMaxAvailableRate(double rate) {
        this.maxRate = rate > this.maxRate ? rate : this.maxRate;
    }

    @Override
    public boolean isPolling(Edge edge) {
        return true;
    }
}

