/*
 * Decompiled with CFR 0.152.
 */
package de.tum.ei.lkn.eces.dnm.color;

import de.tum.ei.lkn.eces.core.Controller;
import de.tum.ei.lkn.eces.dnm.mappers.MHMQueueModelMapper;
import de.tum.ei.lkn.eces.dnm.queuemodels.MHMQueueModel;
import de.tum.ei.lkn.eces.graph.Edge;
import de.tum.ei.lkn.eces.webgraphgui.color.ColoringScheme;
import de.tum.ei.lkn.eces.webgraphgui.color.RGBColor;

public class AssignedBufferColoring
implements ColoringScheme {
    private double maxBurst = 0.0;
    private MHMQueueModelMapper mhmQueueModelMapper;

    public AssignedBufferColoring(Controller controller) {
        this.mhmQueueModelMapper = new MHMQueueModelMapper(controller);
    }

    @Override
    public String getColor(Edge edge) {
        double value;
        try {
            value = this.getAvailableBuffer(edge);
        }
        catch (RuntimeException e) {
            return RGBColor.gray();
        }
        this.updateMaxAvailableBuffer(value);
        return RGBColor.percentToColor(1.0 - value / this.maxBurst);
    }

    public double getAvailableBuffer(Edge edge) {
        if (this.mhmQueueModelMapper.isIn(edge.getEntity())) {
            return ((MHMQueueModel)this.mhmQueueModelMapper.get(edge.getEntity())).getMaximumTokenBucket().getBurst().doubleValue();
        }
        throw new RuntimeException("Not implemented");
    }

    private void updateMaxAvailableBuffer(double burst) {
        this.maxBurst = burst > this.maxBurst ? burst : this.maxBurst;
    }

    @Override
    public boolean isPolling(Edge edge) {
        return true;
    }
}

