/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutest.util.validation;

import de.tracetronic.jenkins.plugins.ecutest.filter.RefFilterLexer;
import de.tracetronic.jenkins.plugins.ecutest.filter.RefFilterParser;
import de.tracetronic.jenkins.plugins.ecutest.test.Messages;
import de.tracetronic.jenkins.plugins.ecutest.util.validation.AbstractValidator;
import hudson.util.FormValidation;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.apache.commons.lang.StringUtils;

public class TestValidator
extends AbstractValidator {
    public FormValidation validateTestFolder(String testFolder) {
        FormValidation returnValue = FormValidation.ok();
        if (StringUtils.isBlank((String)testFolder)) {
            returnValue = FormValidation.validateRequired((String)testFolder);
        } else if (testFolder.contains("$")) {
            returnValue = FormValidation.warning((String)Messages.Builder_NoValidatedValue());
        }
        return returnValue;
    }

    public FormValidation validateTbcFile(String tbcFile) {
        FormValidation returnValue = FormValidation.ok();
        if (StringUtils.isBlank((String)tbcFile)) {
            returnValue = FormValidation.warning((String)Messages.TestBuilder_NoTbcFile());
        } else if (tbcFile.contains("$")) {
            returnValue = FormValidation.warning((String)Messages.Builder_NoValidatedValue());
        } else if (!tbcFile.endsWith(".tbc")) {
            returnValue = FormValidation.error((String)Messages.TestBuilder_TbcFileExtension());
        }
        return returnValue;
    }

    public FormValidation validateTcfFile(String tcfFile) {
        FormValidation returnValue = FormValidation.ok();
        if (StringUtils.isBlank((String)tcfFile)) {
            returnValue = FormValidation.warning((String)Messages.TestBuilder_NoTcfFile());
        } else if (tcfFile.contains("$")) {
            returnValue = FormValidation.warning((String)Messages.Builder_NoValidatedValue());
        } else if (!tcfFile.endsWith(".tcf")) {
            returnValue = FormValidation.error((String)Messages.TestBuilder_TcfFileExtension());
        }
        return returnValue;
    }

    public FormValidation validateParameterName(String name) {
        FormValidation returnValue = FormValidation.ok();
        if (StringUtils.isBlank((String)name)) {
            returnValue = FormValidation.validateRequired((String)name);
        } else if (name.contains("$")) {
            returnValue = FormValidation.warning((String)Messages.Builder_NoValidatedValue());
        } else if (!this.isValidVariableName(name)) {
            returnValue = FormValidation.error((String)Messages.PackageParameter_InvalidName());
        }
        return returnValue;
    }

    public FormValidation validateParameterValue(String value) {
        FormValidation returnValue = FormValidation.ok();
        if (StringUtils.isBlank((String)value)) {
            returnValue = FormValidation.validateRequired((String)value);
        } else if (value.contains("$")) {
            returnValue = FormValidation.warning((String)Messages.Builder_NoValidatedValue());
        }
        return returnValue;
    }

    public FormValidation validateGlobalConstantName(String name) {
        FormValidation returnValue = FormValidation.ok();
        if (StringUtils.isBlank((String)name)) {
            returnValue = FormValidation.validateRequired((String)name);
        } else if (name.contains("$")) {
            returnValue = FormValidation.warning((String)Messages.Builder_NoValidatedValue());
        } else if (!this.isValidVariableName(name)) {
            returnValue = FormValidation.error((String)Messages.GlobalConstant_InvalidName());
        }
        return returnValue;
    }

    public FormValidation validateGlobalConstantValue(String value) {
        FormValidation returnValue = FormValidation.ok();
        if (StringUtils.isBlank((String)value)) {
            returnValue = FormValidation.validateRequired((String)value);
        } else if (value.contains("$")) {
            returnValue = FormValidation.warning((String)Messages.Builder_NoValidatedValue());
        }
        return returnValue;
    }

    public FormValidation validateFilterExpression(String filterExpression) {
        FormValidation returnValue = FormValidation.ok();
        if (!StringUtils.isBlank((String)filterExpression)) {
            if (filterExpression.contains("$")) {
                returnValue = FormValidation.warning((String)Messages.Builder_NoValidatedValue());
            } else {
                String trimmedExpression = StringUtils.trimToEmpty((String)filterExpression).replaceAll("^\\(\\s*", "(").replaceAll("\\s*\\)", ")");
                FilterExpressionValidator validator = new FilterExpressionValidator(trimmedExpression);
                validator.validate();
                if (!validator.isValid()) {
                    returnValue = FormValidation.warning((String)Messages.TestProjectBuilder_InvalidFilterExpression());
                }
            }
        }
        return returnValue;
    }

    private boolean isValidVariableName(String name) {
        Pattern pattern = Pattern.compile("^[a-zA-Z_][\\w]*$");
        Matcher matcher = pattern.matcher(name);
        return matcher.matches();
    }

    private static final class FilterExpressionValidator {
        private final String expression;
        private boolean isValid;

        FilterExpressionValidator(String expression) {
            this.expression = expression;
        }

        public void validate() {
            this.isValid = true;
            try (ByteArrayInputStream stream = new ByteArrayInputStream(this.expression.getBytes(StandardCharsets.UTF_8));){
                RefFilterLexer lexer = new RefFilterLexer(CharStreams.fromStream((InputStream)stream, (Charset)StandardCharsets.UTF_8));
                RefFilterParser parser = new RefFilterParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
                lexer.removeErrorListeners();
                lexer.addErrorListener((ANTLRErrorListener)new BaseErrorListener(){

                    public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
                        isValid = false;
                    }
                });
                parser.removeErrorListeners();
                parser.addErrorListener((ANTLRErrorListener)new BaseErrorListener(){

                    public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
                        isValid = false;
                    }
                });
                parser.filterExpression();
            }
            catch (IOException e) {
                e.printStackTrace();
                this.isValid = false;
            }
        }

        public boolean isValid() {
            return this.isValid;
        }
    }
}

