/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutest.util.validation;

import de.tracetronic.jenkins.plugins.ecutest.report.atx.Messages;
import de.tracetronic.jenkins.plugins.ecutest.report.atx.installation.ATXConfig;
import de.tracetronic.jenkins.plugins.ecutest.report.atx.installation.ATXInstallation;
import de.tracetronic.jenkins.plugins.ecutest.util.ATXUtil;
import de.tracetronic.jenkins.plugins.ecutest.util.validation.AbstractValidator;
import hudson.Util;
import hudson.util.FormValidation;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.regex.Pattern;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.lang.StringUtils;

public class ATXValidator
extends AbstractValidator {
    public FormValidation validateName(String value) {
        return FormValidation.validateRequired((String)value);
    }

    public FormValidation validateServerUrl(String serverUrl) {
        FormValidation returnValue = FormValidation.validateRequired((String)serverUrl);
        if (returnValue == FormValidation.ok()) {
            if (serverUrl.contains("$")) {
                returnValue = FormValidation.warning((String)Messages.ATXPublisher_NoValidatedValue());
            } else if (serverUrl.startsWith("http://") || serverUrl.startsWith("https://")) {
                returnValue = FormValidation.error((String)Messages.ATXPublisher_InvalidServerUrlProtocol());
            } else if (ATXValidator.isValidURL(serverUrl)) {
                returnValue = FormValidation.error((String)Messages.ATXPublisher_InvalidServerUrl(serverUrl));
            }
        }
        return returnValue;
    }

    private static boolean isValidURL(String url) {
        try {
            URL u = new URL(url);
            u.toURI();
        }
        catch (MalformedURLException | URISyntaxException e) {
            return false;
        }
        return true;
    }

    public FormValidation validateServerPort(String serverPort) {
        FormValidation returnValue = FormValidation.validateRequired((String)serverPort);
        if (returnValue == FormValidation.ok()) {
            if (serverPort.contains("$")) {
                returnValue = FormValidation.warning((String)Messages.ATXPublisher_NoValidatedValue());
            } else {
                returnValue = FormValidation.validatePositiveInteger((String)serverPort);
                if (returnValue == FormValidation.ok()) {
                    int port = Integer.parseInt(serverPort);
                    if (port > 65535) {
                        returnValue = FormValidation.error((String)Messages.ATXPublisher_InvalidPort());
                    } else if (port <= 1024) {
                        returnValue = FormValidation.warning((String)Messages.ATXPublisher_NeedsAdmin());
                    }
                }
            }
        }
        return returnValue;
    }

    public FormValidation validateServerContextPath(String contextPath) {
        FormValidation returnValue = FormValidation.ok();
        if (!StringUtils.isEmpty((String)contextPath)) {
            if (contextPath.contains("$")) {
                returnValue = FormValidation.warning((String)Messages.ATXPublisher_NoValidatedValue());
            } else {
                String pattern = "^[A-Za-z0-9./\\-_]+";
                if (!Pattern.matches("^[A-Za-z0-9./\\-_]+", contextPath)) {
                    returnValue = FormValidation.error((String)Messages.ATXPublisher_InvalidServerContextPath());
                }
            }
        }
        return returnValue;
    }

    public FormValidation validateArchiveMiscFiles(String expression) {
        FormValidation returnValue = FormValidation.ok();
        if (!StringUtils.isEmpty((String)expression)) {
            if (expression.contains("$")) {
                returnValue = FormValidation.warning((String)Messages.ATXPublisher_NoValidatedValue());
            } else {
                String pattern = "[A-Za-z0-9./\\*]+";
                for (String token : Util.tokenize((String)expression, (String)";")) {
                    if (Pattern.matches("[A-Za-z0-9./\\*]+", token)) continue;
                    returnValue = FormValidation.error((String)Messages.ATXPublisher_InvalidFileExpression());
                    break;
                }
            }
        }
        return returnValue;
    }

    public FormValidation validateCoveredAttributes(String expression) {
        FormValidation returnValue = FormValidation.ok();
        if (!StringUtils.isEmpty((String)expression)) {
            if (expression.contains("$")) {
                returnValue = FormValidation.warning((String)Messages.ATXPublisher_NoValidatedValue());
            } else {
                String pattern = "(Designer|Name|Status|Testlevel|Tools|VersionCounter|Design Contact|Design Department|Estimated Duration \\[min\\]|Execution Priority|Test Comment)";
                for (String token : Util.tokenize((String)expression, (String)";")) {
                    if (Pattern.matches("(Designer|Name|Status|Testlevel|Tools|VersionCounter|Design Contact|Design Department|Estimated Duration \\[min\\]|Execution Priority|Test Comment)", token)) continue;
                    returnValue = FormValidation.warning((String)Messages.ATXPublisher_CustomAttributeExpression());
                    break;
                }
            }
        }
        return returnValue;
    }

    public FormValidation validateSetting(String name, String value) {
        FormValidation returnValue = FormValidation.ok();
        if (name != null) {
            switch (name) {
                case "serverURL": {
                    returnValue = this.validateServerUrl(value);
                    break;
                }
                case "serverPort": {
                    returnValue = this.validateServerPort(value);
                    break;
                }
                case "serverContextPath": {
                    returnValue = this.validateServerContextPath(value);
                    break;
                }
                case "archiveMiscFiles": {
                    returnValue = this.validateArchiveMiscFiles(value);
                    break;
                }
                case "coveredAttributes": {
                    returnValue = this.validateCoveredAttributes(value);
                    break;
                }
                default: {
                    returnValue = this.validateParameterizedValue(value);
                }
            }
        }
        return returnValue;
    }

    public FormValidation validateCustomSettingName(String name) {
        FormValidation returnValue = FormValidation.validateRequired((String)name);
        if (!StringUtils.isAlpha((String)name)) {
            returnValue = FormValidation.error((String)Messages.ATXPublisher_InvalidSettingName());
        } else {
            ATXConfig config;
            ATXInstallation[] installations = ATXInstallation.all();
            if (installations.length > 0 && (config = installations[0].getConfig()) != null && config.getSettingByName(name) != null) {
                returnValue = FormValidation.warning((String)Messages.ATXPublisher_DuplicateSetting());
            }
        }
        return returnValue;
    }

    public FormValidation validateCustomSettingValue(String value) {
        return this.validateParameterizedValue(value);
    }

    public FormValidation testConnection(String serverUrl, String serverPort, String serverContextPath, boolean useHttpsConnection) {
        String baseUrl = ATXUtil.getBaseUrl(serverUrl, serverPort, serverContextPath, useHttpsConnection);
        return this.testConnection(baseUrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FormValidation testConnection(String baseUrl) {
        FormValidation returnValue;
        block27: {
            if (StringUtils.isBlank((String)baseUrl)) {
                return FormValidation.error((String)Messages.ATXPublisher_InvalidServerUrl(null));
            }
            String appVersionUrl = String.format("%s/app-version-info", baseUrl);
            returnValue = FormValidation.okWithMarkup((String)String.format("<span style=\"font-weight: bold; color: #208CA3\">%s</span>", Messages.ATXPublisher_ValidConnection(baseUrl)));
            if (appVersionUrl.contains("$")) {
                returnValue = FormValidation.warning((String)Messages.ATXPublisher_NoValidatedConnection());
            } else {
                HttpURLConnection connection = null;
                try {
                    URL url = new URL(appVersionUrl);
                    if (appVersionUrl.startsWith("https://")) {
                        ATXValidator.initSSLConnection();
                        connection = (HttpsURLConnection)url.openConnection();
                    } else {
                        connection = (HttpURLConnection)url.openConnection();
                    }
                    connection.setConnectTimeout(30000);
                    connection.setReadTimeout(30000);
                    connection.setUseCaches(false);
                    connection.setRequestMethod("GET");
                    connection.connect();
                    int httpResponse = connection.getResponseCode();
                    if (httpResponse != 200) {
                        returnValue = FormValidation.warning((String)Messages.ATXPublisher_ServerNotReachable(baseUrl));
                        break block27;
                    }
                    try (BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream(), Charset.forName("UTF-8")));){
                        String inputLine = in.readLine();
                        if (inputLine == null || !inputLine.contains("TraceTronic")) {
                            returnValue = FormValidation.warning((String)Messages.ATXPublisher_InvalidServer(baseUrl));
                        }
                    }
                }
                catch (MalformedURLException e) {
                    returnValue = FormValidation.error((String)Messages.ATXPublisher_InvalidServerUrl(baseUrl));
                }
                catch (IOException | KeyManagementException | NoSuchAlgorithmException e) {
                    returnValue = FormValidation.warning((String)Messages.ATXPublisher_ServerNotReachable(baseUrl));
                }
                finally {
                    if (connection != null) {
                        connection.disconnect();
                    }
                }
            }
        }
        return returnValue;
    }

    public static void initSSLConnection() throws NoSuchAlgorithmException, KeyManagementException {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        SSLContext sslContext = SSLContext.getInstance("SSL");
        sslContext.init(null, trustAllCerts, new SecureRandom());
        HttpsURLConnection.setDefaultSSLSocketFactory(sslContext.getSocketFactory());
        HostnameVerifier allHostsValid = new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        };
        HttpsURLConnection.setDefaultHostnameVerifier(allHostsValid);
    }
}

