/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutest.tool;

import de.tracetronic.jenkins.plugins.ecutest.ETPluginException;
import de.tracetronic.jenkins.plugins.ecutest.tool.AbstractToolBuilder;
import de.tracetronic.jenkins.plugins.ecutest.tool.AbstractToolDescriptor;
import de.tracetronic.jenkins.plugins.ecutest.tool.Messages;
import de.tracetronic.jenkins.plugins.ecutest.tool.client.TSClient;
import de.tracetronic.jenkins.plugins.ecutest.util.EnvUtil;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import javax.annotation.Nonnull;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;

public class StopTSBuilder
extends AbstractToolBuilder {
    public static final int DEFAULT_TIMEOUT = 30;

    @DataBoundConstructor
    public StopTSBuilder(@Nonnull String toolName) {
        super(toolName);
    }

    @Override
    public int getDefaultTimeout() {
        return 30;
    }

    @Override
    public void performTool(Run<?, ?> run, FilePath workspace, Launcher launcher, TaskListener listener) throws InterruptedException, IOException, ETPluginException {
        EnvVars buildEnvVars = run.getEnvironment(listener);
        int expTimeout = Integer.parseInt(EnvUtil.expandEnvVar(this.getTimeout(), buildEnvVars, String.valueOf(30)));
        TSClient tsClient = new TSClient(this.getToolName(), expTimeout);
        if (!tsClient.stop(true, workspace, launcher, listener)) {
            throw new ETPluginException("Stopping Tool-Server failed.");
        }
    }

    @Symbol(value={"stopTS"})
    @Extension(ordinal=10007.0)
    public static final class DescriptorImpl
    extends AbstractToolDescriptor {
        @Override
        public int getDefaultTimeout() {
            return 30;
        }

        public String getDisplayName() {
            return Messages.StopTSBuilder_DisplayName();
        }
    }
}

