/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutest.tool;

import de.tracetronic.jenkins.plugins.ecutest.ETPluginException;
import de.tracetronic.jenkins.plugins.ecutest.env.ToolEnvInvisibleAction;
import de.tracetronic.jenkins.plugins.ecutest.log.TTConsoleLogger;
import de.tracetronic.jenkins.plugins.ecutest.report.log.ETLogPublisher;
import de.tracetronic.jenkins.plugins.ecutest.tool.AbstractToolBuilder;
import de.tracetronic.jenkins.plugins.ecutest.tool.AbstractToolDescriptor;
import de.tracetronic.jenkins.plugins.ecutest.tool.Messages;
import de.tracetronic.jenkins.plugins.ecutest.tool.client.ETClient;
import de.tracetronic.jenkins.plugins.ecutest.tool.installation.ETInstallation;
import de.tracetronic.jenkins.plugins.ecutest.util.EnvUtil;
import de.tracetronic.jenkins.plugins.ecutest.util.PathUtil;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.Action;
import hudson.model.Job;
import hudson.model.Project;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.FormValidation;
import java.io.IOException;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class StartETBuilder
extends AbstractToolBuilder {
    public static final int DEFAULT_TIMEOUT = 120;
    @CheckForNull
    private String workspaceDir;
    @CheckForNull
    private String settingsDir;
    private boolean debugMode;
    private boolean keepInstance;

    @DataBoundConstructor
    public StartETBuilder(@Nonnull String toolName) {
        super(toolName);
    }

    @Override
    public int getDefaultTimeout() {
        return 120;
    }

    @Nonnull
    public String getWorkspaceDir() {
        return StringUtils.trimToEmpty((String)this.workspaceDir);
    }

    @Nonnull
    public String getSettingsDir() {
        return StringUtils.trimToEmpty((String)this.settingsDir);
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    public boolean isKeepInstance() {
        return this.keepInstance;
    }

    @DataBoundSetter
    public void setWorkspaceDir(@CheckForNull String workspaceDir) {
        this.workspaceDir = Util.fixNull((String)workspaceDir);
    }

    @DataBoundSetter
    public void setSettingsDir(@CheckForNull String settingsDir) {
        this.settingsDir = Util.fixNull((String)settingsDir);
    }

    @DataBoundSetter
    public void setDebugMode(boolean debugMode) {
        this.debugMode = debugMode;
    }

    @DataBoundSetter
    public void setKeepInstance(boolean keepInstance) {
        this.keepInstance = keepInstance;
    }

    @Override
    public void performTool(Run<?, ?> run, FilePath workspace, Launcher launcher, TaskListener listener) throws InterruptedException, IOException, ETPluginException {
        List<String> foundProcesses = ETClient.checkProcesses(launcher, false);
        if (this.isKeepInstance() && !foundProcesses.isEmpty()) {
            TTConsoleLogger logger = new TTConsoleLogger(listener);
            logger.logInfo("Re-using already running ECU-TEST instance...");
        } else {
            String installPath;
            EnvVars buildEnvVars = run.getEnvironment(listener);
            int expTimeout = Integer.parseInt(EnvUtil.expandEnvVar(this.getTimeout(), buildEnvVars, String.valueOf(120)));
            String expWorkspaceDir = EnvUtil.expandEnvVar(this.getWorkspaceDir(), buildEnvVars, workspace.getRemote());
            expWorkspaceDir = PathUtil.makeAbsolutePath(expWorkspaceDir, workspace);
            String expSettingsDir = EnvUtil.expandEnvVar(this.getSettingsDir(), buildEnvVars, workspace.getRemote());
            expSettingsDir = PathUtil.makeAbsolutePath(expSettingsDir, workspace);
            FilePath expWorkspacePath = new FilePath(launcher.getChannel(), expWorkspaceDir);
            FilePath expSettingsPath = new FilePath(launcher.getChannel(), expSettingsDir);
            this.checkWorkspace(expWorkspacePath, expSettingsPath);
            Job parent = run.getParent();
            if (parent instanceof Project && ((Project)run.getParent()).getPublishersList().get(ETLogPublisher.class) != null) {
                ETLogPublisher.RunListenerImpl.onStarted(expSettingsPath, listener);
            }
            ETInstallation installation = this.configureToolInstallation(workspace.toComputer(), listener, run.getEnvironment(listener));
            String toolName = run.getEnvironment(listener).expand(installation.getName());
            ETClient etClient = new ETClient(toolName, installPath = installation.getExecutable(launcher), expWorkspaceDir, expSettingsDir, expTimeout, this.isDebugMode());
            if (!etClient.start(true, workspace, launcher, listener)) {
                throw new ETPluginException(String.format("Starting %s failed!", toolName));
            }
            int toolId = this.getToolId(run);
            ToolEnvInvisibleAction envAction = new ToolEnvInvisibleAction(toolId, etClient);
            run.addAction((Action)envAction);
        }
    }

    private void checkWorkspace(FilePath workspacePath, FilePath settingsPath) throws IOException, InterruptedException, ETPluginException {
        if (!workspacePath.exists()) {
            throw new ETPluginException(String.format("ECU-TEST workspace at %s does not exist!", workspacePath.getRemote()));
        }
        if (!settingsPath.exists()) {
            throw new ETPluginException(String.format("ECU-TEST settings directory at %s does not exist!", settingsPath.getRemote()));
        }
    }

    @Symbol(value={"startET"})
    @Extension(ordinal=10010.0)
    public static final class DescriptorImpl
    extends AbstractToolDescriptor {
        @Override
        public int getDefaultTimeout() {
            return 120;
        }

        public String getDisplayName() {
            return Messages.StartETBuilder_DisplayName();
        }

        public FormValidation doCheckWorkspaceDir(@QueryParameter String value) {
            return this.toolValidator.validateWorkspaceDir(value);
        }

        public FormValidation doCheckSettingsDir(@QueryParameter String value) {
            return this.toolValidator.validateSettingsDir(value);
        }
    }
}

