/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutest.test.config;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import de.tracetronic.jenkins.plugins.ecutest.test.config.ExecutionConfig;
import de.tracetronic.jenkins.plugins.ecutest.test.config.ExpandableConfig;
import de.tracetronic.jenkins.plugins.ecutest.util.validation.TMSValidator;
import hudson.DescriptorExtensionList;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import javax.annotation.CheckForNull;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.QueryParameter;

public abstract class TMSConfig
implements Describable<TMSConfig>,
Serializable,
ExpandableConfig {
    private static final long serialVersionUID = 1L;
    protected static final int DEFAULT_TIMEOUT = 60;
    private final String credentialsId;
    private final String timeout;

    public TMSConfig(String credentialsId, String timeout) {
        this.credentialsId = StringUtils.trimToEmpty((String)credentialsId);
        this.timeout = StringUtils.defaultIfBlank((String)timeout, (String)String.valueOf(60));
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    public int getParsedTimeout() {
        return ExecutionConfig.parse(this.getTimeout());
    }

    public String getTimeout() {
        return this.timeout;
    }

    public static int getDefaultTimeout() {
        return 60;
    }

    @CheckForNull
    public StandardUsernamePasswordCredentials getCredentials(Item project) throws IOException, InterruptedException {
        List credentials = CredentialsProvider.lookupCredentials(StandardUsernamePasswordCredentials.class, (Item)project, (Authentication)ACL.SYSTEM, Collections.emptyList());
        return (StandardUsernamePasswordCredentials)CredentialsMatchers.firstOrNull((Iterable)credentials, (CredentialsMatcher)CredentialsMatchers.withId((String)this.credentialsId));
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)Jenkins.getInstance().getDescriptor(this.getClass());
    }

    public static DescriptorExtensionList<TMSConfig, Descriptor<TMSConfig>> all() {
        return Jenkins.getInstance().getDescriptorList(TMSConfig.class);
    }

    public static abstract class DescriptorImpl
    extends Descriptor<TMSConfig> {
        protected final TMSValidator tmsValidator = new TMSValidator();

        public static int getDefaultTimeout() {
            return 60;
        }

        public FormValidation doCheckTimeout(@QueryParameter String value) {
            return this.tmsValidator.validateTimeout(value, DescriptorImpl.getDefaultTimeout());
        }

        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item item, @QueryParameter String credentialsId) {
            StandardListBoxModel result = new StandardListBoxModel();
            if (item == null ? !Jenkins.getInstance().hasPermission(Jenkins.ADMINISTER) : !item.hasPermission(Item.EXTENDED_READ) && !item.hasPermission(CredentialsProvider.USE_ITEM)) {
                return result.includeCurrentValue(credentialsId);
            }
            return result.includeEmptyValue().includeMatchingAs(ACL.SYSTEM, item, StandardCredentials.class, Collections.emptyList(), CredentialsMatchers.instanceOf(StandardUsernamePasswordCredentials.class));
        }
    }
}

